/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle.sync;

import com.android.tools.idea.projectsystem.gradle.sync.PerformanceMeasurementUtilKt;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001d\u001a\u00020\u001eJ\"\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"H\u0082\b\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u0003H\u0016J\"\u0010%\u001a\u0002H \"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"H\u0086\u0002\u00a2\u0006\u0002\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/projectsystem/gradle/sync/Counter;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "totalCpu", "Ljava/util/concurrent/atomic/AtomicLong;", "totalWall", "maxCpu", "maxWall", "count", "Ljava/util/concurrent/atomic/AtomicInteger;", "totalCpuNanos", "", "getTotalCpuNanos", "()J", "maxCpuNanos", "getMaxCpuNanos", "totalWallNanos", "getTotalWallNanos", "maxWallNanos", "getMaxWallNanos", "totalCount", "", "getTotalCount", "()I", "reset", "", "time", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "toString", "invoke", "intellij.android.projectSystem.gradle.sync"})
@SourceDebugExtension(value={"SMAP\nPerformanceMeasurementUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformanceMeasurementUtil.kt\ncom/android/tools/idea/projectsystem/gradle/sync/Counter\n*L\n1#1,104:1\n57#1,13:105\n*S KotlinDebug\n*F\n+ 1 PerformanceMeasurementUtil.kt\ncom/android/tools/idea/projectsystem/gradle/sync/Counter\n*L\n96#1:105,13\n*E\n"})
public final class Counter {
    @NotNull
    private final String name;
    @NotNull
    private final AtomicLong totalCpu;
    @NotNull
    private final AtomicLong totalWall;
    @NotNull
    private final AtomicLong maxCpu;
    @NotNull
    private final AtomicLong maxWall;
    @NotNull
    private final AtomicInteger count;

    public Counter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.totalCpu = new AtomicLong();
        this.totalWall = new AtomicLong();
        this.maxCpu = new AtomicLong();
        this.maxWall = new AtomicLong();
        this.count = new AtomicInteger();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final long getTotalCpuNanos() {
        return this.totalCpu.get();
    }

    public final long getMaxCpuNanos() {
        return this.maxCpu.get();
    }

    public final long getTotalWallNanos() {
        return this.totalWall.get();
    }

    public final long getMaxWallNanos() {
        return this.maxWall.get();
    }

    public final int getTotalCount() {
        return this.count.get();
    }

    public final void reset() {
        this.totalCpu.set(0L);
        this.maxCpu.set(0L);
        this.totalWall.set(0L);
        this.maxWall.set(0L);
        this.count.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R time(Function0<? extends R> block) {
        Object object;
        boolean $i$f$time = false;
        long startWall = PerformanceMeasurementUtilKt.access$getCurrentTimeNano();
        long startCpu = PerformanceMeasurementUtilKt.access$getCurrentThreadCpuTime();
        try {
            object = block.invoke();
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart((int)1);
            long deltaWall = PerformanceMeasurementUtilKt.access$getCurrentTimeNano() - startWall;
            long deltaCpu = PerformanceMeasurementUtilKt.access$getCurrentThreadCpuTime() - startCpu;
            this.totalCpu.addAndGet(deltaCpu);
            this.maxCpu.updateAndGet(new LongUnaryOperator(deltaCpu){
                final /* synthetic */ long $deltaCpu;
                {
                    this.$deltaCpu = $deltaCpu;
                }

                public final long applyAsLong(long it) {
                    return Long.max(it, this.$deltaCpu);
                }
            });
            this.totalWall.addAndGet(deltaWall);
            this.maxWall.updateAndGet(new LongUnaryOperator(deltaWall){
                final /* synthetic */ long $deltaWall;
                {
                    this.$deltaWall = $deltaWall;
                }

                public final long applyAsLong(long it) {
                    return Long.max(it, this.$deltaWall);
                }
            });
            this.count.incrementAndGet();
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)1);
        long deltaWall = PerformanceMeasurementUtilKt.access$getCurrentTimeNano() - startWall;
        long deltaCpu = PerformanceMeasurementUtilKt.access$getCurrentThreadCpuTime() - startCpu;
        this.totalCpu.addAndGet(deltaCpu);
        this.maxCpu.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this.totalWall.addAndGet(deltaWall);
        this.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this.count.incrementAndGet();
        InlineMarker.finallyEnd((int)1);
        return (R)object;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int totalCount = this.count.get();
        if (totalCount > 0) {
            double avgCpuMicros = (double)(this.getTotalCpuNanos() / (long)totalCount / (long)100) / 10.0;
            double maxCpuMicros = (double)(this.getMaxCpuNanos() / (long)100) / 10.0;
            double totalCpuMillis = (double)(this.getTotalCpuNanos() / (long)100000) / 10.0;
            double avgWallMicros = (double)(this.getTotalWallNanos() / (long)totalCount / (long)100) / 10.0;
            double maxWallMicros = (double)(this.getMaxWallNanos() / (long)100) / 10.0;
            double totalWallMillis = (double)(this.getTotalWallNanos() / (long)100000) / 10.0;
            Object[] objectArray = new String[]{"Counter:     ", this.name, " \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u240, (String[])objectArray);
            objectArray = new Object[]{"    Count:     ", totalCount, " \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u240, (Object[])objectArray);
            objectArray = new String[]{"    TotalCpu:  ", PerformanceMeasurementUtilKt.format(totalCpuMillis), "ms \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u240, (String[])objectArray);
            objectArray = new String[]{"    TotalWall: ", PerformanceMeasurementUtilKt.format(totalWallMillis), "ms \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u240, (String[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u240.append('\n'), (String)"append(...)");
            objectArray = new String[]{"    AvgCpu:    ", PerformanceMeasurementUtilKt.format(avgCpuMicros), "\u03bcs \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u240, (String[])objectArray);
            objectArray = new String[]{"    MaxCpu:    ", PerformanceMeasurementUtilKt.format(maxCpuMicros), "\u03bcs \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u240, (String[])objectArray);
            objectArray = new String[]{"    AvgWall:   ", PerformanceMeasurementUtilKt.format(avgWallMicros), "\u03bcs \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u240, (String[])objectArray);
            objectArray = new String[]{"    MaxWall:   ", PerformanceMeasurementUtilKt.format(maxWallMicros), "\u03bcs \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u240, (String[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u240.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R invoke(@NotNull Function0<? extends R> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Counter this_$iv = this;
        boolean $i$f$time = false;
        long startWall$iv = PerformanceMeasurementUtilKt.access$getCurrentTimeNano();
        long startCpu$iv = PerformanceMeasurementUtilKt.access$getCurrentThreadCpuTime();
        try {
            object = block.invoke();
        }
        catch (Throwable throwable) {
            long deltaWall$iv = PerformanceMeasurementUtilKt.access$getCurrentTimeNano() - startWall$iv;
            long deltaCpu$iv = PerformanceMeasurementUtilKt.access$getCurrentThreadCpuTime() - startCpu$iv;
            this_$iv.totalCpu.addAndGet(deltaCpu$iv);
            this_$iv.maxCpu.updateAndGet(new /* invalid duplicate definition of identical inner class */);
            this_$iv.totalWall.addAndGet(deltaWall$iv);
            this_$iv.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
            this_$iv.count.incrementAndGet();
            throw throwable;
        }
        long deltaWall$iv = PerformanceMeasurementUtilKt.access$getCurrentTimeNano() - startWall$iv;
        long deltaCpu$iv = PerformanceMeasurementUtilKt.access$getCurrentThreadCpuTime() - startCpu$iv;
        this_$iv.totalCpu.addAndGet(deltaCpu$iv);
        this_$iv.maxCpu.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this_$iv.totalWall.addAndGet(deltaWall$iv);
        this_$iv.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this_$iv.count.incrementAndGet();
        return (R)object;
    }
}

