/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.diagnostic.KaptError;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0014\u0010\u000f\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\f\u0010\u0010\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0014\u0010\u0018\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\f\u0010\u0019\u001a\u00020\u0017*\u00020\u0003H\u0002\u001a\u0014\u0010\u001a\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\bH\u0002\u001a\u001e\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u0018\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u0003H\u0002\"\u000e\u0010\t\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\"\u0018\u0010\u000e\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\"\u000e\u0010\u001c\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"parse", "", "lineText", "", "reader", "Lcom/android/ide/common/blame/parser/util/OutputLineReader;", "messages", "", "Lcom/android/ide/common/blame/Message;", "COLON", "KOTLIN_POSITION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "JAVAC_POSITION_PATTERN", "amendNextLinesIfNeeded", "isNextMessage", "startsWithSeverityPrefix", "getMessageKind", "Lcom/android/ide/common/blame/Message$Kind;", "kind", "substringAfterAndTrim", "index", "", "substringBeforeAndTrim", "colon", "skipDriveOnWin", "line", "KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT", "isKaptErrorWhileAnnotationProcessing", "message", "addMessage", "createMessage", "messageKind", "text", "intellij.android.kotlin.output.parser"})
@SourceDebugExtension(value={"SMAP\nKotlinOutputParserHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinOutputParserHelper.kt\norg/jetbrains/kotlin/android/KotlinOutputParserHelperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
public final class KotlinOutputParserHelperKt {
    @NotNull
    private static final String COLON = ":";
    private static final Pattern KOTLIN_POSITION_PATTERN = Pattern.compile("\\(([0-9]*), ([0-9]*)\\)");
    private static final Pattern JAVAC_POSITION_PATTERN = Pattern.compile("([0-9]+)");
    @NotNull
    private static final String KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT = KaptError.class.getCanonicalName() + ": " + KaptError.Kind.ERROR_RAISED.getMessage();

    public static final boolean parse(@NotNull String lineText, @NotNull OutputLineReader reader, @NotNull List<Message> messages) {
        Intrinsics.checkNotNullParameter((Object)lineText, (String)"lineText");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        int colonIndex1 = KotlinOutputParserHelperKt.colon(lineText);
        if (colonIndex1 < 0) {
            return false;
        }
        String severity = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineText, colonIndex1);
        if (!KotlinOutputParserHelperKt.startsWithSeverityPrefix(severity)) {
            return false;
        }
        String lineWoSeverity = KotlinOutputParserHelperKt.substringAfterAndTrim(lineText, colonIndex1);
        int colonIndex2 = KotlinOutputParserHelperKt.skipDriveOnWin(KotlinOutputParserHelperKt.colon(lineWoSeverity), lineWoSeverity);
        if (colonIndex2 >= 0) {
            String path = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineWoSeverity, colonIndex2);
            File file = new File(path);
            String string = FilesKt.getExtension((File)file);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String fileExtension = string2;
            if (!file.isFile() || !Intrinsics.areEqual((Object)fileExtension, (Object)"kt") && !Intrinsics.areEqual((Object)fileExtension, (Object)"java")) {
                return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelperKt.createMessage(KotlinOutputParserHelperKt.getMessageKind(severity), KotlinOutputParserHelperKt.amendNextLinesIfNeeded(lineWoSeverity, reader)), messages);
            }
            String lineWoPath = KotlinOutputParserHelperKt.substringAfterAndTrim(lineWoSeverity, colonIndex2);
            int colonIndex3 = KotlinOutputParserHelperKt.colon(lineWoPath);
            if (colonIndex3 >= 0) {
                Matcher matcher;
                String position = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineWoPath, colonIndex3);
                Matcher it = matcher = KOTLIN_POSITION_PATTERN.matcher(position);
                boolean bl = false;
                Matcher matcher2 = it.matches() ? matcher : null;
                if (matcher2 == null) {
                    matcher2 = JAVAC_POSITION_PATTERN.matcher(position);
                }
                Matcher matcher3 = matcher2;
                String message = KotlinOutputParserHelperKt.amendNextLinesIfNeeded(KotlinOutputParserHelperKt.substringAfterAndTrim(lineWoPath, colonIndex3), reader);
                if (matcher3.matches()) {
                    int column;
                    Integer line;
                    String string3 = matcher3.group(1);
                    Integer n = line = string3 != null ? Integer.valueOf(Integer.parseInt(string3)) : null;
                    if (matcher3.groupCount() >= 2) {
                        String string4 = matcher3.group(2);
                        v6 = string4 != null ? Integer.parseInt(string4) : 1;
                    } else {
                        v6 = column = 1;
                    }
                    if (line != null) {
                        SourceFilePosition position2 = new SourceFilePosition(file, new SourcePosition(line.intValue(), column, column));
                        return KotlinOutputParserHelperKt.addMessage(new Message(KotlinOutputParserHelperKt.getMessageKind(severity), ((Object)StringsKt.trim((CharSequence)message)).toString(), position2, new SourceFilePosition[0]), messages);
                    }
                }
                return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelperKt.createMessage(KotlinOutputParserHelperKt.getMessageKind(severity), message), messages);
            }
            return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelperKt.createMessage(KotlinOutputParserHelperKt.getMessageKind(severity), KotlinOutputParserHelperKt.amendNextLinesIfNeeded(lineWoSeverity, reader)), messages);
        }
        return false;
    }

    private static final String amendNextLinesIfNeeded(String $this$amendNextLinesIfNeeded, OutputLineReader reader) {
        String nextLine = reader.readLine();
        StringBuilder builder = new StringBuilder($this$amendNextLinesIfNeeded);
        while (nextLine != null && !KotlinOutputParserHelperKt.isNextMessage(nextLine)) {
            builder.append("\n").append(nextLine);
            if (!reader.hasNextLine()) break;
            nextLine = reader.readLine();
        }
        if (nextLine != null) {
            Field field;
            try {
                field = reader.getClass().getDeclaredField("myPosition");
            }
            catch (Throwable e) {
                field = null;
            }
            Field positionField = field;
            if (positionField != null) {
                positionField.setAccessible(true);
                positionField.setInt(reader, positionField.getInt(reader) - 1);
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNextMessage(String $this$isNextMessage) {
        int colonIndex1 = StringsKt.indexOf$default((CharSequence)$this$isNextMessage, (String)COLON, (int)0, (boolean)false, (int)6, null);
        if (colonIndex1 == 0) return true;
        if (colonIndex1 >= 0) {
            String string = $this$isNextMessage.substring(0, colonIndex1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            if (KotlinOutputParserHelperKt.startsWithSeverityPrefix(string)) return true;
        }
        if (StringUtil.containsIgnoreCase((String)$this$isNextMessage, (String)"FAILURE")) return true;
        if (!StringUtil.containsIgnoreCase((String)$this$isNextMessage, (String)"FAILED")) return false;
        return true;
    }

    private static final boolean startsWithSeverityPrefix(String $this$startsWithSeverityPrefix) {
        return KotlinOutputParserHelperKt.getMessageKind($this$startsWithSeverityPrefix) != Message.Kind.UNKNOWN;
    }

    private static final Message.Kind getMessageKind(String kind) {
        return switch (kind) {
            case "e" -> Message.Kind.ERROR;
            case "w" -> Message.Kind.WARNING;
            case "i" -> Message.Kind.INFO;
            case "v" -> Message.Kind.SIMPLE;
            default -> Message.Kind.UNKNOWN;
        };
    }

    private static final String substringAfterAndTrim(String $this$substringAfterAndTrim, int index) {
        String string = $this$substringAfterAndTrim.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private static final String substringBeforeAndTrim(String $this$substringBeforeAndTrim, int index) {
        String string = $this$substringBeforeAndTrim.substring(0, index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private static final int colon(String $this$colon) {
        return StringsKt.indexOf$default((CharSequence)$this$colon, (String)COLON, (int)0, (boolean)false, (int)6, null);
    }

    private static final int skipDriveOnWin(int $this$skipDriveOnWin, String line) {
        return $this$skipDriveOnWin == 1 ? StringsKt.indexOf$default((CharSequence)line, (String)COLON, (int)($this$skipDriveOnWin + 1), (boolean)false, (int)4, null) : $this$skipDriveOnWin;
    }

    private static final boolean isKaptErrorWhileAnnotationProcessing(Message message) {
        if (message.getKind() != Message.Kind.ERROR) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)CollectionsKt.singleOrNull((List)message.getSourceFilePositions()), (Object)SourceFilePosition.UNKNOWN)) {
            return false;
        }
        String messageText = message.getText();
        String string = IllegalStateException.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)messageText, (String)string, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)messageText, (CharSequence)KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT, (boolean)false, (int)2, null);
    }

    private static final boolean addMessage(Message message, List<Message> messages) {
        if (KotlinOutputParserHelperKt.isKaptErrorWhileAnnotationProcessing(message)) {
            return true;
        }
        boolean duplicatesPrevious = false;
        int messageCount = messages.size();
        if (messageCount > 0) {
            Message lastMessage = messages.get(messageCount - 1);
            duplicatesPrevious = Intrinsics.areEqual((Object)lastMessage, (Object)message);
        }
        if (!duplicatesPrevious) {
            messages.add(message);
        }
        return true;
    }

    private static final Message createMessage(Message.Kind messageKind, String text) {
        String string = ((Object)StringsKt.trim((CharSequence)text)).toString();
        Optional optional = Optional.absent();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"absent(...)");
        ImmutableList immutableList = ImmutableList.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
        return new Message(messageKind, string, text, optional, immutableList);
    }
}

