/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/android/quickfix/KotlinAndroidViewConstructorUtils;", "", "<init>", "()V", "DESCRIPTION", "", "REQUIRED_SUPERTYPE", "Lorg/jetbrains/kotlin/name/ClassId;", "getREQUIRED_SUPERTYPE", "()Lorg/jetbrains/kotlin/name/ClassId;", "ALLOWED_THREE_PARAMETER_CONSTRUCTOR_DIRECT_SUPERTYPES", "", "getALLOWED_THREE_PARAMETER_CONSTRUCTOR_DIRECT_SUPERTYPES", "()Ljava/util/Set;", "REQUIRED_CONSTRUCTOR_SIGNATURE", "", "getREQUIRED_CONSTRUCTOR_SIGNATURE", "()Ljava/util/List;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lorg/jetbrains/kotlin/psi/KtSuperTypeEntry;", "useThreeParameterConstructor", "", "intellij.android.kotlin.idea.common"})
@SourceDebugExtension(value={"SMAP\nKotlinAndroidViewConstructorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinAndroidViewConstructorUtils.kt\norg/jetbrains/kotlin/android/quickfix/KotlinAndroidViewConstructorUtils\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n26#2,7:73\n1#3:80\n*S KotlinDebug\n*F\n+ 1 KotlinAndroidViewConstructorUtils.kt\norg/jetbrains/kotlin/android/quickfix/KotlinAndroidViewConstructorUtils\n*L\n66#1:73,7\n*E\n"})
public final class KotlinAndroidViewConstructorUtils {
    @NotNull
    public static final KotlinAndroidViewConstructorUtils INSTANCE = new KotlinAndroidViewConstructorUtils();
    @NotNull
    public static final String DESCRIPTION = "Add Android View constructors using '@JvmOverloads'";
    @NotNull
    private static final ClassId REQUIRED_SUPERTYPE = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"android/view/View", (boolean)false, (int)2, null);
    @NotNull
    private static final Set<ClassId> ALLOWED_THREE_PARAMETER_CONSTRUCTOR_DIRECT_SUPERTYPES;
    @NotNull
    private static final List<ClassId> REQUIRED_CONSTRUCTOR_SIGNATURE;

    private KotlinAndroidViewConstructorUtils() {
    }

    @NotNull
    public final ClassId getREQUIRED_SUPERTYPE() {
        return REQUIRED_SUPERTYPE;
    }

    @NotNull
    public final Set<ClassId> getALLOWED_THREE_PARAMETER_CONSTRUCTOR_DIRECT_SUPERTYPES() {
        return ALLOWED_THREE_PARAMETER_CONSTRUCTOR_DIRECT_SUPERTYPES;
    }

    @NotNull
    public final List<ClassId> getREQUIRED_CONSTRUCTOR_SIGNATURE() {
        return REQUIRED_CONSTRUCTOR_SIGNATURE;
    }

    public final void applyFix(@NotNull Project project, @NotNull KtSuperTypeEntry element, boolean useThreeParameterConstructor) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtPsiFactory psiFactory = new KtPsiFactory(project, true);
        KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)element));
        if (ktClass == null) {
            return;
        }
        KtClass ktClass2 = ktClass;
        Pair pair = useThreeParameterConstructor ? TuplesKt.to((Object)"(\n          context: android.content.Context, attrs: android.util.AttributeSet? = null, defStyleAttr: Int = 0\n          )", (Object)"(context, attrs, defStyleAttr)") : TuplesKt.to((Object)"(\n          context: android.content.Context, attrs: android.util.AttributeSet? = null\n          )", (Object)"(context, attrs)");
        String constructorSignature = (String)pair.component1();
        String superCallSignature = (String)pair.component2();
        KtPrimaryConstructor newPrimaryConstructor = psiFactory.createPrimaryConstructor(constructorSignature);
        PsiElement $this$replaced$iv = (PsiElement)KtClassKt.createPrimaryConstructorIfAbsent((KtClass)ktClass2);
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)newPrimaryConstructor))) {
            psiElement = (PsiElement)newPrimaryConstructor;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace((PsiElement)newPrimaryConstructor);
            if (result$iv instanceof KtPrimaryConstructor) {
                psiElement = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPrimaryConstructor");
                }
                psiElement = (PsiElement)((KtPrimaryConstructor)ktExpression);
            }
        }
        KtPrimaryConstructor primaryConstructor = (KtPrimaryConstructor)psiElement;
        KtParameterList ktParameterList = primaryConstructor.getValueParameterList();
        if (ktParameterList != null) {
            KtParameterList it = ktParameterList;
            boolean bl = false;
            ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)it);
        }
        AnnotationModificationUtilsKt.addAnnotation$default((KtModifierListOwner)((KtModifierListOwner)primaryConstructor), (ClassId)JvmStandardClassIds.INSTANCE.getJVM_OVERLOADS_CLASS_ID(), null, null, (boolean)false, null, null, (int)62, null);
        element.replace((PsiElement)psiFactory.createSuperTypeCallEntry(element.getText() + superCallSignature));
    }

    static {
        Object[] objectArray = new ClassId[2];
        objectArray[0] = REQUIRED_SUPERTYPE;
        objectArray[1] = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"android/view/ViewGroup", (boolean)false, (int)2, null);
        ALLOWED_THREE_PARAMETER_CONSTRUCTOR_DIRECT_SUPERTYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new ClassId[]{ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"android/content/Context", (boolean)false, (int)2, null), ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"android/util/AttributeSet", (boolean)false, (int)2, null), StandardClassIds.INSTANCE.getInt()};
        REQUIRED_CONSTRUCTOR_SIGNATURE = CollectionsKt.listOf((Object[])objectArray);
    }
}

