/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.datastore.DataStoreDatabase;
import com.android.tools.datastore.LogService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.datastore.database.UnifiedEventsTable;
import com.android.tools.datastore.service.CpuService;
import com.android.tools.datastore.service.EventService;
import com.android.tools.datastore.service.MemoryService;
import com.android.tools.datastore.service.ProfilerService;
import com.android.tools.datastore.service.TransportService;
import com.android.tools.idea.io.grpc.Channel;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.Server;
import com.android.tools.idea.io.grpc.ServerBuilder;
import com.android.tools.idea.io.grpc.ServerInterceptor;
import com.android.tools.idea.io.grpc.ServerInterceptors;
import com.android.tools.idea.io.grpc.ServerServiceDefinition;
import com.android.tools.idea.io.grpc.inprocess.InProcessServerBuilder;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.EventServiceGrpc;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidProfilerDbStats;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataStoreService
implements DataStoreTable.DataStoreTableErrorCallback {
    private static final long REPORT_INITIAL_DELAY = TimeUnit.MINUTES.toMillis(15L);
    private static final long REPORT_PERIOD = TimeUnit.HOURS.toMillis(1L);
    public static final long DATASTORE_RESERVED_STREAM_ID = -1L;
    @NotNull
    private final LogService myLogService;
    private final String myDatastoreDirectory;
    private final Map<BackingNamespace, DataStoreDatabase> myDatabases = new HashMap<BackingNamespace, DataStoreDatabase>();
    private final ServerBuilder myServerBuilder;
    private final Server myServer;
    private final List<ServicePassThrough> myServices = new ArrayList<ServicePassThrough>();
    private final Consumer<Runnable> myFetchExecutor;
    private Consumer<Throwable> myNoPiiExceptionHandler;
    private TransportService myTransportService;
    private final ServerInterceptor myInterceptor;
    private final Map<Long, DataStoreClient> myConnectedClients = new HashMap<Long, DataStoreClient>();
    private final Timer myReportTimer;

    private LogService.Logger getLogger() {
        return this.myLogService.getLogger(DataStoreService.class.getCanonicalName());
    }

    public DataStoreService(@NotNull String serviceName, @NotNull String datastoreDirectory, @NotNull Consumer<Runnable> fetchExecutor, @NotNull LogService logService) {
        this(serviceName, datastoreDirectory, fetchExecutor, logService, null);
    }

    @VisibleForTesting
    public DataStoreService(@NotNull String serviceName, @NotNull String datastoreDirectory, @NotNull Consumer<Runnable> fetchExecutor, @NotNull LogService logService, @Nullable ServerInterceptor interceptor) {
        this.myLogService = logService;
        this.myFetchExecutor = fetchExecutor;
        this.myInterceptor = interceptor;
        this.myDatastoreDirectory = datastoreDirectory;
        this.myServerBuilder = InProcessServerBuilder.forName((String)serviceName).directExecutor();
        this.setNoPiiExceptionHandler(null);
        this.createPollers();
        this.myServer = this.myServerBuilder.build();
        try {
            this.myServer.start();
        }
        catch (IOException ex) {
            this.getLogger().error(ex.getMessage());
        }
        this.myReportTimer = new Timer("DataStoreReportTimer");
        this.myReportTimer.schedule((TimerTask)new ReportTimerTask(), REPORT_INITIAL_DELAY, REPORT_PERIOD);
        DataStoreTable.addDataStoreErrorCallback(this);
    }

    public void setNoPiiExceptionHandler(@Nullable Consumer<Throwable> noPiiExceptionHandler) {
        this.myNoPiiExceptionHandler = noPiiExceptionHandler == null ? t -> this.getLogger().error((Throwable)t) : noPiiExceptionHandler;
    }

    @VisibleForTesting
    public Map<BackingNamespace, DataStoreDatabase> getDatabases() {
        return this.myDatabases;
    }

    public void createPollers() {
        UnifiedEventsTable unifiedTable = new UnifiedEventsTable();
        this.myTransportService = new TransportService(this, unifiedTable, this.myFetchExecutor);
        this.registerService(this.myTransportService);
        this.registerService(new ProfilerService(this, this.myLogService));
        this.registerService(new EventService(this, this.myFetchExecutor));
        this.registerService(new CpuService(this, this.myFetchExecutor, this.myLogService));
        this.registerService(new MemoryService(this, unifiedTable, this.myFetchExecutor, this.myLogService));
    }

    @VisibleForTesting
    @NotNull
    public DataStoreDatabase createDatabase(@NotNull String dbPath, @NotNull DataStoreDatabase.Characteristic characteristic, Consumer<Throwable> noPiiExceptionHandler) {
        return new DataStoreDatabase(dbPath, characteristic, this.myLogService, noPiiExceptionHandler);
    }

    void registerService(@NotNull ServicePassThrough service) {
        this.myServices.add(service);
        List<BackingNamespace> namespaces = service.getBackingNamespaces();
        namespaces.forEach(namespace -> {
            assert (!namespace.myNamespace.isEmpty());
            DataStoreDatabase db = this.myDatabases.computeIfAbsent((BackingNamespace)namespace, backingNamespace -> this.createDatabase(this.myDatastoreDirectory + backingNamespace.myNamespace, backingNamespace.myCharacteristic, this.myNoPiiExceptionHandler));
            service.setBackingStore((BackingNamespace)namespace, db.getConnection());
        });
        if (this.myInterceptor != null) {
            this.myServerBuilder.addService(ServerInterceptors.intercept((ServerServiceDefinition)service.bindService(), (ServerInterceptor[])new ServerInterceptor[]{this.myInterceptor}));
        } else {
            this.myServerBuilder.addService(service.bindService());
        }
    }

    public void connect(@NotNull Common.Stream stream, @NotNull ManagedChannel channel) {
        assert (stream.getStreamId() != 0L);
        long streamId = stream.getStreamId();
        if (!this.myConnectedClients.containsKey(streamId)) {
            this.myConnectedClients.put(streamId, new DataStoreClient(channel));
            this.myTransportService.connectToChannel(stream, (Channel)channel);
        }
    }

    public void disconnect(long streamId) {
        if (this.myConnectedClients.containsKey(streamId)) {
            DataStoreClient client = this.myConnectedClients.remove(streamId);
            client.getChannel().shutdown();
            this.myTransportService.disconnectFromChannel((Channel)client.getChannel());
        }
    }

    public void shutdown() {
        this.myReportTimer.cancel();
        this.myServer.shutdownNow();
        for (DataStoreClient client : this.myConnectedClients.values()) {
            client.getChannel().shutdownNow();
        }
        this.myConnectedClients.clear();
        this.myDatabases.forEach((name, db) -> db.disconnect());
        DataStoreTable.removeDataStoreErrorCallback(this);
    }

    @VisibleForTesting
    List<ServicePassThrough> getRegisteredServices() {
        return this.myServices;
    }

    public CpuServiceGrpc.CpuServiceBlockingStub getCpuClient(long streamId) {
        return this.myConnectedClients.containsKey(streamId) ? this.myConnectedClients.get(streamId).getCpuClient() : null;
    }

    public EventServiceGrpc.EventServiceBlockingStub getEventClient(long streamId) {
        return this.myConnectedClients.containsKey(streamId) ? this.myConnectedClients.get(streamId).getEventClient() : null;
    }

    public MemoryServiceGrpc.MemoryServiceBlockingStub getMemoryClient(long streamId) {
        return this.myConnectedClients.containsKey(streamId) ? this.myConnectedClients.get(streamId).getMemoryClient() : null;
    }

    public ProfilerServiceGrpc.ProfilerServiceBlockingStub getProfilerClient(long streamId) {
        return this.myConnectedClients.containsKey(streamId) ? this.myConnectedClients.get(streamId).getProfilerClient() : null;
    }

    public TransportServiceGrpc.TransportServiceBlockingStub getTransportClient(long streamId) {
        return this.myConnectedClients.containsKey(streamId) ? this.myConnectedClients.get(streamId).getTransportClient() : null;
    }

    @Override
    public void onDataStoreError(Throwable t) {
        this.myNoPiiExceptionHandler.accept(t);
    }

    @NotNull
    public LogService getLogService() {
        return this.myLogService;
    }

    private final class ReportTimerTask
    extends TimerTask {
        private final long myStartTime = System.nanoTime();

        private ReportTimerTask() {
        }

        @Override
        public void run() {
            AndroidProfilerDbStats.Builder dbStats = AndroidProfilerDbStats.newBuilder();
            dbStats.setAgeSec((int)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.myStartTime));
            this.collectReport(dbStats);
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ANDROID_PROFILER_DB_STATS).setAndroidProfilerDbStats(dbStats);
            UsageTracker.log((AndroidStudioEvent.Builder)event);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void collectReport(AndroidProfilerDbStats.Builder dbStats) {
            try {
                File dbFile = new File(DataStoreService.this.myDatastoreDirectory, BackingNamespace.DEFAULT_SHARED_NAMESPACE.myNamespace);
                dbStats.setTotalDiskMb((int)(dbFile.length() / 1024L / 1024L));
                for (DataStoreDatabase db : DataStoreService.this.myDatabases.values()) {
                    Statement tableStatement = db.getConnection().createStatement();
                    try {
                        ResultSet tableResults = tableStatement.executeQuery("SELECT name FROM sqlite_master WHERE type='table'");
                        try {
                            while (tableResults.next()) {
                                String tableName = tableResults.getString(1);
                                Statement sizeStatement = db.getConnection().createStatement();
                                try {
                                    ResultSet sizeResult = sizeStatement.executeQuery(String.format("SELECT COUNT(*) FROM %s", tableName));
                                    try {
                                        int tableSize = sizeResult.getInt(1);
                                        dbStats.addTablesBuilder().setName(tableName).setNumRecords(tableSize);
                                    }
                                    finally {
                                        if (sizeResult == null) continue;
                                        sizeResult.close();
                                    }
                                }
                                finally {
                                    if (sizeStatement == null) continue;
                                    sizeStatement.close();
                                }
                            }
                        }
                        finally {
                            if (tableResults == null) continue;
                            tableResults.close();
                        }
                    }
                    finally {
                        if (tableStatement == null) continue;
                        tableStatement.close();
                    }
                }
                return;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static class DataStoreClient {
        @NotNull
        private final ManagedChannel myChannel;
        @NotNull
        private final TransportServiceGrpc.TransportServiceBlockingStub myTransportClient;

        public DataStoreClient(@NotNull ManagedChannel channel) {
            this.myChannel = channel;
            this.myTransportClient = TransportServiceGrpc.newBlockingStub((Channel)channel);
        }

        @NotNull
        public ManagedChannel getChannel() {
            return this.myChannel;
        }

        @NotNull
        public TransportServiceGrpc.TransportServiceBlockingStub getTransportClient() {
            return this.myTransportClient;
        }

        @Nullable
        public ProfilerServiceGrpc.ProfilerServiceBlockingStub getProfilerClient() {
            return null;
        }

        @Nullable
        public CpuServiceGrpc.CpuServiceBlockingStub getCpuClient() {
            return null;
        }

        @Nullable
        public EventServiceGrpc.EventServiceBlockingStub getEventClient() {
            return null;
        }

        @Nullable
        public MemoryServiceGrpc.MemoryServiceBlockingStub getMemoryClient() {
            return null;
        }
    }

    public static class BackingNamespace {
        public static final BackingNamespace DEFAULT_SHARED_NAMESPACE = new BackingNamespace("default.sql", DataStoreDatabase.Characteristic.DURABLE);
        @NotNull
        public final String myNamespace;
        @NotNull
        public final DataStoreDatabase.Characteristic myCharacteristic;

        public BackingNamespace(@NotNull String namespace, @NotNull DataStoreDatabase.Characteristic characteristic) {
            this.myNamespace = namespace;
            this.myCharacteristic = characteristic;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.myNamespace, this.myCharacteristic});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BackingNamespace)) {
                return false;
            }
            BackingNamespace other = (BackingNamespace)obj;
            return this.myNamespace.equals(other.myNamespace) && this.myCharacteristic == other.myCharacteristic;
        }
    }
}

