/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.LogService;
import com.android.tools.datastore.database.CpuTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.Trace;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CpuDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs = Long.MIN_VALUE;
    private long myTraceInfoRequestStartTimestampNs = Long.MIN_VALUE;
    @NotNull
    private final CpuServiceGrpc.CpuServiceBlockingStub myPollingService;
    @NotNull
    private final CpuTable myCpuTable;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final LogService myLogService;

    public CpuDataPoller(@NotNull Common.Session session, @NotNull CpuTable table, @NotNull CpuServiceGrpc.CpuServiceBlockingStub pollingService, @NotNull LogService logService) {
        super(POLLING_DELAY_NS);
        this.myCpuTable = table;
        this.myPollingService = pollingService;
        this.mySession = session;
        this.myLogService = logService;
    }

    @Override
    public void poll() throws StatusRuntimeException {
        long getDataStartNs = this.myDataRequestStartTimestampNs;
        CpuProfiler.CpuDataRequest.Builder request = CpuProfiler.CpuDataRequest.newBuilder().setSession(this.mySession).setStartTimestamp(getDataStartNs).setEndTimestamp(Long.MAX_VALUE);
        CpuProfiler.CpuDataResponse response = this.myPollingService.getData(request.build());
        for (Cpu.CpuUsageData data : response.getDataList()) {
            getDataStartNs = Math.max(getDataStartNs, data.getEndTimestamp());
            this.myCpuTable.insert(this.mySession, data);
        }
        long getThreadsStartNs = this.myDataRequestStartTimestampNs;
        CpuProfiler.GetThreadsRequest.Builder threadsRequest = CpuProfiler.GetThreadsRequest.newBuilder().setSession(this.mySession).setStartTimestamp(getThreadsStartNs).setEndTimestamp(Long.MAX_VALUE);
        CpuProfiler.GetThreadsResponse threadsResponse = this.myPollingService.getThreads(threadsRequest.build());
        if (this.myDataRequestStartTimestampNs == Long.MIN_VALUE) {
            CpuProfiler.GetThreadsResponse.ThreadSnapshot snapshot = threadsResponse.getInitialSnapshot();
            getThreadsStartNs = Math.max(getThreadsStartNs, snapshot.getTimestamp());
            this.myCpuTable.insertSnapshot(this.mySession, snapshot.getTimestamp(), snapshot.getThreadsList());
        }
        for (CpuProfiler.GetThreadsResponse.Thread thread : threadsResponse.getThreadsList()) {
            List activities = thread.getActivitiesList();
            int count = thread.getActivitiesCount();
            if (count > 0) {
                CpuProfiler.GetThreadsResponse.ThreadActivity last = (CpuProfiler.GetThreadsResponse.ThreadActivity)activities.get(count - 1);
                getThreadsStartNs = Math.max(getThreadsStartNs, last.getTimestamp());
            }
            this.myCpuTable.insertActivities(this.mySession, thread.getTid(), thread.getName(), activities);
        }
        CpuProfiler.GetTraceInfoRequest.Builder traceInfoRequest = CpuProfiler.GetTraceInfoRequest.newBuilder().setSession(this.mySession).setFromTimestamp(this.myTraceInfoRequestStartTimestampNs).setToTimestamp(Long.MAX_VALUE);
        CpuProfiler.GetTraceInfoResponse traceInfoResponse = this.myPollingService.getTraceInfo(traceInfoRequest.build());
        for (Trace.TraceInfo traceInfo : traceInfoResponse.getTraceInfoList()) {
            this.myCpuTable.insertTraceInfo(this.mySession, traceInfo);
            this.myTraceInfoRequestStartTimestampNs = Math.max(this.myTraceInfoRequestStartTimestampNs, Math.max(traceInfo.getFromTimestamp(), traceInfo.getToTimestamp()));
        }
        this.myDataRequestStartTimestampNs = Math.max(Math.max(this.myDataRequestStartTimestampNs + 1L, getDataStartNs), getThreadsStartNs);
    }
}

