/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.database.MemoryStatsTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class MemoryDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs = Long.MIN_VALUE;
    private Memory.AllocationsInfo myPendingAllocationSample = null;
    private Memory.HeapDumpInfo myPendingHeapDumpSample = null;
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myPollingService;
    private final MemoryStatsTable myMemoryStatsTable;
    private final Common.Session mySession;
    private final Consumer<Runnable> myFetchExecutor;

    public MemoryDataPoller(@NotNull Common.Session session, @NotNull MemoryStatsTable statsTable, @NotNull MemoryServiceGrpc.MemoryServiceBlockingStub pollingService, @NotNull Consumer<Runnable> fetchExecutor) {
        super(POLLING_DELAY_NS);
        this.mySession = session;
        this.myMemoryStatsTable = statsTable;
        this.myPollingService = pollingService;
        this.myFetchExecutor = fetchExecutor;
    }

    @Override
    public void stop() {
        if (this.myPendingHeapDumpSample != null) {
            this.myMemoryStatsTable.insertOrReplaceHeapInfo(this.mySession, this.myPendingHeapDumpSample.toBuilder().setEndTime(this.myPendingHeapDumpSample.getStartTime() + 1L).setSuccess(false).build());
            this.myPendingHeapDumpSample = null;
        }
        if (this.myPendingAllocationSample != null && this.myPendingAllocationSample.getLegacy()) {
            this.myMemoryStatsTable.insertOrReplaceAllocationsInfo(this.mySession, this.myPendingAllocationSample.toBuilder().setEndTime(this.myPendingAllocationSample.getStartTime() + 1L).setSuccess(false).build());
        }
        this.myPendingAllocationSample = null;
        super.stop();
    }

    @Override
    public void poll() {
        Memory.AllocationsInfo info;
        int i;
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setSession(this.mySession).setStartTime(this.myDataRequestStartTimestampNs).setEndTime(Long.MAX_VALUE);
        MemoryProfiler.MemoryData response = this.myPollingService.getData(dataRequestBuilder.build());
        this.myMemoryStatsTable.insertMemory(this.mySession, response.getMemSamplesList());
        this.myMemoryStatsTable.insertAllocStats(this.mySession, response.getAllocStatsSamplesList());
        this.myMemoryStatsTable.insertGcStats(this.mySession, response.getGcStatsSamplesList());
        for (i = 0; i < response.getAllocationsInfoCount(); ++i) {
            if (this.myPendingAllocationSample != null) {
                assert (i == 0);
                info = response.getAllocationsInfo(i);
                assert (this.myPendingAllocationSample.getStartTime() == info.getStartTime());
                if (info.getEndTime() == Long.MAX_VALUE) break;
                this.myMemoryStatsTable.insertOrReplaceAllocationsInfo(this.mySession, info);
                this.myPendingAllocationSample = null;
                continue;
            }
            info = response.getAllocationsInfo(i);
            this.myMemoryStatsTable.insertOrReplaceAllocationsInfo(this.mySession, info);
            if (info.getEndTime() != Long.MAX_VALUE) continue;
            assert (i == response.getAllocationsInfoCount() - 1);
            this.myPendingAllocationSample = info;
        }
        for (i = 0; i < response.getHeapDumpInfosCount(); ++i) {
            info = response.getHeapDumpInfos(i);
            if (this.myPendingHeapDumpSample != null) {
                assert (i == 0);
                assert (this.myPendingHeapDumpSample.getStartTime() == info.getStartTime());
                if (info.getEndTime() == Long.MAX_VALUE) break;
                this.myMemoryStatsTable.insertOrReplaceHeapInfo(this.mySession, (Memory.HeapDumpInfo)info);
                this.myPendingHeapDumpSample = null;
                continue;
            }
            this.myMemoryStatsTable.insertOrReplaceHeapInfo(this.mySession, (Memory.HeapDumpInfo)info);
            if (info.getEndTime() != Long.MAX_VALUE) continue;
            assert (i == response.getHeapDumpInfosCount() - 1);
            this.myPendingHeapDumpSample = info;
        }
        if (response.getEndTimestamp() > this.myDataRequestStartTimestampNs) {
            this.myDataRequestStartTimestampNs = response.getEndTimestamp();
        }
    }
}

