/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0007J \u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J9\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\b0\u001a\u00a2\u0006\u0002\b\u001cH\u0007J>\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2$\u0010\u001e\u001a \u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0\u001fH\u0002\u00a8\u0006!"}, d2={"Lcom/android/tools/profilers/ImportedSessionUtils;", "", "<init>", "()V", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "importFileWithArtifactEvent", "", "sessionsManager", "Lcom/android/tools/profilers/sessions/SessionsManager;", "file", "Ljava/io/File;", "sessionType", "Lcom/android/tools/profiler/proto/Common$SessionData$SessionStarted$SessionType;", "makeEvent", "Lkotlin/Function2;", "", "Lcom/android/tools/profiler/proto/Common$Event;", "importFile", "makeEndedEvent", "groupId", "timeStamp", "kind", "Lcom/android/tools/profiler/proto/Common$Event$Kind;", "prepare", "Lkotlin/Function1;", "Lcom/android/tools/profiler/proto/Common$Event$Builder;", "Lkotlin/ExtensionFunctionType;", "withFileImportedOnce", "handle", "Lkotlin/Function4;", "", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nImportedSessionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportedSessionUtils.kt\ncom/android/tools/profilers/ImportedSessionUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public final class ImportedSessionUtils {
    @NotNull
    public static final ImportedSessionUtils INSTANCE = new ImportedSessionUtils();

    private ImportedSessionUtils() {
    }

    private final Logger getLogger() {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @JvmStatic
    public static final void importFileWithArtifactEvent(@NotNull SessionsManager sessionsManager, @NotNull File file, @NotNull Common.SessionData.SessionStarted.SessionType sessionType, @NotNull Function2<? super Long, ? super Long, Common.Event> makeEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionsManager), (String)"sessionsManager");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sessionType, (String)"sessionType");
        Intrinsics.checkNotNullParameter(makeEvent, (String)"makeEvent");
        INSTANCE.withFileImportedOnce(sessionsManager, file, (Function4<? super byte[], ? super Long, ? super Long, ? super Long, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> ImportedSessionUtils.importFileWithArtifactEvent$lambda$0(sessionsManager, file, sessionType, makeEvent, arg_0, arg_1, arg_2, arg_3)));
    }

    @JvmStatic
    public static final void importFile(@NotNull SessionsManager sessionsManager, @NotNull File file, @NotNull Common.SessionData.SessionStarted.SessionType sessionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionsManager), (String)"sessionsManager");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sessionType, (String)"sessionType");
        INSTANCE.withFileImportedOnce(sessionsManager, file, (Function4<? super byte[], ? super Long, ? super Long, ? super Long, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> ImportedSessionUtils.importFile$lambda$1(sessionsManager, file, sessionType, arg_0, arg_1, arg_2, arg_3)));
    }

    @JvmStatic
    @NotNull
    public static final Common.Event makeEndedEvent(long groupId, long timeStamp, @NotNull Common.Event.Kind kind, @NotNull Function1<? super Common.Event.Builder, Unit> prepare) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter(prepare, (String)"prepare");
        Common.Event.Builder builder = Common.Event.newBuilder().setKind(kind).setGroupId(groupId).setTimestamp(timeStamp).setIsEnded(true);
        prepare.invoke((Object)builder);
        Common.Event event = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"build(...)");
        return event;
    }

    private final void withFileImportedOnce(SessionsManager sessionsManager, File file, Function4<? super byte[], ? super Long, ? super Long, ? super Long, Unit> handle) {
        block5: {
            byte[] byArray;
            Long sessionEndTimeNs;
            Long sessionStartTimeNs;
            long startTimestampEpochNs;
            block4: {
                startTimestampEpochNs = System.currentTimeMillis();
                Pair<Long, Long> timestampsNs = StudioProfilers.computeImportedFileStartEndTimestampsNs(file);
                sessionStartTimeNs = (Long)timestampsNs.first;
                sessionEndTimeNs = (Long)timestampsNs.second;
                StudioProfilers studioProfilers = sessionsManager.getStudioProfilers();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
                StudioProfilers profilers = studioProfilers;
                if (!sessionsManager.getSessionIdToSessionItems().containsKey(sessionStartTimeNs)) break block4;
                if (profilers.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
                    SessionItem sessionItem = sessionsManager.getSessionIdToSessionItems().get(sessionStartTimeNs);
                    Intrinsics.checkNotNull((Object)sessionItem);
                    SessionItem session = sessionItem;
                    profilers.getPastRecordingsTabModel().getRecordingListModel().openRecording(session);
                } else {
                    Intrinsics.checkNotNull((Object)sessionStartTimeNs);
                    sessionsManager.setSessionById(sessionStartTimeNs);
                }
                break block5;
            }
            try {
                byArray = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
            }
            catch (IOException e) {
                this.getLogger().error("Importing Session Failed: cannot read from " + file.getPath());
                byArray = null;
            }
            byte[] byArray2 = byArray;
            if (byArray2 == null) break block5;
            byte[] bytes = byArray2;
            boolean bl = false;
            Long l = startTimestampEpochNs;
            Intrinsics.checkNotNull((Object)sessionStartTimeNs);
            Intrinsics.checkNotNull((Object)sessionEndTimeNs);
            handle.invoke((Object)bytes, (Object)l, (Object)sessionStartTimeNs, (Object)sessionEndTimeNs);
        }
    }

    private static final Unit importFileWithArtifactEvent$lambda$0(SessionsManager $sessionsManager, File $file, Common.SessionData.SessionStarted.SessionType $sessionType, Function2 $makeEvent, byte[] bytes, long startTimestampsEpochMs, long startTime, long endTime) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Common.Event[] eventArray = new Common.Event[]{$makeEvent.invoke((Object)startTime, (Object)endTime)};
        $sessionsManager.createImportedSession($file.getName(), $sessionType, startTime, endTime, startTimestampsEpochMs, MapsKt.mapOf((kotlin.Pair)TuplesKt.to((Object)String.valueOf(startTime), (Object)ByteString.copyFrom((byte[])bytes))), eventArray);
        return Unit.INSTANCE;
    }

    private static final Unit importFile$lambda$1(SessionsManager $sessionsManager, File $file, Common.SessionData.SessionStarted.SessionType $sessionType, byte[] bytes, long startTimestampsEpochMs, long startTime, long endTime) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        $sessionsManager.createImportedSession($file.getName(), $sessionType, startTime, endTime, startTimestampsEpochMs, MapsKt.mapOf((kotlin.Pair)TuplesKt.to((Object)String.valueOf(startTime), (Object)ByteString.copyFrom((byte[])bytes))), new Common.Event[0]);
        return Unit.INSTANCE;
    }
}

