/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.profilers.LiveDataModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class LiveDataView<T extends LiveDataModel>
extends AspectObserver {
    @NotNull
    private final T myLiveDataModel;
    private final JPanel myContainer;

    public LiveDataView(@NotNull T liveDataModel) {
        this.myLiveDataModel = liveDataModel;
        this.myContainer = new JBPanel();
        this.myContainer.setOpaque(true);
        this.myContainer.setBorder(ProfilerLayout.MONITOR_BORDER);
        int minimumLiveViewHeight = JBUI.scale((int)50);
        this.myContainer.setMinimumSize(new Dimension(0, minimumLiveViewHeight));
        this.myContainer.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ((LiveDataModel)((Object)LiveDataView.this.myLiveDataModel)).setFocus(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ((LiveDataModel)((Object)LiveDataView.this.myLiveDataModel)).setFocus(false);
            }
        });
        this.myLiveDataModel.addDependency((AspectObserver)this).onChange((Enum)LiveDataModel.Aspect.FOCUS, this::focusChanged);
        this.focusChanged();
    }

    public float getVerticalWeight() {
        return 1.0f;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myContainer;
    }

    protected void focusChanged() {
        boolean highlight = ((LiveDataModel)((Object)this.myLiveDataModel)).isFocused();
        this.myContainer.setBackground(highlight ? ProfilerColors.MONITOR_FOCUSED : ProfilerColors.DEFAULT_BACKGROUND);
    }

    protected abstract void registerTooltip(ViewBinder<StageView, TooltipModel, TooltipView> var1, @NotNull RangeTooltipComponent var2, Stage var3);

    protected abstract void populateUi(RangeTooltipComponent var1);

    public JComponent getToolbar() {
        return null;
    }
}

