/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.LiveDataModel;
import com.android.tools.profilers.LiveStage;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.SupportLevel;
import com.android.tools.profilers.cpu.LiveCpuUsageModel;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.memory.LiveMemoryFootprintModel;
import com.android.tools.profilers.memory.adapters.MemoryDataProvider;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.tasks.TaskEventTrackerUtils;
import com.android.tools.profilers.tasks.TaskFinishedState;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tJ\b\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/profilers/LiveStage;", "Lcom/android/tools/profilers/StreamingStage;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "stopTask", "Lkotlin/Function0;", "", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;Lkotlin/jvm/functions/Function0;)V", "(Lcom/android/tools/profilers/StudioProfilers;)V", "getStopTask", "()Lkotlin/jvm/functions/Function0;", "liveModels", "", "Lcom/android/tools/profilers/LiveDataModel;", "getLiveModels", "()Ljava/util/List;", "eventMonitor", "Ljava/util/Optional;", "Lcom/android/tools/profilers/event/EventMonitor;", "getEventMonitor", "()Ljava/util/Optional;", "setEventMonitor", "(Ljava/util/Optional;)V", "enter", "exit", "getEventMonitorInstance", "getStageType", "Lcom/google/wireless/android/sdk/stats/AndroidProfilerEvent$Stage;", "isOPlus", "", "intellij.android.profilers"})
public final class LiveStage
extends StreamingStage {
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final Function0<Unit> stopTask;
    @NotNull
    private final List<LiveDataModel> liveModels;
    @NotNull
    private Optional<EventMonitor> eventMonitor;

    public LiveStage(@NotNull StudioProfilers profilers, @NotNull Function0<Unit> stopTask2) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter(stopTask2, (String)"stopTask");
        super(profilers);
        this.profilers = profilers;
        this.stopTask = stopTask2;
        this.liveModels = new ArrayList();
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        this.eventMonitor = optional;
    }

    @NotNull
    public final Function0<Unit> getStopTask() {
        return this.stopTask;
    }

    public LiveStage(@NotNull StudioProfilers profilers) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        this(profilers, (Function0<Unit>)((Function0)LiveStage::_init_$lambda$0));
    }

    @NotNull
    public final List<LiveDataModel> getLiveModels() {
        return this.liveModels;
    }

    @NotNull
    public final Optional<EventMonitor> getEventMonitor() {
        return this.eventMonitor;
    }

    public final void setEventMonitor(@NotNull Optional<EventMonitor> optional) {
        Intrinsics.checkNotNullParameter(optional, (String)"<set-?>");
        this.eventMonitor = optional;
    }

    @Override
    public void enter() {
        this.logEnterStage();
        this.eventMonitor.ifPresent(arg_0 -> LiveStage.enter$lambda$1(enter.1.INSTANCE, arg_0));
        this.getTimeline().getSelectionRange().clear();
        this.liveModels.clear();
        this.eventMonitor = Optional.ofNullable(this.getEventMonitorInstance());
        this.liveModels.add(new LiveCpuUsageModel(this.profilers, this));
        this.liveModels.add(new LiveMemoryFootprintModel(this.profilers));
        this.liveModels.stream().forEach(arg_0 -> LiveStage.enter$lambda$3(LiveStage::enter$lambda$2, arg_0));
        this.profilers.getIdeServices().getFeatureTracker().trackEnterStage(this.getStageType());
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
            boolean isSessionAlive = this.getStudioProfilers().getSessionsManager().isSessionAlive();
            if (isSessionAlive) {
                AspectModel.Dependency dependency = this.getStudioProfilers().getSessionsManager().addDependency(this).onChange((Enum)SessionAspect.SESSIONS, () -> LiveStage.enter$lambda$4(this));
                Intrinsics.checkNotNull((Object)dependency);
            } else {
                StudioProfilers studioProfilers = this.getStudioProfilers();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
                TaskEventTrackerUtils.trackTaskFinished(studioProfilers, false, TaskFinishedState.COMPLETED);
            }
        }
    }

    @Override
    public void exit() {
        this.liveModels.clear();
        this.liveModels.stream().forEach(arg_0 -> LiveStage.exit$lambda$6(LiveStage::exit$lambda$5, arg_0));
        this.eventMonitor.ifPresent(arg_0 -> LiveStage.exit$lambda$7(exit.2.INSTANCE, arg_0));
    }

    private final EventMonitor getEventMonitorInstance() {
        return this.profilers.getSelectedSessionSupportLevel() == SupportLevel.DEBUGGABLE && this.isOPlus() ? new EventMonitor(this.profilers) : null;
    }

    @Override
    @NotNull
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.LIVE_STAGE;
    }

    private final boolean isOPlus() {
        Common.Device device = MemoryDataProvider.Companion.getDeviceForSelectedSession(this.profilers);
        return device != null && device.getFeatureLevel() >= 26;
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final void enter$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit enter$lambda$2(LiveDataModel liveModel) {
        liveModel.enter();
        return Unit.INSTANCE;
    }

    private static final void enter$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void enter$lambda$4(LiveStage this$0) {
        if (!this$0.getStudioProfilers().getSessionsManager().isSessionAlive()) {
            StudioProfilers studioProfilers = this$0.getStudioProfilers();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
            TaskEventTrackerUtils.trackTaskFinished(studioProfilers, true, TaskFinishedState.COMPLETED);
            this$0.getStudioProfilers().getSessionsManager().removeDependencies(this$0);
        }
    }

    private static final Unit exit$lambda$5(LiveDataModel liveModel) {
        liveModel.exit();
        return Unit.INSTANCE;
    }

    private static final void exit$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void exit$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

