/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.adtui.stdui.TooltipLayeredPane;
import com.android.tools.inspectors.common.ui.ContextMenuInstaller;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.NullMonitorStageView;
import com.android.tools.profilers.ProfilerContextMenu;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StageWithToolbarView;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioMonitorStageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuCaptureStageView;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.customevent.CustomEventProfilerStage;
import com.android.tools.profilers.customevent.CustomEventProfilerStageView;
import com.android.tools.profilers.memory.AllocationStage;
import com.android.tools.profilers.memory.AllocationStageView;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MainMemoryProfilerStageView;
import com.android.tools.profilers.memory.MemoryCaptureStage;
import com.android.tools.profilers.memory.MemoryCaptureStageView;
import com.android.tools.profilers.sessions.SessionsView;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.function.BiFunction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SessionProfilersView
implements StudioProfilersView {
    @NotNull
    private final StudioProfilers myProfiler;
    @NotNull
    private final IdeProfilerComponents myIdeProfilerComponents;
    private final ViewBinder<SessionProfilersView, Stage, StageView> myBinder;
    @NotNull
    private final TooltipLayeredPane myLayeredPane;
    @NotNull
    private final ThreeComponentsSplitter mySplitter;
    private final JPanel myStageComponent;
    private SessionsView mySessionsView;
    @NotNull
    private final StageWithToolbarView myStageWithToolbarView;

    public SessionProfilersView(@NotNull StudioProfilers profiler, @NotNull IdeProfilerComponents ideProfilerComponents, @NotNull Disposable parentDisposable) {
        this.myProfiler = profiler;
        this.myIdeProfilerComponents = ideProfilerComponents;
        this.myStageComponent = new JPanel(new BorderLayout());
        this.mySplitter = new ThreeComponentsSplitter();
        this.mySplitter.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy());
        this.mySplitter.setDividerWidth(0);
        this.mySplitter.setDividerMouseZoneSize(-1);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.myLayeredPane = new TooltipLayeredPane((JComponent)this.mySplitter);
        this.initializeSessionUi();
        this.myBinder = new ViewBinder();
        this.myBinder.bind(StudioMonitorStage.class, StudioMonitorStageView::new);
        this.myBinder.bind(CpuProfilerStage.class, CpuProfilerStageView::new);
        this.myBinder.bind(CpuCaptureStage.class, CpuCaptureStageView::new);
        this.myBinder.bind(MainMemoryProfilerStage.class, MainMemoryProfilerStageView::new);
        this.myBinder.bind(MemoryCaptureStage.class, MemoryCaptureStageView::new);
        this.myBinder.bind(AllocationStage.class, AllocationStageView::new);
        this.myBinder.bind(NullMonitorStage.class, NullMonitorStageView::new);
        this.myBinder.bind(CustomEventProfilerStage.class, CustomEventProfilerStageView::new);
        this.myStageWithToolbarView = new StageWithToolbarView(profiler, this.myStageComponent, ideProfilerComponents, this::buildStageView, (JComponent)this.mySplitter);
        this.mySplitter.setLastComponent((JComponent)this.getStageComponent());
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public void dispose() {
    }

    @VisibleForTesting
    <S extends Stage, T extends StageView> void bind(@NotNull Class<S> clazz, @NotNull BiFunction<SessionProfilersView, S, T> constructor) {
        this.myBinder.bind(clazz, constructor);
    }

    @VisibleForTesting
    @NotNull
    SessionsView getSessionsView() {
        return this.mySessionsView;
    }

    private StageView buildStageView(Stage stage) {
        return (StageView)((Object)this.myBinder.build((Object)this, (Object)stage));
    }

    private void initializeSessionUi() {
        this.mySessionsView = new SessionsView(this.myProfiler, this.myIdeProfilerComponents);
        final JComponent sessionsComponent = this.mySessionsView.getComponent();
        this.mySplitter.setFirstComponent(sessionsComponent);
        this.mySessionsView.addExpandListener(e -> {
            this.toggleSessionsPanel(false);
            this.myProfiler.getIdeServices().getFeatureTracker().trackSessionsPanelStateChanged(true);
        });
        this.mySessionsView.addCollapseListener(e -> {
            this.toggleSessionsPanel(true);
            this.myProfiler.getIdeServices().getFeatureTracker().trackSessionsPanelStateChanged(false);
        });
        boolean initiallyCollapsed = this.myProfiler.getIdeServices().getPersistentProfilerPreferences().getBoolean("SESSION_IS_COLLAPSED", false);
        this.toggleSessionsPanel(initiallyCollapsed);
        UiNotifyConnector.Once.installOn((Component)this.mySplitter, (Activatable)new Activatable(){

            public void showNotify() {
                IdeGlassPane glassPane = IdeGlassPaneUtil.find((Component)SessionProfilersView.this.mySplitter);
                glassPane.addMousePreprocessor((MouseListener)new MouseAdapter(){
                    private int mySessionsUiWidth;

                    @Override
                    public void mousePressed(MouseEvent e) {
                        this.mySessionsUiWidth = sessionsComponent.getWidth();
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        int width = sessionsComponent.getWidth();
                        if (this.mySessionsUiWidth != width) {
                            SessionProfilersView.this.myProfiler.getIdeServices().getPersistentProfilerPreferences().setInt("SESSION_EXPANDED_WIDTH", width);
                            SessionProfilersView.this.myProfiler.getIdeServices().getFeatureTracker().trackSessionsPanelResized();
                        }
                    }
                }, (Disposable)SessionProfilersView.this);
            }
        });
    }

    private void toggleSessionsPanel(boolean isCollapsed) {
        if (isCollapsed) {
            this.mySplitter.setDividerMouseZoneSize(-1);
            this.mySessionsView.getComponent().setMinimumSize(SessionsView.getComponentMinimizeSize(false));
            this.mySplitter.setFirstSize(0);
        } else {
            this.mySplitter.setDividerMouseZoneSize(JBUI.scale((int)10));
            this.mySessionsView.getComponent().setMinimumSize(SessionsView.getComponentMinimizeSize(true));
            this.mySplitter.setFirstSize(this.myProfiler.getIdeServices().getPersistentProfilerPreferences().getInt("SESSION_EXPANDED_WIDTH", 0));
        }
        this.mySplitter.revalidate();
        this.mySplitter.repaint();
    }

    @Override
    @NotNull
    public StudioProfilers getStudioProfilers() {
        return this.myProfiler;
    }

    @Override
    @NotNull
    public IdeProfilerComponents getIdeProfilerComponents() {
        return this.myIdeProfilerComponents;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myLayeredPane;
    }

    @Override
    @NotNull
    public StageWithToolbarView getStageWithToolbarView() {
        return this.myStageWithToolbarView;
    }

    @Override
    @NotNull
    public final JPanel getStageComponent() {
        return this.myStageComponent;
    }

    @Nullable
    public StageView getStageView() {
        return this.myStageWithToolbarView.getStageView();
    }

    @Override
    public void installCommonMenuItems(@NotNull JComponent component) {
        ContextMenuInstaller contextMenuInstaller = this.getIdeProfilerComponents().createContextMenuInstaller();
        ProfilerContextMenu.createIfAbsent(this.myStageComponent).getContextMenuItems().forEach(item -> contextMenuInstaller.installGenericContextMenu(component, item));
    }
}

