/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineEvent;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineModelKt;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineTooltip;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\b\u0010#\u001a\u00020$H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u000e\u001a\u0004\b\u0018\u0010\u0015R\u001c\u0010\u0019\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u000e\u001a\u0004\b\u001b\u0010\u0015R\u001c\u0010\u001c\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u000e\u001a\u0004\b\u001e\u0010\u0015R\u001c\u0010\u001f\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b \u0010\u000e\u001a\u0004\b!\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/android/tools/profilers/cpu/AndroidFrameTimelineTooltipView;", "Lcom/android/tools/adtui/TooltipView;", "parent", "Ljavax/swing/JComponent;", "tooltip", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameTimelineTooltip;", "<init>", "(Ljavax/swing/JComponent;Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameTimelineTooltip;)V", "getTooltip", "()Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameTimelineTooltip;", "container", "Lcom/intellij/ui/components/JBPanel;", "", "getContainer$annotations", "()V", "getContainer", "()Lcom/intellij/ui/components/JBPanel;", "typeLabel", "Lcom/intellij/ui/components/JBLabel;", "getTypeLabel$annotations", "getTypeLabel", "()Lcom/intellij/ui/components/JBLabel;", "frameLabel", "getFrameLabel$annotations", "getFrameLabel", "actualLabel", "getActualLabel$annotations", "getActualLabel", "startLabel", "getStartLabel$annotations", "getStartLabel", "expectedLabel", "getExpectedLabel$annotations", "getExpectedLabel", "createTooltip", "updateView", "", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAndroidFrameTimelineTooltipView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidFrameTimelineTooltipView.kt\ncom/android/tools/profilers/cpu/AndroidFrameTimelineTooltipView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class AndroidFrameTimelineTooltipView
extends TooltipView {
    @NotNull
    private final AndroidFrameTimelineTooltip tooltip;
    @NotNull
    private final JBPanel container;
    @NotNull
    private final JBLabel typeLabel;
    @NotNull
    private final JBLabel frameLabel;
    @NotNull
    private final JBLabel actualLabel;
    @NotNull
    private final JBLabel startLabel;
    @NotNull
    private final JBLabel expectedLabel;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public AndroidFrameTimelineTooltipView(@NotNull JComponent parent, @NotNull AndroidFrameTimelineTooltip tooltip) {
        void $this$lambda_u242_u24lambda_u241;
        JBLabel jBLabel;
        void $this$typeLabel_u24lambda_u240;
        JBLabel jBLabel2;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)((Object)tooltip), (String)"tooltip");
        super(tooltip.getTimeline());
        this.tooltip = tooltip;
        this.container = new JBPanel((LayoutManager)new TabularLayout("*").setVGap(12));
        JBLabel jBLabel3 = jBLabel2 = new JBLabel();
        AndroidFrameTimelineTooltipView androidFrameTimelineTooltipView = this;
        boolean bl = false;
        $this$typeLabel_u24lambda_u240.setFont(ProfilerFonts.H3_FONT);
        androidFrameTimelineTooltipView.typeLabel = jBLabel2;
        this.frameLabel = new JBLabel();
        this.actualLabel = new JBLabel();
        this.startLabel = new JBLabel();
        this.expectedLabel = new JBLabel();
        JBPanel $this$_init__u24lambda_u242 = this.container;
        boolean bl2 = false;
        $this$_init__u24lambda_u242.add((Component)this.typeLabel, (Object)new TabularLayout.Constraint(0, 0, 0, 4, null));
        $this$_init__u24lambda_u242.add((Component)this.frameLabel, (Object)new TabularLayout.Constraint(1, 0, 0, 4, null));
        $this$_init__u24lambda_u242.add((Component)this.actualLabel, (Object)new TabularLayout.Constraint(2, 0, 0, 4, null));
        $this$_init__u24lambda_u242.add((Component)this.startLabel, (Object)new TabularLayout.Constraint(3, 0, 0, 4, null));
        $this$_init__u24lambda_u242.add((Component)this.expectedLabel, (Object)new TabularLayout.Constraint(4, 0, 0, 4, null));
        $this$_init__u24lambda_u242.add((Component)AdtUiUtils.createHorizontalSeparator(), (Object)new TabularLayout.Constraint(5, 0, 0, 4, null));
        JBLabel jBLabel4 = jBLabel = new JBLabel("Click to inspect");
        JBPanel jBPanel = $this$_init__u24lambda_u242;
        boolean bl3 = false;
        $this$lambda_u242_u24lambda_u241.setForeground(ProfilerColors.TOOLTIP_LOW_CONTRAST);
        jBPanel.add((Component)jBLabel, (Object)new TabularLayout.Constraint(6, 0, 0, 4, null));
        this.tooltip.addDependency((AspectObserver)this).onChange((Enum)AndroidFrameTimelineTooltip.Aspect.VALUE_CHANGED, this::updateView);
        this.updateView();
    }

    @NotNull
    public final AndroidFrameTimelineTooltip getTooltip() {
        return this.tooltip;
    }

    @NotNull
    public final JBPanel getContainer() {
        return this.container;
    }

    @VisibleForTesting
    public static /* synthetic */ void getContainer$annotations() {
    }

    @NotNull
    public final JBLabel getTypeLabel() {
        return this.typeLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTypeLabel$annotations() {
    }

    @NotNull
    public final JBLabel getFrameLabel() {
        return this.frameLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getFrameLabel$annotations() {
    }

    @NotNull
    public final JBLabel getActualLabel() {
        return this.actualLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getActualLabel$annotations() {
    }

    @NotNull
    public final JBLabel getStartLabel() {
        return this.startLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getStartLabel$annotations() {
    }

    @NotNull
    public final JBLabel getExpectedLabel() {
        return this.expectedLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getExpectedLabel$annotations() {
    }

    @NotNull
    protected JBPanel createTooltip() {
        return this.container;
    }

    private final void updateView() {
        AndroidFrameTimelineEvent event = this.tooltip.getActiveEvent();
        if (event == null) {
            this.container.setVisible(false);
        } else {
            this.container.setVisible(true);
            this.typeLabel.setVisible(event.isJank());
            this.typeLabel.setText(AndroidFrameTimelineModelKt.getTitle(event.getAppJankType()));
            this.frameLabel.setText("Frame: " + event.getSurfaceFrameToken());
            this.startLabel.setText("Start: " + TimeFormatter.getSemiSimplifiedClockString((long)AndroidFrameTimelineTooltipView.updateView$offset(this, event.getExpectedStartUs())));
            this.expectedLabel.setText("Expected end: " + TimeFormatter.getSemiSimplifiedClockString((long)AndroidFrameTimelineTooltipView.updateView$offset(this, event.getExpectedEndUs())));
            this.actualLabel.setText("Actual end: " + TimeFormatter.getSemiSimplifiedClockString((long)AndroidFrameTimelineTooltipView.updateView$offset(this, event.getActualEndUs())));
        }
    }

    private static final long updateView$offset(AndroidFrameTimelineTooltipView this$0, long us) {
        return us - (long)this$0.tooltip.getModel().getCapture().getRange().getMin();
    }
}

