/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.BoxSelectionModel;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultTimeline;
import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.event.EventModel;
import com.android.tools.adtui.model.event.LifecycleEventModel;
import com.android.tools.adtui.model.event.UserEvent;
import com.android.tools.adtui.model.trackgroup.TrackGroupActionListener;
import com.android.tools.adtui.model.trackgroup.TrackGroupModel;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.idea.flags.enums.PowerProfilerDisplayMode;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.EventStreamServer;
import com.android.tools.profiler.perfetto.proto.TraceProcessor;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.LogUtils;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.ProfilerTrackRendererType;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StringFormattingUtils;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.TraceConfigOptionsUtils;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.BatteryDrainTooltip;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureHandler;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureMinimapModel;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadComparator;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadTrackModel;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.analysis.AndroidFrameTimelineAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import com.android.tools.profilers.cpu.analysis.CpuFullTraceAnalysisModel;
import com.android.tools.profilers.cpu.analysis.FramesAnalysisModel;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameEventTooltip;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameEventTrackModel;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineEvent;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineModel;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineTooltip;
import com.android.tools.profilers.cpu.systemtrace.BatteryDrainTrackModel;
import com.android.tools.profilers.cpu.systemtrace.BufferQueueTooltip;
import com.android.tools.profilers.cpu.systemtrace.BufferQueueTrackModel;
import com.android.tools.profilers.cpu.systemtrace.CpuCoreTrackModel;
import com.android.tools.profilers.cpu.systemtrace.CpuFrameTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuFrequencyTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuFrequencyTrackModel;
import com.android.tools.profilers.cpu.systemtrace.CpuKernelTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuSystemTraceData;
import com.android.tools.profilers.cpu.systemtrace.CpuThreadSliceInfo;
import com.android.tools.profilers.cpu.systemtrace.DeadlineTextModel;
import com.android.tools.profilers.cpu.systemtrace.FrameState;
import com.android.tools.profilers.cpu.systemtrace.PowerCounterData;
import com.android.tools.profilers.cpu.systemtrace.PowerRailTooltip;
import com.android.tools.profilers.cpu.systemtrace.PowerRailTrackModel;
import com.android.tools.profilers.cpu.systemtrace.RssMemoryTooltip;
import com.android.tools.profilers.cpu.systemtrace.RssMemoryTrackModel;
import com.android.tools.profilers.cpu.systemtrace.SurfaceflingerTooltip;
import com.android.tools.profilers.cpu.systemtrace.SurfaceflingerTrackModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceCpuCapture;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrame;
import com.android.tools.profilers.cpu.systemtrace.VsyncTooltip;
import com.android.tools.profilers.cpu.systemtrace.VsyncTrackModel;
import com.android.tools.profilers.event.LifecycleEventDataSeries;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.UserEventDataSeries;
import com.android.tools.profilers.event.UserEventTooltip;
import com.android.tools.profilers.perfetto.config.PerfettoTraceConfigBuilders;
import com.android.tools.profilers.perfetto.traceprocessor.TraceProcessorModelKt;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.tasks.TaskEventTrackerUtils;
import com.android.tools.profilers.tasks.TaskFinishedState;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureStage
extends Stage<Timeline> {
    private static final String DISPLAY_HELP_LINK = "https://d.android.com/r/studio-ui/profiler/display-tracks";
    private static final String POWER_RAILS_HELP_LINK = "https://d.android.com/r/studio-ui/profiler/power-profiler";
    private final CpuCaptureHandler myCpuCaptureHandler;
    private final AspectModel<Aspect> myAspect = new AspectModel();
    private final List<CpuAnalysisModel<?>> myPinnedAnalysisModels = new ArrayList();
    private final List<TrackGroupModel> myTrackGroupModels = new ArrayList<TrackGroupModel>();
    private final MultiSelectionModel<CpuAnalyzable<?>> myMultiSelectionModel = new MultiSelectionModel();
    private CpuCaptureMinimapModel myMinimapModel;
    private State myState = State.PARSING;
    private CpuCapture myCapture;
    private final Timeline myTrackGroupTimeline = new DefaultTimeline();
    private int myFrameSelectionCount = 0;
    private int myAllFrameTogglingCount = 0;
    private int myLifecycleTogglingCount = 0;

    @NotNull
    public static File saveCapture(long traceId, ByteString data) {
        try {
            File trace = FileUtil.createTempFile((String)String.format(Locale.US, "cpu_trace_%d", traceId), (String)".trace", (boolean)true);
            try (FileOutputStream out = new FileOutputStream(trace);){
                out.write(data.toByteArray());
            }
            return trace;
        }
        catch (IOException io) {
            throw new IllegalStateException("Unable to save trace to disk");
        }
    }

    @Nullable
    private static File getAndSaveCapture(@NotNull StudioProfilers profilers, long traceId) {
        Transport.BytesRequest traceRequest = Transport.BytesRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setId(String.valueOf(traceId)).build();
        Transport.BytesResponse traceResponse = profilers.getClient().getTransportClient().getBytes(traceRequest);
        if (!traceResponse.getContents().isEmpty()) {
            return CpuCaptureStage.saveCapture(traceId, traceResponse.getContents());
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    public static CpuCaptureStage create(@NotNull StudioProfilers profilers, @NotNull ProfilingConfiguration configuration, long traceId) {
        return CpuCaptureStage.create(profilers, configuration, CpuCaptureMetadata.CpuProfilerEntryPoint.UNKNOWN, traceId);
    }

    @Nullable
    public static CpuCaptureStage create(@NotNull StudioProfilers profilers, @NotNull ProfilingConfiguration configuration, CpuCaptureMetadata.CpuProfilerEntryPoint entryPoint, long traceId) {
        File captureFile = CpuCaptureStage.getAndSaveCapture(profilers, traceId);
        if (captureFile == null) {
            return null;
        }
        String captureProcessNameHint = CpuProfiler.getTraceInfoFromId(profilers, traceId).getConfiguration().getAppName();
        return new CpuCaptureStage(profilers, configuration, entryPoint, captureFile, traceId, captureProcessNameHint, profilers.getSession().getPid());
    }

    @VisibleForTesting
    @NotNull
    public static CpuCaptureStage create(@NotNull StudioProfilers profilers, @NotNull ProfilingConfiguration configuration, @NotNull File captureFile, long sessionId) {
        return new CpuCaptureStage(profilers, configuration, captureFile, sessionId, null, 0);
    }

    @VisibleForTesting
    public CpuCaptureStage(@NotNull StudioProfilers profilers, @NotNull ProfilingConfiguration configuration, @NotNull File captureFile, long traceId, @Nullable String captureProcessNameHint, int captureProcessIdHint) {
        this(profilers, configuration, CpuCaptureMetadata.CpuProfilerEntryPoint.UNKNOWN, captureFile, traceId, captureProcessNameHint, captureProcessIdHint);
    }

    public CpuCaptureStage(@NotNull StudioProfilers profilers, @NotNull ProfilingConfiguration configuration, CpuCaptureMetadata.CpuProfilerEntryPoint entryPoint, @NotNull File captureFile, long traceId, @Nullable String captureProcessNameHint, int captureProcessIdHint) {
        super(profilers);
        this.myCpuCaptureHandler = new CpuCaptureHandler(profilers, captureFile, traceId, configuration, entryPoint, captureProcessNameHint, captureProcessIdHint);
        this.getMultiSelectionModel().addDependency((AspectObserver)this).onChange((Enum)MultiSelectionModel.Aspect.SELECTIONS_CHANGED, this::onSelectionChanged).onChange((Enum)MultiSelectionModel.Aspect.ACTIVE_SELECTION_CHANGED, this::onActiveSelectionChanged);
    }

    public State getState() {
        return this.myState;
    }

    @NotNull
    public AspectModel<Aspect> getAspect() {
        return this.myAspect;
    }

    @NotNull
    public CpuCaptureHandler getCaptureHandler() {
        return this.myCpuCaptureHandler;
    }

    @NotNull
    public List<TrackGroupModel> getTrackGroupModels() {
        return this.myTrackGroupModels;
    }

    @NotNull
    public MultiSelectionModel<CpuAnalyzable<?>> getMultiSelectionModel() {
        return this.myMultiSelectionModel;
    }

    @NotNull
    public CpuCaptureMinimapModel getMinimapModel() {
        assert (this.myState == State.ANALYZING);
        return this.myMinimapModel;
    }

    @NotNull
    public List<CpuAnalysisModel<?>> getPinnedAnalysisModels() {
        return this.myPinnedAnalysisModels;
    }

    @NotNull
    public Timeline getCaptureTimeline() {
        return this.getCapture().getTimeline();
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        return this.myTrackGroupTimeline;
    }

    private void setState(State state) {
        this.myState = state;
        this.myAspect.changed((Enum)Aspect.STATE);
    }

    @NotNull
    public CpuCapture getCapture() {
        assert (this.myState == State.ANALYZING);
        return this.myCapture;
    }

    @Override
    public void enter() {
        this.logEnterStage();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuCaptureHandler);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getStageType());
        this.myCpuCaptureHandler.parse(capture -> {
            try {
                if (capture == null) {
                    if (this.getStudioProfilers().getSessionsManager().isSessionAlive()) {
                        this.getStudioProfilers().getIdeServices().getMainExecutor().execute(() -> this.getStudioProfilers().setStage(this.getParentStage()));
                    } else {
                        this.getStudioProfilers().getIdeServices().getMainExecutor().execute(() -> {
                            this.getStudioProfilers().getSessionsManager().resetSessionSelection();
                            this.getStudioProfilers().setStage(new NullMonitorStage(this.getStudioProfilers(), "The profiler was unable to parse the trace file. Please make sure the file selected is a valid trace."));
                        });
                    }
                } else {
                    LogUtils.log(((Object)((Object)this)).getClass(), "CPU capture parse succeeded");
                    this.myCapture = capture;
                    this.onCaptureParsed((CpuCapture)capture);
                    this.setState(State.ANALYZING);
                    if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
                        TaskEventTrackerUtils.trackTaskFinished(this.getStudioProfilers(), this.getStudioProfilers().getSessionsManager().isSessionAlive(), TaskFinishedState.COMPLETED);
                    }
                }
            }
            catch (Exception ex) {
                Logger.getInstance(CpuCaptureStage.class).error((Throwable)ex);
            }
        }, finishedState -> {
            if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
                TaskEventTrackerUtils.trackTaskFinished(this.getStudioProfilers(), this.getStudioProfilers().getSessionsManager().isSessionAlive(), finishedState);
            }
        });
    }

    @Override
    public void exit() {
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuCaptureHandler);
    }

    @Override
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.CPU_CAPTURE_STAGE;
    }

    private void addPinnedCpuAnalysisModel(@NotNull CpuAnalysisModel<?> model) {
        this.myPinnedAnalysisModels.add(model);
        this.myAspect.changed((Enum)Aspect.ANALYSIS_MODEL_UPDATED);
    }

    @Override
    @NotNull
    public Stage<?> getParentStage() {
        return new CpuProfilerStage(this.getStudioProfilers(), CpuCaptureMetadata.CpuProfilerEntryPoint.CHILD_STAGE_BACK_BTN_OR_FAILURE);
    }

    @Override
    @NotNull
    public Class<? extends Stage<?>> getHomeStageClass() {
        return CpuProfilerStage.class;
    }

    private void onCaptureParsed(@NotNull CpuCapture capture) {
        this.myTrackGroupTimeline.getDataRange().set(capture.getRange());
        this.myMinimapModel = new CpuCaptureMinimapModel(this.getStudioProfilers(), capture, this.getTimeline().getViewRange());
        if (!capture.getRange().isEmpty()) {
            this.initTrackGroupList(capture);
            this.addPinnedCpuAnalysisModel(new CpuFullTraceAnalysisModel(capture, this.getTimeline().getViewRange(), (Function1<Runnable, Unit>)((Function1)this::runInBackground)));
            CpuAnalysisModel<CpuCapture> jankModel = AndroidFrameTimelineAnalysisModel.of(capture);
            CpuAnalysisModel<CpuCapture> framesModel = FramesAnalysisModel.of(capture);
            if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isJankDetectionUiEnabled()) {
                if (jankModel != null) {
                    this.addPinnedCpuAnalysisModel(jankModel);
                } else if (framesModel != null) {
                    this.addPinnedCpuAnalysisModel(framesModel);
                }
            } else if (framesModel != null) {
                this.addPinnedCpuAnalysisModel(framesModel);
            }
        }
        if (SessionsManager.isSessionImported(this.getStudioProfilers().getSession()) && !this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
            this.insertImportedTraceEvent(capture);
        }
    }

    private void insertImportedTraceEvent(@NotNull CpuCapture capture) {
        Trace.TraceInfo.Builder importedTraceInfo = Trace.TraceInfo.newBuilder().setTraceId(this.getStudioProfilers().getSession().getSessionId()).setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMax()));
        Trace.TraceConfiguration.Builder config = Trace.TraceConfiguration.newBuilder();
        TraceConfigOptionsUtils.addDefaultTraceOptions(config, capture.getType());
        importedTraceInfo.setConfiguration(config);
        EventStreamServer streamServer = this.getStudioProfilers().getSessionsManager().getEventStreamServer(this.getStudioProfilers().getSession().getStreamId());
        if (streamServer != null) {
            streamServer.getEventDeque().offer(Common.Event.newBuilder().setGroupId(importedTraceInfo.getTraceId()).setTimestamp(importedTraceInfo.getToTimestamp()).setIsEnded(true).setKind(Common.Event.Kind.CPU_TRACE).setTraceData(Trace.TraceData.newBuilder().setTraceEnded(Trace.TraceData.TraceEnded.newBuilder().setTraceInfo(importedTraceInfo))).build());
        }
    }

    private void initTrackGroupList(@NotNull CpuCapture capture) {
        this.myTrackGroupModels.clear();
        final FeatureTracker featureTracker = this.getStudioProfilers().getIdeServices().getFeatureTracker();
        if (this.getStudioProfilers().getSession().getPid() != 0) {
            this.myTrackGroupModels.add(this.createInteractionTrackGroup());
        }
        if (capture instanceof SystemTraceCpuCapture && capture.getSystemTraceData() != null) {
            LogUtils.log(((Object)((Object)this)).getClass(), "CPU capture contains system trace data");
            this.createDisplayPipelineTrackGroups((SystemTraceCpuCapture)capture).forEach(this.myTrackGroupModels::add);
        }
        if (capture instanceof SystemTraceCpuCapture && capture.getSystemTraceData() != null && !capture.getSystemTraceData().getAndroidFrameTimelineEvents().isEmpty() && this.getStudioProfilers().getIdeServices().getFeatureConfig().isJankDetectionUiEnabled()) {
            this.myTrackGroupModels.add(this.createThreadsTrackGroup(capture));
            this.myTrackGroupModels.add(this.createCpuCoresTrackGroup(capture.getMainThreadId(), capture.getSystemTraceData()));
            this.myTrackGroupModels.add(this.createRssMemoryTrackGroup(capture.getSystemTraceData()));
        } else {
            if (capture instanceof SystemTraceCpuCapture && capture.getSystemTraceData() != null) {
                this.myTrackGroupModels.add(this.createCpuCoresTrackGroup(capture.getMainThreadId(), capture.getSystemTraceData()));
                this.myTrackGroupModels.add(this.createRssMemoryTrackGroup(capture.getSystemTraceData()));
            }
            this.myTrackGroupModels.add(this.createThreadsTrackGroup(capture));
        }
        if (capture instanceof SystemTraceCpuCapture && capture.getSystemTraceData() != null && this.getStudioProfilers().getIdeServices().getFeatureConfig().getSystemTracePowerProfilerDisplayMode() != PowerProfilerDisplayMode.HIDE) {
            if (!capture.getSystemTraceData().getPowerRailCounters().isEmpty()) {
                this.myTrackGroupModels.add(this.createPowerRailsTrackGroup(capture.getSystemTraceData()));
            }
            if (!capture.getSystemTraceData().getBatteryDrainCounters().isEmpty()) {
                this.myTrackGroupModels.add(this.createBatteryDrainTrackGroup(capture.getSystemTraceData()));
            }
        }
        this.myTrackGroupModels.forEach(model -> model.addActionListener(new TrackGroupActionListener(){

            public void onGroupMovedUp(@NotNull String title) {
                featureTracker.trackMoveTrackGroupUp(title);
            }

            public void onGroupMovedDown(@NotNull String title) {
                featureTracker.trackMoveTrackGroupDown(title);
            }

            public void onGroupCollapsed(@NotNull String title) {
                featureTracker.trackCollapseTrackGroup(title);
            }

            public void onGroupExpanded(@NotNull String title) {
                featureTracker.trackExpandTrackGroup(title);
            }

            public void onMouseOver(@NotNull String title) {
                featureTracker.trackMouseOverTrackGroup(title);
            }
        }));
    }

    private void onActiveSelectionChanged() {
        Object activeSelection = this.getMultiSelectionModel().getActiveSelectionKey();
        if (activeSelection instanceof AndroidFrameTimelineEvent) {
            AndroidFrameTimelineEvent event = (AndroidFrameTimelineEvent)activeSelection;
            this.getTimeline().getViewRange().adjustToContain((double)event.getExpectedStartUs(), (double)Math.max(event.getExpectedEndUs(), event.getActualEndUs()));
            this.trackFrameSelection();
        }
    }

    private void onSelectionChanged() {
        if (this.getMultiSelectionModel().getActiveSelectionKey() instanceof AndroidFrameTimelineEvent) {
            this.trackFrameSelection();
        }
    }

    private void trackFrameSelection() {
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackFrameSelectionPerTrace(++this.myFrameSelectionCount);
    }

    private TrackGroupModel createInteractionTrackGroup() {
        TrackGroupModel interaction = TrackGroupModel.newBuilder().setTitle("Interaction").build();
        EventModel userEventEventModel = new EventModel(new RangedSeries(this.myTrackGroupTimeline.getViewRange(), (DataSeries)new UserEventDataSeries(this.getStudioProfilers())));
        LifecycleEventModel lifecycleEventModel = new LifecycleEventModel(new RangedSeries(this.myTrackGroupTimeline.getViewRange(), (DataSeries)new LifecycleEventDataSeries(this.getStudioProfilers(), false)), new RangedSeries(this.myTrackGroupTimeline.getViewRange(), (DataSeries)new LifecycleEventDataSeries(this.getStudioProfilers(), true)));
        interaction.addTrackModel(TrackModel.newBuilder((Object)userEventEventModel, (Enum)ProfilerTrackRendererType.USER_INTERACTION, (String)"User").setDefaultTooltipModel((TooltipModel)new UserEventTooltip(this.myTrackGroupTimeline, (EventModel<UserEvent>)userEventEventModel)));
        interaction.addTrackModel(TrackModel.newBuilder((Object)lifecycleEventModel, (Enum)ProfilerTrackRendererType.APP_LIFECYCLE, (String)"Lifecycle").setDefaultTooltipModel((TooltipModel)new LifecycleTooltip(this.myTrackGroupTimeline, lifecycleEventModel)));
        return interaction;
    }

    private Stream<TrackGroupModel> createDisplayPipelineTrackGroups(@NotNull SystemTraceCpuCapture capture) {
        SystemTraceCpuCapture data = capture.getSystemTraceData();
        boolean isJankDetectionOn = this.getStudioProfilers().getIdeServices().getFeatureConfig().isJankDetectionUiEnabled() && !data.getAndroidFrameTimelineEvents().isEmpty();
        return isJankDetectionOn ? Stream.of(this.createJankDetectionTrackGroup(capture)) : Stream.concat(Stream.of(this.createDisplayTrackGroup(data)), IntStream.range(0, data.getAndroidFrameLayers().size()).mapToObj(layerIndex -> this.createFrameLifecycleTrackGroup(data.getAndroidFrameLayers().get(layerIndex), layerIndex > 0, data)));
    }

    private TrackGroupModel createDisplayTrackGroup(@NotNull CpuSystemTraceData systemTraceData) {
        TrackGroupModel display = TrackGroupModel.newBuilder().setTitle("Display").setTitleHelpText("This section contains display info. <p><b>Frames</b>: when a frame is being drawn. Long frames are colored red.</p><p><b>SurfaceFlinger</b>: system process responsible for sending buffers to display.</p><p><b>VSYNC</b>: a signal that synchronizes the display pipeline.</p><p><b>BufferQueue</b>: how many frame buffers are queued up, waiting for SurfaceFlinger to consume.</p>").setTitleHelpLink("Learn more", DISPLAY_HELP_LINK).build();
        if (systemTraceData.getAndroidFrameLayers().isEmpty()) {
            FrameState mainFrames = new FrameState(SystemTraceFrame.FrameThread.MAIN, systemTraceData, this.myTrackGroupTimeline.getViewRange());
            CpuFrameTooltip mainFrameTooltip = new CpuFrameTooltip(this.myTrackGroupTimeline);
            mainFrameTooltip.setFrameSeries(mainFrames.getSeries());
            display.addTrackModel(TrackModel.newBuilder((Object)mainFrames, (Enum)ProfilerTrackRendererType.FRAMES, (String)"Frames").setDefaultTooltipModel((TooltipModel)mainFrameTooltip));
        }
        SurfaceflingerTrackModel sfModel = new SurfaceflingerTrackModel(systemTraceData, this.myTrackGroupTimeline.getViewRange());
        SurfaceflingerTooltip sfTooltip = new SurfaceflingerTooltip(this.myTrackGroupTimeline, sfModel.getSurfaceflingerEvents());
        display.addTrackModel(TrackModel.newBuilder((Object)((Object)sfModel), (Enum)ProfilerTrackRendererType.SURFACEFLINGER, (String)"SurfaceFlinger").setDefaultTooltipModel((TooltipModel)sfTooltip));
        VsyncTrackModel vsyncModel = new VsyncTrackModel(systemTraceData, this.myTrackGroupTimeline.getViewRange());
        VsyncTooltip vsyncTooltip = new VsyncTooltip(this.myTrackGroupTimeline, (RangedSeries<Long>)vsyncModel.getVsyncCounterSeries());
        display.addTrackModel(TrackModel.newBuilder((Object)((Object)vsyncModel), (Enum)ProfilerTrackRendererType.VSYNC, (String)"VSYNC").setDefaultTooltipModel((TooltipModel)vsyncTooltip));
        BufferQueueTrackModel bufferQueueTrackModel = new BufferQueueTrackModel(systemTraceData, this.myTrackGroupTimeline.getViewRange());
        BufferQueueTooltip bufferQueueTooltip = new BufferQueueTooltip(this.myTrackGroupTimeline, (RangedSeries<Long>)bufferQueueTrackModel.getBufferQueueSeries());
        display.addTrackModel(TrackModel.newBuilder((Object)((Object)bufferQueueTrackModel), (Enum)ProfilerTrackRendererType.BUFFER_QUEUE, (String)"BufferQueue").setDefaultTooltipModel((TooltipModel)bufferQueueTooltip));
        return display;
    }

    private TrackGroupModel createFrameLifecycleTrackGroup(@NotNull TraceProcessor.AndroidFrameEventsResult.Layer layer, boolean collapseInitially, @NotNull CpuSystemTraceData data) {
        String title = "Frame Lifecycle (" + layer.getLayerName().substring(layer.getLayerName().lastIndexOf(47) + 1) + ")";
        TrackGroupModel frameLayer = TrackGroupModel.newBuilder().setTitle(title).setTitleHelpText("<p><b>Application</b>: Duration of the app drawing the frame. <p><b>Wait for GPU</b>: Time it takes the GPU to complete the frame.</p><p><b>Composition</b>: Composition time by SurfaceFlinger (not controlled by your app process).</p><p><b>Frames on display</b>: Duration of the frame presented on screen display.</p>").setTitleHelpLink("Learn more", "https://d.android.com/r/studio-ui/profiler/frame-lifecycle").setCollapsedInitially(collapseInitially).build();
        layer.getPhaseList().stream().map(phase -> new AndroidFrameEventTrackModel((TraceProcessor.AndroidFrameEventsResult.Phase)phase, this.myTrackGroupTimeline.getViewRange(), data.getVsyncCounterValues(), this.getMultiSelectionModel())).sorted(Comparator.comparingInt(trackModel -> trackModel.getAndroidFramePhase().ordinal())).forEach(trackModel -> {
            AndroidFrameEventTooltip tooltip = new AndroidFrameEventTooltip(this.myTrackGroupTimeline, (AndroidFrameEventTrackModel)((Object)trackModel));
            frameLayer.addTrackModel(TrackModel.newBuilder((Object)trackModel, (Enum)ProfilerTrackRendererType.ANDROID_FRAME_EVENT, (String)trackModel.getAndroidFramePhase().getDisplayName()).setDefaultTooltipModel((TooltipModel)tooltip));
        });
        return frameLayer;
    }

    private TrackGroupModel createJankDetectionTrackGroup(@NotNull SystemTraceCpuCapture capture) {
        FeatureTracker featureTracker = this.getStudioProfilers().getIdeServices().getFeatureTracker();
        String toggleAllFrames = "All Frames";
        String toggleLifeCycle = "Lifecycle";
        TrackGroupModel.Builder displayBuilder = TrackGroupModel.newBuilder().setTitle("Display").setTitleHelpText("<p><b>Janky frames</b>: Frames that lead to unstable frame rate or increased UI latency. Frames in red are janky due to app process running longer than expected. Frames in yellow are janky due to stuffed buffer queue.</p><p><b>All frames</b>: All frames being rendered by your app. Frames in green are on-time.</p><p><b>Application</b>: Duration of the app drawing the frame. Look for threads and events associated with the frame to fix jank.</p><p><b>Wait for GPU</b>: Time it takes the GPU to complete the frame.</p><p><b>Composition</b>: Composition time by SurfaceFlinger (not controlled by your app process).</p><p><b>Frames on display</b>: Duration of the frame presented on screen display.</p>").setTitleHelpLink("Learn more", DISPLAY_HELP_LINK).addDisplayToggle(toggleAllFrames, false, () -> this.getStudioProfilers().getIdeServices().getFeatureTracker().trackAllFrameTogglingPerTrace(++this.myAllFrameTogglingCount));
        if (!capture.getAndroidFrameLayers().isEmpty()) {
            displayBuilder.addDisplayToggle(toggleLifeCycle, false, () -> this.getStudioProfilers().getIdeServices().getFeatureTracker().trackLifecycleTogglingPerTrace(++this.myLifecycleTogglingCount));
        }
        TrackGroupModel display = displayBuilder.build();
        List<AndroidFrameTimelineEvent> events = capture.getAndroidFrameTimelineEvents();
        List<AndroidFrameTimelineEvent> jankEvents = events.stream().filter(AndroidFrameTimelineEvent::isActionableJank).collect(Collectors.toList());
        List<SeriesData<Long>> vsyncs = capture.getVsyncCounterValues();
        AndroidFrameTimelineModel jankyFrameModel = new AndroidFrameTimelineModel(jankEvents, vsyncs, this.myTrackGroupTimeline.getViewRange(), this.myMultiSelectionModel, capture);
        AndroidFrameTimelineModel allFramesModel = new AndroidFrameTimelineModel(events, vsyncs, this.myTrackGroupTimeline.getViewRange(), this.myMultiSelectionModel, capture);
        display.addTrackModel(TrackModel.newBuilder((Object)((Object)jankyFrameModel), (Enum)ProfilerTrackRendererType.ANDROID_FRAME_TIMELINE_EVENT, (String)"Janky frames").setDefaultTooltipModel((TooltipModel)new AndroidFrameTimelineTooltip(this.myTrackGroupTimeline, jankyFrameModel)), toggles -> !toggles.contains(toggleAllFrames));
        display.addTrackModel(TrackModel.newBuilder((Object)((Object)allFramesModel), (Enum)ProfilerTrackRendererType.ANDROID_FRAME_TIMELINE_EVENT, (String)"All frames").setDefaultTooltipModel((TooltipModel)new AndroidFrameTimelineTooltip(this.myTrackGroupTimeline, allFramesModel)), toggles -> toggles.contains(toggleAllFrames));
        Map timelineEventIndex = CollectionsKt.associateBy(capture.getAndroidFrameTimelineEvents(), AndroidFrameTimelineEvent::getSurfaceFrameToken);
        BiConsumer<Function1, Function1> adder = (frameFilter, displayingCondition) -> TraceProcessorModelKt.groupedByPhase(capture.getAndroidFrameLayers()).stream().map(phase -> new AndroidFrameEventTrackModel((TraceProcessor.AndroidFrameEventsResult.Phase)phase, this.myTrackGroupTimeline.getViewRange(), capture.getVsyncCounterValues(), this.myMultiSelectionModel, (Function1<? super TraceProcessor.AndroidFrameEventsResult.FrameEvent, Boolean>)frameFilter, (Map<Long, AndroidFrameTimelineEvent>)timelineEventIndex)).sorted(Comparator.comparingInt(model -> model.getAndroidFramePhase().ordinal())).forEach(model -> {
            AndroidFrameEventTooltip tooltip = new AndroidFrameEventTooltip(this.myTrackGroupTimeline, (AndroidFrameEventTrackModel)((Object)((Object)model)));
            display.addTrackModel(TrackModel.newBuilder((Object)model, (Enum)ProfilerTrackRendererType.ANDROID_FRAME_EVENT, (String)model.getAndroidFramePhase().getDisplayName()).setDefaultTooltipModel((TooltipModel)tooltip), displayingCondition);
        });
        adder.accept(frame -> true, toggles -> toggles.contains(toggleLifeCycle) && toggles.contains(toggleAllFrames));
        adder.accept(frame -> {
            AndroidFrameTimelineEvent event = (AndroidFrameTimelineEvent)timelineEventIndex.get(frame.getFrameNumber());
            return event != null && event.isActionableJank();
        }, toggles -> toggles.contains(toggleLifeCycle) && !toggles.contains(toggleAllFrames));
        display.addTrackModel(TrackModel.newBuilder((Object)new DeadlineTextModel(this.myMultiSelectionModel, capture.getVsyncCounterValues(), this.myTrackGroupTimeline.getViewRange()), (Enum)ProfilerTrackRendererType.ANDROID_FRAME_DEADLINE_TEXT, (String)"").setDragEnabled(false));
        return display;
    }

    private TrackGroupModel createThreadsTrackGroup(@NotNull CpuCapture capture) {
        FeatureTracker featureTracker = this.getStudioProfilers().getIdeServices().getFeatureTracker();
        boolean collapseThreads = !(capture instanceof SystemTraceCpuCapture);
        List threadInfos = capture.getThreads().stream().sorted(CpuThreadComparator.withCaptureInfo(capture)).collect(Collectors.toList());
        String threadsTitle = String.format(Locale.getDefault(), "Threads (%d)", threadInfos.size());
        BoxSelectionModel boxSelectionModel = new BoxSelectionModel(this.myTrackGroupTimeline.getSelectionRange(), this.myTrackGroupTimeline.getViewRange());
        boxSelectionModel.addBoxSelectionListener(featureTracker::trackSelectBox);
        TrackGroupModel threads = TrackGroupModel.newBuilder().setTitle(threadsTitle).setTitleHelpText("This section contains thread info. Double-click on the thread name to expand/collapse. Shift+click to select multiple threads.").setSelector(TrackGroupModel.makeBatchSelector((Object)CpuThreadTrackModel.class.getName())).setBoxSelectionModel(boxSelectionModel).build();
        for (CpuThreadInfo threadInfo : threadInfos) {
            String title = threadInfo.getName();
            threads.addTrackModel(TrackModel.newBuilder((Object)new CpuThreadTrackModel(capture, threadInfo, this.myTrackGroupTimeline, this.myMultiSelectionModel, (Function1<Runnable, Unit>)((Function1)this::runInBackground)), (Enum)ProfilerTrackRendererType.CPU_THREAD, (String)title).setCollapsible(true).setCollapsed(collapseThreads));
        }
        return threads;
    }

    private TrackGroupModel createCpuCoresTrackGroup(int mainThreadId, @NotNull CpuSystemTraceData systemTraceData) {
        int cpuCount = systemTraceData.getCpuCount();
        String coresTitle = String.format(Locale.getDefault(), "CPU cores (%d)", cpuCount);
        TrackGroupModel cores = TrackGroupModel.newBuilder().setTitle(coresTitle).setCollapsedInitially(true).build();
        for (int cpuId = 0; cpuId < cpuCount; ++cpuId) {
            int coreId = cpuId;
            LazyDataSeries<CpuThreadSliceInfo> coreSchedSeries = new LazyDataSeries<CpuThreadSliceInfo>(() -> systemTraceData.getCpuThreadSliceInfoStates(coreId));
            CpuKernelTooltip kernelTooltip = new CpuKernelTooltip(this.myTrackGroupTimeline, mainThreadId);
            kernelTooltip.setCpuSeries(cpuId, coreSchedSeries);
            cores.addTrackModel(TrackModel.newBuilder((Object)new CpuCoreTrackModel(coreSchedSeries, this.myTrackGroupTimeline.getViewRange(), mainThreadId), (Enum)ProfilerTrackRendererType.CPU_CORE, (String)("CPU " + cpuId)).setDefaultTooltipModel((TooltipModel)kernelTooltip));
            String cpuFrequencyTitle = "CPU " + cpuId + " Frequency";
            List<SeriesData<Long>> cpuFreqCounters = systemTraceData.getCpuCounters().get(cpuId).getOrDefault("cpufreq", Collections.emptyList());
            CpuFrequencyTrackModel cpuFreqTrackModel = new CpuFrequencyTrackModel(cpuFreqCounters, this.myTrackGroupTimeline.getViewRange());
            CpuFrequencyTooltip cpuFreqTooltip = new CpuFrequencyTooltip(this.myTrackGroupTimeline, cpuId, (RangedSeries<Long>)cpuFreqTrackModel.getCpuFrequencySeries());
            cores.addTrackModel(TrackModel.newBuilder((Object)((Object)cpuFreqTrackModel), (Enum)ProfilerTrackRendererType.CPU_FREQUENCY, (String)cpuFrequencyTitle).setDefaultTooltipModel((TooltipModel)cpuFreqTooltip));
        }
        return cores;
    }

    private TrackGroupModel createRssMemoryTrackGroup(@NotNull CpuSystemTraceData systemTraceData) {
        TrackGroupModel memory = TrackGroupModel.newBuilder().setTitle("Process Memory (RSS)").setTitleHelpText("This section shows the memory footprint of the app.<p><b>Resident Set Size (RSS)</b> is the portion of memory the app occupies in RAM, combining both shared and non-shared pages.</p>").setTitleHelpLink("Learn more", "https://d.android.com/r/studio-ui/profiler/rss-memory").setCollapsedInitially(true).build();
        RssMemoryTrackModel.Companion.getIncludedCountersNameMap().forEach((counterName, displayName) -> {
            if (systemTraceData.getMemoryCounters().containsKey(counterName)) {
                RssMemoryTrackModel trackModel = new RssMemoryTrackModel(systemTraceData.getMemoryCounters().get(counterName), this.myTrackGroupTimeline.getViewRange());
                RssMemoryTooltip tooltip = new RssMemoryTooltip(this.myTrackGroupTimeline, (String)counterName, (RangedSeries<Long>)trackModel.getMemoryCounterSeries());
                memory.addTrackModel(TrackModel.newBuilder((Object)((Object)trackModel), (Enum)ProfilerTrackRendererType.RSS_MEMORY, (String)displayName).setDefaultTooltipModel((TooltipModel)tooltip));
            }
        });
        return memory;
    }

    private TrackGroupModel createPowerRailsTrackGroup(@NotNull CpuSystemTraceData systemTraceData) {
        PowerProfilerDisplayMode displayMode = this.getStudioProfilers().getIdeServices().getFeatureConfig().getSystemTracePowerProfilerDisplayMode();
        String displayModeTitleCase = StringFormattingUtils.formatStringInTitleCase(displayMode.name());
        TrackGroupModel power = TrackGroupModel.newBuilder().setTitle("Power Rails (" + displayModeTitleCase + ")").setTitleHelpText("This section shows the device's power consumption per hardware component.<br/><b>Power Rails</b> are wires in your device that connect the battery to hardware modules.").setTitleHelpLink("Learn more", POWER_RAILS_HELP_LINK).setCollapsedInitially(false).build();
        systemTraceData.getPowerRailCounters().forEach((trackName, trackData) -> {
            PowerRailTrackModel trackModel = new PowerRailTrackModel((PowerCounterData)trackData, this.myTrackGroupTimeline.getViewRange(), displayMode);
            PowerRailTooltip tooltip = new PowerRailTooltip(this.myTrackGroupTimeline, (String)trackName, (RangedSeries<Long>)trackModel.getPrimaryPowerRailCounterSeries(), (RangedSeries<Long>)trackModel.getSecondaryPowerRailCounterSeries(), displayMode);
            power.addTrackModel(TrackModel.newBuilder((Object)((Object)trackModel), (Enum)ProfilerTrackRendererType.ANDROID_POWER_RAIL, (String)trackName).setDefaultTooltipModel((TooltipModel)tooltip));
        });
        return power;
    }

    private TrackGroupModel createBatteryDrainTrackGroup(@NotNull CpuSystemTraceData systemTraceData) {
        boolean containsODPM = !systemTraceData.getPowerRailCounters().isEmpty();
        boolean containsCoulombCounter = systemTraceData.getBatteryDrainCounters().size() == PerfettoTraceConfigBuilders.getBatteryCountersCount();
        String compatibilityMessage = "";
        if (!containsODPM && !containsCoulombCounter) {
            compatibilityMessage = "You are currently using a device which does not support coulomb counters. To view additional power data (such as charge, current, etc), we recommend using a device which supports coulomb counters.";
        } else if (!containsODPM) {
            compatibilityMessage = "You are currently using a device that does not support On Device Power Rails Monitor (ODPM), which measures power consumption per hardware component. To view power rail data, we recommend using a device which supports ODPM, such as Pixel 6a, Pixel 6, Pixel 6 Pro, Pixel 7a, Pixel 7, Pixel 7 Pro and beyond. Battery info is available on devices running Android Q+.";
        }
        TrackGroupModel battery = TrackGroupModel.newBuilder().setTitle("Battery").setTitleHelpText("This section shows the device's battery consumption in three contexts: <ul><li>Capacity: remaining battery percentage (%)</li><li>Charge: remaining battery charge in microampere-hours (\u00b5Ah)</li><li>Current: instantaneous current in microampere (\u00b5A)</li></ul><b>" + compatibilityMessage + "</b>").setCollapsedInitially(false).build();
        systemTraceData.getBatteryDrainCounters().forEach((trackName, trackData) -> {
            String unit = BatteryDrainTrackModel.getUnitFromTrackName(trackName);
            String formattedTrackName = BatteryDrainTrackModel.getFormattedBatteryDrainName(trackName);
            BatteryDrainTrackModel trackModel = new BatteryDrainTrackModel((List<SeriesData<Long>>)trackData, this.myTrackGroupTimeline.getViewRange(), unit);
            BatteryDrainTooltip tooltip = new BatteryDrainTooltip(this.myTrackGroupTimeline, formattedTrackName, unit, (RangedSeries<Long>)trackModel.getBatteryDrainCounterSeries());
            battery.addTrackModel(TrackModel.newBuilder((Object)((Object)trackModel), (Enum)ProfilerTrackRendererType.ANDROID_BATTERY_DRAIN, (String)formattedTrackName).setDefaultTooltipModel((TooltipModel)tooltip));
        });
        return battery;
    }

    private Unit runInBackground(Runnable work) {
        this.getStudioProfilers().getIdeServices().getPoolExecutor().execute(work);
        return Unit.INSTANCE;
    }

    public static enum State {
        PARSING,
        ANALYZING;

    }

    public static enum Aspect {
        STATE,
        ANALYSIS_MODEL_UPDATED;

    }
}

