/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.common.AdtUiUtils;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.event.InputEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class CpuListScrollPane
extends JBScrollPane {
    CpuListScrollPane(@NotNull JList viewportView, @NotNull JComponent dispatchComponent) {
        this.getVerticalScrollBar().setOpaque(false);
        this.setBorder((Border)JBUI.Borders.empty());
        this.setViewportView(viewportView);
        this.addMouseWheelListener(new CpuMouseWheelListener(dispatchComponent));
    }

    protected JViewport createViewport() {
        if (SystemInfo.isMac) {
            return super.createViewport();
        }
        return new JViewport();
    }

    private static class CpuMouseWheelListener
    implements MouseWheelListener {
        @NotNull
        private final JComponent myDispatchComponent;

        public CpuMouseWheelListener(@NotNull JComponent dispatchComponent) {
            this.myDispatchComponent = dispatchComponent;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            boolean isMenuKeyDown = AdtUiUtils.isActionKeyDown((InputEvent)e);
            boolean isShiftKeyDown = e.isShiftDown();
            if (isMenuKeyDown || isShiftKeyDown) {
                this.myDispatchComponent.dispatchEvent(e);
            }
        }
    }
}

