/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuThreadsView;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.CpuUsageView;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.cpu.LiveCpuUsageModel;
import com.intellij.ui.components.JBPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DetailedCpuChart {
    @NotNull
    private final CpuThreadsView myThreads;
    @NotNull
    private final StudioProfilersView myProfilersView;
    @NotNull
    private final CpuUsageView myUsageView;
    @NotNull
    private final StudioProfilers myStudioProfilers;
    private final AspectModel<CpuProfilerAspect> myAspect;

    public DetailedCpuChart(StudioProfilersView profilersView, LiveCpuUsageModel liveCpuUsageModel) {
        this(profilersView, liveCpuUsageModel.getCpuUsageAxis(), liveCpuUsageModel.getThreadCountAxis(), liveCpuUsageModel.getCpuUsage(), liveCpuUsageModel.getTraceDurations(), liveCpuUsageModel.getLegends(), liveCpuUsageModel.getName(), liveCpuUsageModel::setAndSelectCapture, liveCpuUsageModel.getThreadStates(), liveCpuUsageModel.getUpdatableManager(), liveCpuUsageModel.getStudioProfilers(), liveCpuUsageModel.getTimeAxisGuide(), liveCpuUsageModel::getSelectedThread, liveCpuUsageModel::setSelectedThread, liveCpuUsageModel.getAspect(), liveCpuUsageModel.getStage());
    }

    public DetailedCpuChart(StudioProfilersView profilersView, CpuProfilerStage cpuProfilerStage) {
        this(profilersView, cpuProfilerStage.getCpuUsageAxis(), cpuProfilerStage.getThreadCountAxis(), cpuProfilerStage.getCpuUsage(), cpuProfilerStage.getTraceDurations(), cpuProfilerStage.getLegends(), cpuProfilerStage.getName(), cpuProfilerStage::setAndSelectCapture, cpuProfilerStage.getThreadStates(), cpuProfilerStage.getUpdatableManager(), cpuProfilerStage.getStudioProfilers(), cpuProfilerStage.getTimeAxisGuide(), cpuProfilerStage::getSelectedThread, cpuProfilerStage::setSelectedThread, cpuProfilerStage.getAspect(), cpuProfilerStage);
    }

    private DetailedCpuChart(StudioProfilersView profilersView, AxisComponentModel cpuUsageAxis, AxisComponentModel threadCountAxis, DetailedCpuUsage detailedCpuUsage, DurationDataModel<CpuTraceInfo> traceDurations, CpuProfilerStage.CpuStageLegends cpuStageLegends, String name, Consumer<Long> stageSetAndSelectCapture, CpuThreadsModel threadStates, UpdatableManager updatableManager, StudioProfilers studioProfilers, AxisComponentModel timeAxisGuide, Supplier<Integer> getSelectedThread, Consumer<Integer> setSelectedThread, AspectModel<CpuProfilerAspect> aspect, Stage stage) {
        this.myProfilersView = profilersView;
        this.myStudioProfilers = studioProfilers;
        this.myAspect = aspect;
        this.myUsageView = new CpuUsageView(cpuUsageAxis, threadCountAxis, detailedCpuUsage, traceDurations, cpuStageLegends, name, stageSetAndSelectCapture);
        this.myThreads = new CpuThreadsView(threadStates, updatableManager, this.myStudioProfilers, timeAxisGuide, getSelectedThread, setSelectedThread, aspect, stage);
    }

    JPanel createCpuDetailsPanel(int toolTipRowSpan, RangeTooltipComponent myTooltipComponent) {
        JPanel details = new JPanel((LayoutManager)new TabularLayout("*", "Fit-,*"));
        details.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        details.add((Component)myTooltipComponent, new TabularLayout.Constraint(0, 0, toolTipRowSpan, 1));
        TabularLayout mainLayout = new TabularLayout("*");
        mainLayout.setRowSizing(PanelSizing.MONITOR.getRow(), PanelSizing.MONITOR.getRowRule());
        mainLayout.setRowSizing(PanelSizing.DETAILS.getRow(), PanelSizing.DETAILS.getRowRule());
        JBPanel mainPanel = new JBPanel((LayoutManager)mainLayout);
        mainPanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        mainPanel.add((Component)((Object)this.myUsageView), new TabularLayout.Constraint(PanelSizing.MONITOR.getRow(), 0));
        mainPanel.add((Component)this.createCpuStatePanel(myTooltipComponent), new TabularLayout.Constraint(PanelSizing.DETAILS.getRow(), 0));
        details.add((Component)mainPanel, new TabularLayout.Constraint(1, 0));
        return details;
    }

    @NotNull
    JPanel createCpuStatePanel(RangeTooltipComponent myTooltipComponent) {
        TabularLayout cpuStateLayout = new TabularLayout("*");
        JBPanel cpuStatePanel = new JBPanel((LayoutManager)cpuStateLayout);
        cpuStatePanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        cpuStateLayout.setRowSizing(PanelSizing.THREADS.getRow(), PanelSizing.THREADS.getRowRule());
        myTooltipComponent.registerListenersOn(this.myThreads.getComponent());
        cpuStatePanel.add((Component)this.myThreads.getComponent(), new TabularLayout.Constraint(PanelSizing.THREADS.getRow(), 0));
        return cpuStatePanel;
    }

    @NotNull
    public StudioProfilersView getProfilersView() {
        return this.myProfilersView;
    }

    public CpuUsageView getUsageView() {
        return this.myUsageView;
    }

    public CpuThreadsView getThreadsView() {
        return this.myThreads;
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    protected static enum PanelSizing {
        MONITOR("140px", 0),
        DETAILS("*", 1),
        THREADS("*", 0);

        @NotNull
        private final String myRowRule;
        private final int myRow;

        private PanelSizing(String rowRule, int row) {
            this.myRowRule = rowRule;
            this.myRow = row;
        }

        @NotNull
        public String getRowRule() {
            return this.myRowRule;
        }

        public int getRow() {
            return this.myRow;
        }
    }
}

