/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.profilers.LiveDataView;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CpuProfilerStageCpuUsageTooltip;
import com.android.tools.profilers.cpu.CpuProfilerStageCpuUsageTooltipView;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.android.tools.profilers.cpu.CpuThreadsTooltipView;
import com.android.tools.profilers.cpu.DetailedCpuChart;
import com.android.tools.profilers.cpu.LiveCpuUsageModel;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class LiveCpuUsageView
extends LiveDataView<LiveCpuUsageModel> {
    public final JComponent myComponent;
    private final DetailedCpuChart myDetailedCpuChart;
    private final LiveCpuUsageModel myAllocationModel;
    private final TooltipModel myCpuTooltipModel;
    private final StudioProfilersView myProfilersView;

    public LiveCpuUsageView(@NotNull StudioProfilersView profilersView, @NotNull LiveCpuUsageModel allocationModel) {
        super(allocationModel);
        this.myProfilersView = profilersView;
        this.myAllocationModel = allocationModel;
        this.myDetailedCpuChart = new DetailedCpuChart(profilersView, allocationModel);
        TabularLayout topPanelLayout = new TabularLayout("*", "*,Fit-");
        this.myComponent = new JPanel((LayoutManager)topPanelLayout);
        this.myComponent.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myCpuTooltipModel = this.myAllocationModel.getTooltip();
    }

    @Override
    public JComponent getComponent() {
        return this.myComponent;
    }

    public JComponent getUsageTooltipComponent() {
        return this.myDetailedCpuChart.getUsageView();
    }

    @Override
    public void registerTooltip(ViewBinder<StageView, TooltipModel, TooltipView> binder, @NotNull RangeTooltipComponent rangeTooltipComponent, Stage stage) {
        binder.bind(CpuProfilerStageCpuUsageTooltip.class, CpuProfilerStageCpuUsageTooltipView::new);
        binder.bind(CpuThreadsTooltip.class, (stageView, tooltip) -> new CpuThreadsTooltipView(stageView.getComponent(), (CpuThreadsTooltip)((Object)tooltip)));
        rangeTooltipComponent.registerListenersOn(this.getUsageTooltipComponent());
        ProfilerTooltipMouseAdapter listener = new ProfilerTooltipMouseAdapter(stage, () -> this.myCpuTooltipModel);
        this.getUsageTooltipComponent().addMouseListener(listener);
        this.myProfilersView.installCommonMenuItems((JComponent)((Object)this.myDetailedCpuChart.getUsageView()));
        this.myProfilersView.installCommonMenuItems(this.myDetailedCpuChart.getThreadsView().getComponent());
    }

    @Override
    public void populateUi(RangeTooltipComponent tooltipComponent) {
        this.myComponent.add((Component)this.myDetailedCpuChart.createCpuDetailsPanel(2, tooltipComponent), new TabularLayout.Constraint(0, 0));
    }
}

