/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.Trace;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.ArtSampledConfiguration;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import org.jetbrains.annotations.NotNull;

public enum ProfilingTechnology {
    ART_SAMPLED("Java/Kotlin Method Sample Recording (legacy)", "Samples Java/Kotlin code using Android Runtime."),
    ART_INSTRUMENTED("Java/Kotlin Method Trace Recording", "Instruments Java/Kotlin code using Android Runtime, tracking every method call (this incurs high overhead making timing information inaccurate)."),
    ART_UNSPECIFIED("Java/Kotlin Method Recording", "Profiles method calls using Android Runtime."),
    SIMPLEPERF("Callstack Sample Recording", "Samples Java/Kotlin and native code using simpleperf.", "Available for Android 8.0 (API level 26) and higher."),
    SYSTEM_TRACE("System Trace Recording", "Traces Java/Kotlin and native code at the Android platform level.", "Available for Android 7.0 (API level 24) and higher.");

    @NotNull
    private final String myName;
    @NotNull
    private final String myDescription;
    @NotNull
    private final String myExtraDescription;

    private ProfilingTechnology(@NotNull String name, String description, String extraDescription) {
        this.myName = name;
        this.myDescription = description;
        this.myExtraDescription = extraDescription;
    }

    private ProfilingTechnology(String name, String description) {
        this(name, description, "");
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public String getLongDescription() {
        return String.format("<html>%s %s</html>", this.myDescription, this.myExtraDescription);
    }

    @NotNull
    public ProfilingConfiguration.TraceType getType() {
        switch (this) {
            case ART_SAMPLED: {
                return ProfilingConfiguration.TraceType.ART;
            }
            case ART_INSTRUMENTED: {
                return ProfilingConfiguration.TraceType.ART;
            }
            case ART_UNSPECIFIED: {
                return ProfilingConfiguration.TraceType.ART;
            }
            case SIMPLEPERF: {
                return ProfilingConfiguration.TraceType.SIMPLEPERF;
            }
            case SYSTEM_TRACE: {
                return ProfilingConfiguration.TraceType.ATRACE;
            }
        }
        throw new IllegalArgumentException("Unreachable code");
    }

    @NotNull
    public Trace.TraceMode getMode() {
        switch (this) {
            case ART_SAMPLED: {
                return Trace.TraceMode.SAMPLED;
            }
            case ART_INSTRUMENTED: {
                return Trace.TraceMode.INSTRUMENTED;
            }
            case ART_UNSPECIFIED: {
                return Trace.TraceMode.UNSPECIFIED_MODE;
            }
            case SIMPLEPERF: {
                return Trace.TraceMode.SAMPLED;
            }
            case SYSTEM_TRACE: {
                return Trace.TraceMode.INSTRUMENTED;
            }
        }
        throw new IllegalArgumentException("Unreachable code");
    }

    @NotNull
    public static ProfilingTechnology fromTraceConfiguration(@NotNull Trace.TraceConfiguration config) {
        switch (config.getUnionCase()) {
            case ART_OPTIONS: {
                if (config.getArtOptions().getTraceMode() == Trace.TraceMode.SAMPLED) {
                    return ART_SAMPLED;
                }
                if (config.getArtOptions().getTraceMode() == Trace.TraceMode.INSTRUMENTED) {
                    return ART_INSTRUMENTED;
                }
                return ART_UNSPECIFIED;
            }
            case SIMPLEPERF_OPTIONS: {
                return SIMPLEPERF;
            }
            case ATRACE_OPTIONS: 
            case PERFETTO_OPTIONS: {
                return SYSTEM_TRACE;
            }
        }
        throw new IllegalStateException("Error while trying to get the name of an unknown profiling configuration");
    }

    @NotNull
    public static ProfilingTechnology fromConfig(@NotNull ProfilingConfiguration config) {
        switch (config.getTraceType()) {
            case ART: {
                if (config instanceof ArtSampledConfiguration) {
                    return ART_SAMPLED;
                }
                if (config instanceof ArtInstrumentedConfiguration) {
                    return ART_INSTRUMENTED;
                }
                return ART_UNSPECIFIED;
            }
            case SIMPLEPERF: {
                return SIMPLEPERF;
            }
            case ATRACE: 
            case PERFETTO: {
                return SYSTEM_TRACE;
            }
        }
        throw new IllegalStateException("Error while trying to get the name of an unknown profiling configuration");
    }
}

