/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.android.tools.profilers.DataVisualizationColors;
import com.android.tools.profilers.cpu.VsyncPanel;
import com.android.tools.profilers.cpu.systemtrace.VsyncTrackModel;
import java.awt.Color;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class VsyncTrackRenderer
implements TrackRenderer<VsyncTrackModel> {
    private final BooleanSupplier myVsyncEnabler;

    public VsyncTrackRenderer(BooleanSupplier vsyncEnabler) {
        this.myVsyncEnabler = vsyncEnabler;
    }

    @NotNull
    public JComponent render(@NotNull TrackModel<VsyncTrackModel, ?> trackModel) {
        VsyncTrackModel lineChartModel = (VsyncTrackModel)((Object)trackModel.getDataModel());
        LineChart lineChart = new LineChart((LineChartModel)lineChartModel);
        lineChart.configure(lineChartModel.getVsyncCounterSeries(), new LineConfig((Color)DataVisualizationColors.getPaletteManager().getBackgroundColor("Gray", 0)).setStepped(true));
        lineChart.setFillEndGap(true);
        return VsyncPanel.of((JComponent)lineChart, (RangedSeries<Long>)((VsyncTrackModel)((Object)trackModel.getDataModel())).getVsyncCounterSeries(), this.myVsyncEnabler);
    }
}

