/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.profiler.perfetto.proto.TraceProcessor;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.analysis.PaginatedTableModel;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineEvent;
import com.android.tools.profilers.cpu.systemtrace.CpuSystemTraceData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0014\u0015\u0016\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J&\u0010\b\u001a\u00020\t*\u00020\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0\fH\u0002J(\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0013\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/profilers/cpu/analysis/AndroidFrameTimelineAnalysisModel;", "", "<init>", "()V", "of", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisModel;", "Lcom/android/tools/profilers/cpu/CpuCapture;", "capture", "toRow", "Lcom/android/tools/profilers/cpu/analysis/AndroidFrameTimelineAnalysisModel$Row;", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameTimelineEvent;", "lifeCycleUs", "Lkotlin/Function2;", "", "Lcom/android/tools/profilers/cpu/analysis/AndroidFrameTimelineAnalysisModel$Phase;", "lifeCycleDurationIndex", "layers", "", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$AndroidFrameEventsResult$Layer;", "INVALID_DURATION", "Tab", "Row", "Column", "Phase", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nAndroidFrameTimelineAnalysisModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidFrameTimelineAnalysisModel.kt\ncom/android/tools/profilers/cpu/analysis/AndroidFrameTimelineAnalysisModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1863#2:93\n1863#2,2:94\n1864#2:96\n1863#2,2:97\n*S KotlinDebug\n*F\n+ 1 AndroidFrameTimelineAnalysisModel.kt\ncom/android/tools/profilers/cpu/analysis/AndroidFrameTimelineAnalysisModel\n*L\n77#1:93\n78#1:94,2\n77#1:96\n71#1:97,2\n*E\n"})
public final class AndroidFrameTimelineAnalysisModel {
    @NotNull
    public static final AndroidFrameTimelineAnalysisModel INSTANCE = new AndroidFrameTimelineAnalysisModel();
    public static final long INVALID_DURATION = Long.MAX_VALUE;

    private AndroidFrameTimelineAnalysisModel() {
    }

    @JvmStatic
    @Nullable
    public static final CpuAnalysisModel<CpuCapture> of(@NotNull CpuCapture capture) {
        CpuAnalysisModel cpuAnalysisModel;
        Intrinsics.checkNotNullParameter((Object)capture, (String)"capture");
        Object object = capture.getSystemTraceData();
        boolean bl = object != null && (object = object.getAndroidFrameTimelineEvents()) != null ? !((Collection)object).isEmpty() : false;
        if (bl) {
            CpuAnalysisModel cpuAnalysisModel2;
            CpuAnalysisModel $this$of_u24lambda_u242 = cpuAnalysisModel2 = new CpuAnalysisModel("All Frames");
            boolean bl2 = false;
            $this$of_u24lambda_u242.addTabModel(new Tab(capture, (Function1<? super Row, Boolean>)((Function1)AndroidFrameTimelineAnalysisModel::of$lambda$2$lambda$0), CpuAnalysisTabModel.Type.FRAMES));
            $this$of_u24lambda_u242.addTabModel(new Tab(capture, (Function1<? super Row, Boolean>)((Function1)AndroidFrameTimelineAnalysisModel::of$lambda$2$lambda$1), CpuAnalysisTabModel.Type.JANKS));
            cpuAnalysisModel = cpuAnalysisModel2;
        } else {
            cpuAnalysisModel = null;
        }
        return cpuAnalysisModel;
    }

    private final Row toRow(AndroidFrameTimelineEvent $this$toRow, Function2<? super Long, ? super Phase, Long> lifeCycleUs) {
        return new Row($this$toRow, ((Number)lifeCycleUs.invoke((Object)$this$toRow.getSurfaceFrameToken(), (Object)Phase.App)).longValue(), ((Number)lifeCycleUs.invoke((Object)$this$toRow.getSurfaceFrameToken(), (Object)Phase.Gpu)).longValue(), ((Number)lifeCycleUs.invoke((Object)$this$toRow.getSurfaceFrameToken(), (Object)Phase.Composition)).longValue());
    }

    private final Function2<Long, Phase, Long> lifeCycleDurationIndex(List<TraceProcessor.AndroidFrameEventsResult.Layer> layers) {
        Map appCache = new LinkedHashMap();
        Map gpuCache = new LinkedHashMap();
        Map compCache = new LinkedHashMap();
        Iterable $this$forEach$iv = layers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TraceProcessor.AndroidFrameEventsResult.Layer layer = (TraceProcessor.AndroidFrameEventsResult.Layer)element$iv;
            boolean bl = false;
            List list = layer.getPhaseList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPhaseList(...)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TraceProcessor.AndroidFrameEventsResult.Phase phase = (TraceProcessor.AndroidFrameEventsResult.Phase)element$iv2;
                boolean bl2 = false;
                String string = phase.getPhaseName();
                if (string == null) continue;
                int n = -1;
                switch (string.hashCode()) {
                    case 66049: {
                        if (string.equals("App")) {
                            n = 1;
                        }
                        break;
                    }
                    case 828944778: {
                        if (string.equals("Composition")) {
                            n = 2;
                        }
                        break;
                    }
                    case 70796: {
                        if (string.equals("GPU")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        List list2 = phase.getFrameEventList();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFrameEventList(...)");
                        AndroidFrameTimelineAnalysisModel.lifeCycleDurationIndex$cache(appCache, list2);
                        break;
                    }
                    case 3: {
                        List list3 = phase.getFrameEventList();
                        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getFrameEventList(...)");
                        AndroidFrameTimelineAnalysisModel.lifeCycleDurationIndex$cache(gpuCache, list3);
                        break;
                    }
                    case 2: {
                        List list4 = phase.getFrameEventList();
                        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getFrameEventList(...)");
                        AndroidFrameTimelineAnalysisModel.lifeCycleDurationIndex$cache(compCache, list4);
                    }
                }
            }
        }
        return (arg_0, arg_1) -> AndroidFrameTimelineAnalysisModel.lifeCycleDurationIndex$lambda$6(appCache, gpuCache, compCache, arg_0, arg_1);
    }

    private static final boolean of$lambda$2$lambda$0(Row it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean of$lambda$2$lambda$1(Row it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTimelineEvent().isActionableJank();
    }

    private static final void lifeCycleDurationIndex$cache(Map<Long, Long> cache, List<TraceProcessor.AndroidFrameEventsResult.FrameEvent> events) {
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TraceProcessor.AndroidFrameEventsResult.FrameEvent it = (TraceProcessor.AndroidFrameEventsResult.FrameEvent)element$iv;
            boolean bl = false;
            cache.put(Long.valueOf(it.getFrameNumber()), TimeUnit.NANOSECONDS.toMicros(it.getDurationNanoseconds()));
        }
    }

    private static final long lifeCycleDurationIndex$lambda$6(Map $appCache, Map $gpuCache, Map $compCache, long frameNumber, Phase phase) {
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        Long l = (Long)(switch (WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
            case 1 -> $appCache;
            case 2 -> $gpuCache;
            case 3 -> $compCache;
            default -> throw new NoWhenBranchMatchedException();
        }).get(frameNumber);
        return l != null ? l : Long.MAX_VALUE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/profilers/cpu/analysis/AndroidFrameTimelineAnalysisModel$Column;", "", "title", "", "type", "Ljava/lang/Class;", "getValue", "Lkotlin/Function1;", "Lcom/android/tools/profilers/cpu/analysis/AndroidFrameTimelineAnalysisModel$Row;", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)V", "getTitle", "()Ljava/lang/String;", "getType", "()Ljava/lang/Class;", "getGetValue", "()Lkotlin/jvm/functions/Function1;", "FRAME_NUMBER", "TOTAL_TIME", "APP_TIME", "GPU_TIME", "COMPOSITION_TIME", "intellij.android.profilers"})
    public static final class Column
    extends Enum<Column> {
        @NotNull
        private final String title;
        @NotNull
        private final Class<?> type;
        @NotNull
        private final Function1<Row, Comparable<?>> getValue;
        public static final /* enum */ Column FRAME_NUMBER = new Column("Frame #", Long.TYPE, Column::_init_$lambda$0);
        public static final /* enum */ Column TOTAL_TIME = new Column("Frame Duration", Long.TYPE, Column::_init_$lambda$1);
        public static final /* enum */ Column APP_TIME = new Column("Application", Long.TYPE, (Function1)3.INSTANCE);
        public static final /* enum */ Column GPU_TIME = new Column("GPU", Long.TYPE, (Function1)4.INSTANCE);
        public static final /* enum */ Column COMPOSITION_TIME = new Column("Composition", Long.TYPE, (Function1)5.INSTANCE);
        private static final /* synthetic */ Column[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Column(String title, Class<?> type, Function1<? super Row, ? extends Comparable<?>> getValue) {
            this.title = title;
            this.type = type;
            this.getValue = getValue;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final Class<?> getType() {
            return this.type;
        }

        @NotNull
        public final Function1<Row, Comparable<?>> getGetValue() {
            return this.getValue;
        }

        public static Column[] values() {
            return (Column[])$VALUES.clone();
        }

        public static Column valueOf(String value) {
            return Enum.valueOf(Column.class, value);
        }

        @NotNull
        public static EnumEntries<Column> getEntries() {
            return $ENTRIES;
        }

        private static final Comparable _init_$lambda$0(Row it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Long.valueOf(it.getTimelineEvent().getSurfaceFrameToken());
        }

        private static final Comparable _init_$lambda$1(Row it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Long.valueOf(it.getTimelineEvent().getActualDurationUs());
        }

        static {
            $VALUES = columnArray = new Column[]{Column.FRAME_NUMBER, Column.TOTAL_TIME, Column.APP_TIME, Column.GPU_TIME, Column.COMPOSITION_TIME};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/profilers/cpu/analysis/AndroidFrameTimelineAnalysisModel$Phase;", "", "<init>", "(Ljava/lang/String;I)V", "App", "Gpu", "Composition", "intellij.android.profilers"})
    public static final class Phase
    extends Enum<Phase> {
        public static final /* enum */ Phase App = new Phase();
        public static final /* enum */ Phase Gpu = new Phase();
        public static final /* enum */ Phase Composition = new Phase();
        private static final /* synthetic */ Phase[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Phase[] values() {
            return (Phase[])$VALUES.clone();
        }

        public static Phase valueOf(String value) {
            return Enum.valueOf(Phase.class, value);
        }

        @NotNull
        public static EnumEntries<Phase> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = phaseArray = new Phase[]{Phase.App, Phase.Gpu, Phase.Composition};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/profilers/cpu/analysis/AndroidFrameTimelineAnalysisModel$Row;", "", "timelineEvent", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameTimelineEvent;", "appUs", "", "gpuUs", "compUs", "<init>", "(Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameTimelineEvent;JJJ)V", "getTimelineEvent", "()Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameTimelineEvent;", "getAppUs", "()J", "getGpuUs", "getCompUs", "intellij.android.profilers"})
    public static final class Row {
        @NotNull
        private final AndroidFrameTimelineEvent timelineEvent;
        private final long appUs;
        private final long gpuUs;
        private final long compUs;

        public Row(@NotNull AndroidFrameTimelineEvent timelineEvent, long appUs, long gpuUs, long compUs) {
            Intrinsics.checkNotNullParameter((Object)timelineEvent, (String)"timelineEvent");
            this.timelineEvent = timelineEvent;
            this.appUs = appUs;
            this.gpuUs = gpuUs;
            this.compUs = compUs;
        }

        @NotNull
        public final AndroidFrameTimelineEvent getTimelineEvent() {
            return this.timelineEvent;
        }

        public final long getAppUs() {
            return this.appUs;
        }

        public final long getGpuUs() {
            return this.gpuUs;
        }

        public final long getCompUs() {
            return this.compUs;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/profilers/cpu/analysis/AndroidFrameTimelineAnalysisModel$Tab;", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisTabModel;", "Lcom/android/tools/profilers/cpu/CpuCapture;", "capture", "keep", "Lkotlin/Function1;", "Lcom/android/tools/profilers/cpu/analysis/AndroidFrameTimelineAnalysisModel$Row;", "", "type", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisTabModel$Type;", "<init>", "(Lcom/android/tools/profilers/cpu/CpuCapture;Lkotlin/jvm/functions/Function1;Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisTabModel$Type;)V", "table", "Lcom/android/tools/profilers/cpu/analysis/PaginatedTableModel;", "getTable", "()Lcom/android/tools/profilers/cpu/analysis/PaginatedTableModel;", "table$delegate", "Lkotlin/Lazy;", "intellij.android.profilers"})
    @SourceDebugExtension(value={"SMAP\nAndroidFrameTimelineAnalysisModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidFrameTimelineAnalysisModel.kt\ncom/android/tools/profilers/cpu/analysis/AndroidFrameTimelineAnalysisModel$Tab\n+ 2 TableModelUtils.kt\ncom/android/tools/profilers/cpu/analysis/TableModelUtilsKt\n*L\n1#1,92:1\n25#2,6:93\n48#2:99\n*S KotlinDebug\n*F\n+ 1 AndroidFrameTimelineAnalysisModel.kt\ncom/android/tools/profilers/cpu/analysis/AndroidFrameTimelineAnalysisModel$Tab\n*L\n46#1:93,6\n46#1:99\n*E\n"})
    public static final class Tab
    extends CpuAnalysisTabModel<CpuCapture> {
        @NotNull
        private final Lazy table$delegate;

        public Tab(@NotNull CpuCapture capture, @NotNull Function1<? super Row, Boolean> keep, @NotNull CpuAnalysisTabModel.Type type) {
            Intrinsics.checkNotNullParameter((Object)capture, (String)"capture");
            Intrinsics.checkNotNullParameter(keep, (String)"keep");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            super(type);
            this.table$delegate = LazyKt.lazy(() -> Tab.table_delegate$lambda$4(this, keep));
            this.getDataSeries().add(capture);
        }

        @NotNull
        public final PaginatedTableModel<Row> getTable() {
            Lazy lazy = this.table$delegate;
            return (PaginatedTableModel)((Object)lazy.getValue());
        }

        private static final Row table_delegate$lambda$4$lambda$1$lambda$0(Function2 $lifeCycleDurationIndex, AndroidFrameTimelineEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return INSTANCE.toRow(it, (Function2<? super Long, ? super Phase, Long>)$lifeCycleDurationIndex);
        }

        private static final Sequence table_delegate$lambda$4$lambda$1(CpuCapture it) {
            CpuSystemTraceData cpuSystemTraceData = it.getSystemTraceData();
            Intrinsics.checkNotNull((Object)cpuSystemTraceData);
            CpuSystemTraceData data = cpuSystemTraceData;
            Function2 lifeCycleDurationIndex = INSTANCE.lifeCycleDurationIndex(data.getAndroidFrameLayers());
            return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)data.getAndroidFrameTimelineEvents()), arg_0 -> Tab.table_delegate$lambda$4$lambda$1$lambda$0(lifeCycleDurationIndex, arg_0));
        }

        private static final PaginatedTableModel table_delegate$lambda$4(Tab this$0, Function1 $keep) {
            List list = this$0.getDataSeries();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSeries(...)");
            List $this$asTableModel_u24default$iv = SequencesKt.toMutableList((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)list), Tab::table_delegate$lambda$4$lambda$1), (Function1)$keep));
            String name$iv = "table";
            int pageSize$iv = 25;
            boolean $i$f$asTableModel = false;
            return new PaginatedTableModel<Row>(pageSize$iv, $this$asTableModel_u24default$iv, name$iv){
                final /* synthetic */ List $this_asTableModel;
                final /* synthetic */ String $name;
                {
                    this.$this_asTableModel = $receiver;
                    this.$name = $name;
                    super($pageSize);
                }

                public List<Row> getRows() {
                    return this.$this_asTableModel;
                }

                public int getDataSize() {
                    return this.getRows().size();
                }

                protected Comparable<?> getDataValueAt(int dataIndex, int columnIndex) {
                    Column p0 = Column.values()[columnIndex];
                    boolean bl = false;
                    boolean $i$f$table_delegate$lambda$4$stub_for_inlining = false;
                    return (Comparable)p0.getGetValue().invoke((Object)this.getRows().get(dataIndex));
                }

                public int getColumnCount() {
                    return Column.values().length;
                }

                public Class<?> getColumnClass(int columnIndex) {
                    Column p0 = Column.values()[columnIndex];
                    boolean bl = false;
                    boolean $i$f$table_delegate$lambda$4$stub_for_inlining$2 = false;
                    return p0.getType();
                }

                public String getColumnName(int column) {
                    Column p0 = Column.values()[column];
                    boolean bl = false;
                    boolean $i$f$table_delegate$lambda$4$stub_for_inlining$3 = false;
                    return p0.getTitle();
                }

                public String toString() {
                    return this.$name;
                }

                /*
                 * WARNING - void declaration
                 */
                public void sortData(List<? extends RowSorter.SortKey> sortKeys) {
                    Intrinsics.checkNotNullParameter(sortKeys, (String)"sortKeys");
                    if (!((Collection)sortKeys).isEmpty()) {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = sortKeys;
                        List<Row> list = this.getRows();
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Object destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void key;
                            RowSorter.SortKey sortKey = (RowSorter.SortKey)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            Column p0 = Column.values()[key.getColumn()];
                            boolean bl2 = false;
                            boolean $i$f$table_delegate$lambda$4$stub_for_inlining = false;
                            Function1<Row, Comparable<?>> function1 = p0.getGetValue();
                            Comparator<T> cmp = new Comparator(function1){
                                final /* synthetic */ Function1 $selector;
                                {
                                    this.$selector = $selector;
                                }

                                public final int compare(T a, T b) {
                                    Function1 function1 = this.$selector;
                                    return ComparisonsKt.compareValues((Comparable)((Comparable)function1.invoke(a)), (Comparable)((Comparable)function1.invoke(b)));
                                }
                            };
                            collection.add(key.getSortOrder() == SortOrder.ASCENDING ? cmp : cmp.reversed());
                        }
                        Iterable $this$reduce$iv = (List)destination$iv$iv;
                        boolean $i$f$reduce = false;
                        Iterator<T> iterator$iv = $this$reduce$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            throw new UnsupportedOperationException("Empty collection can't be reduced.");
                        }
                        Object accumulator$iv = iterator$iv.next();
                        while (iterator$iv.hasNext()) {
                            void p1;
                            destination$iv$iv = (Comparator)iterator$iv.next();
                            Comparator p0 = (Comparator)accumulator$iv;
                            boolean $i$f$sortData$stub_for_inlining = false;
                            boolean bl = false;
                            accumulator$iv = ComparisonsKt.then((Comparator)p0, (Comparator)p1);
                        }
                        CollectionsKt.sortWith(list, (Comparator)((Comparator)((Object)iterable)));
                    }
                }
            };
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Phase.values().length];
            try {
                nArray[Phase.App.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Phase.Gpu.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Phase.Composition.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

