/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisEventsTabModel;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisStats;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u001a\b\u0002\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\r0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00000!H\u0016J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c2\u0003J\u0015\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c2\u0003J\u001b\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\r0\u000bH\u00c2\u0003JO\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u001a\b\u0002\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\r0\u000bH\u00c6\u0001J\u0013\u0010'\u001a\u00020\u001e2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020\u001cH\u00d6\u0001J\t\u0010+\u001a\u00020\fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisModel;", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalyzable;", "node", "Lcom/android/tools/profilers/cpu/CaptureNode;", "capture", "Lcom/android/tools/profilers/cpu/CpuCapture;", "runModelUpdate", "Lkotlin/Function1;", "Ljava/lang/Runnable;", "", "nameToNodes", "", "", "", "<init>", "(Lcom/android/tools/profilers/cpu/CaptureNode;Lcom/android/tools/profilers/cpu/CpuCapture;Lkotlin/jvm/functions/Function1;Ljava/util/Map;)V", "getNode", "()Lcom/android/tools/profilers/cpu/CaptureNode;", "nodeRange", "Lcom/android/tools/adtui/model/Range;", "getNodeRange", "()Lcom/android/tools/adtui/model/Range;", "allOccurrenceStats", "Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisStats;", "getAllOccurrenceStats", "()Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisStats;", "getLongestRunningOccurrences", "k", "", "matchesFullName", "", "otherNode", "getAnalysisModel", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisModel;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "toString", "intellij.android.profilers"})
public final class CaptureNodeAnalysisModel
implements CpuAnalyzable<CaptureNodeAnalysisModel> {
    @NotNull
    private final CaptureNode node;
    @NotNull
    private final CpuCapture capture;
    @NotNull
    private final Function1<Runnable, Unit> runModelUpdate;
    @NotNull
    private final Map<String, List<CaptureNode>> nameToNodes;

    public CaptureNodeAnalysisModel(@NotNull CaptureNode node, @NotNull CpuCapture capture, @NotNull Function1<? super Runnable, Unit> runModelUpdate, @NotNull Map<String, ? extends List<? extends CaptureNode>> nameToNodes) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)capture, (String)"capture");
        Intrinsics.checkNotNullParameter(runModelUpdate, (String)"runModelUpdate");
        Intrinsics.checkNotNullParameter(nameToNodes, (String)"nameToNodes");
        this.node = node;
        this.capture = capture;
        this.runModelUpdate = runModelUpdate;
        this.nameToNodes = nameToNodes;
    }

    public /* synthetic */ CaptureNodeAnalysisModel(CaptureNode captureNode, CpuCapture cpuCapture, Function1 function1, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        this(captureNode, cpuCapture, (Function1<? super Runnable, Unit>)function1, map);
    }

    @NotNull
    public final CaptureNode getNode() {
        return this.node;
    }

    @NotNull
    public final Range getNodeRange() {
        return new Range((double)this.node.getStart(), (double)this.node.getEnd());
    }

    @NotNull
    public final CaptureNodeAnalysisStats getAllOccurrenceStats() {
        List<CaptureNode> list;
        String string = this.node.getData().getFullName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullName(...)");
        String nodeName = string;
        if (this.nameToNodes.containsKey(nodeName)) {
            List<CaptureNode> list2 = this.nameToNodes.get(nodeName);
            Intrinsics.checkNotNull(list2);
            list = list2;
        } else {
            list = ((Stream)this.node.findRootNode().getDescendantsStream().parallel()).filter(arg_0 -> CaptureNodeAnalysisModel._get_allOccurrenceStats_$lambda$0((Function1)new Function1<CaptureNode, Boolean>((Object)this){

                public final Boolean invoke(CaptureNode p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return CaptureNodeAnalysisModel.access$matchesFullName((CaptureNodeAnalysisModel)this.receiver, p0);
                }
            }, arg_0)).collect(Collectors.toList());
        }
        List<CaptureNode> allOccurrences2 = list;
        Intrinsics.checkNotNull(allOccurrences2);
        return CaptureNodeAnalysisStats.Companion.fromNodes(allOccurrences2);
    }

    @NotNull
    public final List<CaptureNode> getLongestRunningOccurrences(int k) {
        CaptureNode captureNode = this.node.findRootNode();
        String string = this.node.getData().getFullName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullName(...)");
        return captureNode.getTopKNodes(k, string, new Comparator(){

            public final int compare(T a, T b) {
                CaptureNode p0 = (CaptureNode)a;
                boolean $i$f$getLongestRunningOccurrences$stub_for_inlining = false;
                boolean bl = false;
                Comparable comparable = Long.valueOf(p0.getDuration());
                p0 = (CaptureNode)b;
                Comparable comparable2 = comparable;
                $i$f$getLongestRunningOccurrences$stub_for_inlining = false;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getDuration()));
            }
        }, this.nameToNodes);
    }

    private final boolean matchesFullName(CaptureNode otherNode) {
        return Intrinsics.areEqual((Object)this.node.getData().getFullName(), (Object)otherNode.getData().getFullName());
    }

    @Override
    @NotNull
    public CpuAnalysisModel<CaptureNodeAnalysisModel> getAnalysisModel() {
        CpuAnalysisModel<CaptureNodeAnalysisModel> cpuAnalysisModel;
        Range nodeRange = this.getNodeRange();
        Set nodes = SetsKt.setOf((Object)this.node);
        CpuAnalysisModel<CaptureNodeAnalysisModel> model = cpuAnalysisModel = new CpuAnalysisModel<CaptureNodeAnalysisModel>(this.node.getData().getNameWithSuffix(), "%d events");
        boolean bl = false;
        Range range = this.capture.getRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getRange(...)");
        ProfilingConfiguration.TraceType traceType = this.capture.getType();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)traceType), (String)"getType(...)");
        CaptureNodeAnalysisModel.getAnalysisModel$lambda$4$add(this, model, new CaptureNodeAnalysisSummaryTabModel(range, traceType));
        CaptureNodeAnalysisModel.getAnalysisModel$lambda$4$add(this, model, new CpuAnalysisChartModel(CpuAnalysisTabModel.Type.FLAME_CHART, nodeRange, this.capture, arg_0 -> CaptureNodeAnalysisModel.getAnalysisModel$lambda$4$lambda$1(nodes, arg_0), this.runModelUpdate));
        CaptureNodeAnalysisModel.getAnalysisModel$lambda$4$add(this, model, new CpuAnalysisChartModel(CpuAnalysisTabModel.Type.TOP_DOWN, nodeRange, this.capture, arg_0 -> CaptureNodeAnalysisModel.getAnalysisModel$lambda$4$lambda$2(nodes, arg_0), this.runModelUpdate));
        CaptureNodeAnalysisModel.getAnalysisModel$lambda$4$add(this, model, new CpuAnalysisChartModel(CpuAnalysisTabModel.Type.BOTTOM_UP, nodeRange, this.capture, arg_0 -> CaptureNodeAnalysisModel.getAnalysisModel$lambda$4$lambda$3(nodes, arg_0), this.runModelUpdate));
        Range range2 = this.capture.getRange();
        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"getRange(...)");
        CaptureNodeAnalysisModel.getAnalysisModel$lambda$4$add(this, model, new CaptureNodeAnalysisEventsTabModel(range2));
        return cpuAnalysisModel;
    }

    @NotNull
    public final CaptureNode component1() {
        return this.node;
    }

    private final CpuCapture component2() {
        return this.capture;
    }

    private final Function1<Runnable, Unit> component3() {
        return this.runModelUpdate;
    }

    private final Map<String, List<CaptureNode>> component4() {
        return this.nameToNodes;
    }

    @NotNull
    public final CaptureNodeAnalysisModel copy(@NotNull CaptureNode node, @NotNull CpuCapture capture, @NotNull Function1<? super Runnable, Unit> runModelUpdate, @NotNull Map<String, ? extends List<? extends CaptureNode>> nameToNodes) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)capture, (String)"capture");
        Intrinsics.checkNotNullParameter(runModelUpdate, (String)"runModelUpdate");
        Intrinsics.checkNotNullParameter(nameToNodes, (String)"nameToNodes");
        return new CaptureNodeAnalysisModel(node, capture, runModelUpdate, nameToNodes);
    }

    public static /* synthetic */ CaptureNodeAnalysisModel copy$default(CaptureNodeAnalysisModel captureNodeAnalysisModel, CaptureNode captureNode, CpuCapture cpuCapture, Function1 function1, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            captureNode = captureNodeAnalysisModel.node;
        }
        if ((n & 2) != 0) {
            cpuCapture = captureNodeAnalysisModel.capture;
        }
        if ((n & 4) != 0) {
            function1 = captureNodeAnalysisModel.runModelUpdate;
        }
        if ((n & 8) != 0) {
            map = captureNodeAnalysisModel.nameToNodes;
        }
        return captureNodeAnalysisModel.copy(captureNode, cpuCapture, function1, map);
    }

    @NotNull
    public String toString() {
        return "CaptureNodeAnalysisModel(node=" + this.node + ", capture=" + this.capture + ", runModelUpdate=" + this.runModelUpdate + ", nameToNodes=" + this.nameToNodes + ")";
    }

    public int hashCode() {
        int result = this.node.hashCode();
        result = result * 31 + this.capture.hashCode();
        result = result * 31 + this.runModelUpdate.hashCode();
        result = result * 31 + ((Object)this.nameToNodes).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CaptureNodeAnalysisModel)) {
            return false;
        }
        CaptureNodeAnalysisModel captureNodeAnalysisModel = (CaptureNodeAnalysisModel)other;
        if (!Intrinsics.areEqual((Object)this.node, (Object)captureNodeAnalysisModel.node)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.capture, (Object)captureNodeAnalysisModel.capture)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.runModelUpdate, captureNodeAnalysisModel.runModelUpdate)) {
            return false;
        }
        return Intrinsics.areEqual(this.nameToNodes, captureNodeAnalysisModel.nameToNodes);
    }

    private static final boolean _get_allOccurrenceStats_$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void getAnalysisModel$lambda$4$add(CaptureNodeAnalysisModel this$0, CpuAnalysisModel<CaptureNodeAnalysisModel> $model, CpuAnalysisTabModel<CaptureNodeAnalysisModel> tab) {
        tab.getDataSeries().add(this$0);
        $model.addTabModel(tab);
    }

    private static final Collection getAnalysisModel$lambda$4$lambda$1(Set $nodes, CaptureNodeAnalysisModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $nodes;
    }

    private static final Collection getAnalysisModel$lambda$4$lambda$2(Set $nodes, CaptureNodeAnalysisModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $nodes;
    }

    private static final Collection getAnalysisModel$lambda$4$lambda$3(Set $nodes, CaptureNodeAnalysisModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $nodes;
    }

    public static final /* synthetic */ boolean access$matchesFullName(CaptureNodeAnalysisModel $this, CaptureNode otherNode) {
        return $this.matchesFullName(otherNode);
    }
}

