/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.analysis.CpuThreadStateTableKt;
import com.android.tools.profilers.cpu.analysis.CustomBorderTableCellRenderer;
import com.android.tools.profilers.cpu.analysis.DurationRenderer;
import com.android.tools.profilers.cpu.analysis.IntegerAsStringTableCellRender;
import com.android.tools.profilers.cpu.analysis.PercentRenderer;
import com.android.tools.profilers.cpu.analysis.ThreadStateRow;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u00020\u00198\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable;", "", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "threadStateSeriesList", "", "Lcom/android/tools/adtui/model/DataSeries;", "Lcom/android/tools/profilers/cpu/ThreadState;", "range", "Lcom/android/tools/adtui/model/Range;", "title", "", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;Ljava/util/List;Lcom/android/tools/adtui/model/Range;Ljava/lang/String;)V", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "getThreadStateSeriesList", "()Ljava/util/List;", "getRange", "()Lcom/android/tools/adtui/model/Range;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "table", "Ljavax/swing/JTable;", "getTable$annotations", "()V", "getTable", "()Ljavax/swing/JTable;", "ThreadStateTableModel", "Column", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
public final class CpuThreadStateTable {
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final List<DataSeries<ThreadState>> threadStateSeriesList;
    @NotNull
    private final Range range;
    @NotNull
    private final JComponent component;
    @NotNull
    private final JTable table;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public CpuThreadStateTable(@NotNull StudioProfilers profilers, @NotNull List<? extends DataSeries<ThreadState>> threadStateSeriesList, @NotNull Range range, @NotNull String title) {
        void $this$_init__u24lambda_u242;
        HideablePanel hideablePanel;
        JPanel $this$_init__u24lambda_u240;
        JBTable jBTable;
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter(threadStateSeriesList, (String)"threadStateSeriesList");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.profilers = profilers;
        this.threadStateSeriesList = threadStateSeriesList;
        this.range = range;
        JBTable jBTable2 = jBTable = new JBTable((TableModel)new ThreadStateTableModel());
        CpuThreadStateTable cpuThreadStateTable = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setAutoCreateRowSorter(true);
        $this$_init__u24lambda_u240.setShowVerticalLines(true);
        $this$_init__u24lambda_u240.setShowHorizontalLines(false);
        $this$_init__u24lambda_u240.getColumnModel().getColumn(Column.THREAD_STATE.ordinal()).setCellRenderer(new CustomBorderTableCellRenderer(null, 1, null));
        $this$_init__u24lambda_u240.getColumnModel().getColumn(Column.TIME.ordinal()).setCellRenderer(new DurationRenderer(null, 1, null));
        $this$_init__u24lambda_u240.getColumnModel().getColumn(Column.PERCENT.ordinal()).setCellRenderer(new PercentRenderer(null, 1, null));
        $this$_init__u24lambda_u240.getColumnModel().getColumn(Column.OCCURRENCES.ordinal()).setCellRenderer(new IntegerAsStringTableCellRender(null, 1, null));
        cpuThreadStateTable.table = (JTable)jBTable;
        JPanel $this$_init__u24lambda_u241 = $this$_init__u24lambda_u240 = new JPanel((LayoutManager)new TabularLayout("*", "Fit,Fit"));
        boolean $i$a$-apply-CpuThreadStateTable$tableContainer$22 = false;
        $this$_init__u24lambda_u241.setBorder(JBUI.Borders.customLine((Color)((Color)StudioColorsKt.getBorder()), (int)2));
        $this$_init__u24lambda_u241.setOpaque(false);
        $this$_init__u24lambda_u241.add((Component)((JBTable)this.table).getTableHeader(), new TabularLayout.Constraint(0, 0, 0, 4, null));
        $this$_init__u24lambda_u241.add((Component)this.table, new TabularLayout.Constraint(1, 0, 0, 4, null));
        JPanel tableContainer = $this$_init__u24lambda_u240;
        Border border = JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)((Color)StudioColorsKt.getBorder()), (int)1), (Border)((Border)JBUI.Borders.empty((int)8, (int)0, (int)0, (int)0)), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"merge(...)");
        Border contentBorder = border;
        HideablePanel $i$a$-apply-CpuThreadStateTable$tableContainer$22 = hideablePanel = new HideablePanel.Builder(title, (JComponent)tableContainer).setPanelBorder((Border)JBUI.Borders.empty()).setContentBorder(contentBorder).build();
        cpuThreadStateTable = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u242.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        cpuThreadStateTable.component = (JComponent)hideablePanel;
    }

    public /* synthetic */ CpuThreadStateTable(StudioProfilers studioProfilers, List list, Range range, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = "States";
        }
        this(studioProfilers, list, range, string);
    }

    @NotNull
    public final StudioProfilers getProfilers() {
        return this.profilers;
    }

    @NotNull
    public final List<DataSeries<ThreadState>> getThreadStateSeriesList() {
        return this.threadStateSeriesList;
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final JTable getTable() {
        return this.table;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTable$annotations() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "", "displayName", "", "type", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/Class;)V", "getDisplayName", "()Ljava/lang/String;", "getType", "()Ljava/lang/Class;", "THREAD_STATE", "TIME", "PERCENT", "OCCURRENCES", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "intellij.android.profilers.ui"})
    private static final abstract class Column
    extends Enum<Column> {
        @NotNull
        private final String displayName;
        @NotNull
        private final Class<?> type;
        public static final /* enum */ Column THREAD_STATE = new THREAD_STATE("THREAD_STATE", 0);
        public static final /* enum */ Column TIME = new TIME("TIME", 1);
        public static final /* enum */ Column PERCENT = new PERCENT("PERCENT", 2);
        public static final /* enum */ Column OCCURRENCES = new OCCURRENCES("OCCURRENCES", 3);
        private static final /* synthetic */ Column[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Column(String displayName, Class<?> type) {
            this.displayName = displayName;
            this.type = type;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final Class<?> getType() {
            return this.type;
        }

        @NotNull
        public abstract Object getValueFrom(@NotNull ThreadStateRow var1);

        public static Column[] values() {
            return (Column[])$VALUES.clone();
        }

        public static Column valueOf(String value) {
            return Enum.valueOf(Column.class, value);
        }

        @NotNull
        public static EnumEntries<Column> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Column(String $enum$name, int $enum$ordinal, String displayName, Class type, DefaultConstructorMarker $constructor_marker) {
            this(displayName, type);
        }

        static {
            $VALUES = columnArray = new Column[]{Column.THREAD_STATE, Column.TIME, Column.PERCENT, Column.OCCURRENCES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/android/tools/profilers/cpu/analysis/CpuThreadStateTable.Column.OCCURRENCES", "Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "intellij.android.profilers.ui"})
        static final class OCCURRENCES
        extends Column {
            /*
             * WARNING - void declaration
             */
            OCCURRENCES() {
                void var1_1;
            }

            @Override
            @NotNull
            public Object getValueFrom(@NotNull ThreadStateRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getOccurrences();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/android/tools/profilers/cpu/analysis/CpuThreadStateTable.Column.PERCENT", "Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "intellij.android.profilers.ui"})
        static final class PERCENT
        extends Column {
            /*
             * WARNING - void declaration
             */
            PERCENT() {
                void var1_1;
            }

            @Override
            @NotNull
            public Object getValueFrom(@NotNull ThreadStateRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getPercentage();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/android/tools/profilers/cpu/analysis/CpuThreadStateTable.Column.THREAD_STATE", "Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "intellij.android.profilers.ui"})
        static final class THREAD_STATE
        extends Column {
            /*
             * WARNING - void declaration
             */
            THREAD_STATE() {
                void var1_1;
            }

            @Override
            @NotNull
            public Object getValueFrom(@NotNull ThreadStateRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getThreadState().getDisplayName();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/android/tools/profilers/cpu/analysis/CpuThreadStateTable.Column.TIME", "Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "intellij.android.profilers.ui"})
        static final class TIME
        extends Column {
            /*
             * WARNING - void declaration
             */
            TIME() {
                void var1_1;
            }

            @Override
            @NotNull
            public Object getValueFrom(@NotNull ThreadStateRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getDuration();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$ThreadStateTableModel;", "Ljavax/swing/table/AbstractTableModel;", "<init>", "(Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable;)V", "observer", "Lcom/android/tools/adtui/model/AspectObserver;", "dataRows", "", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "getRowCount", "", "getColumnCount", "getValueAt", "", "rowIndex", "columnIndex", "getColumnClass", "Ljava/lang/Class;", "getColumnName", "", "column", "computeDistribution", "", "intellij.android.profilers.ui"})
    @SourceDebugExtension(value={"SMAP\nCpuThreadStateTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuThreadStateTable.kt\ncom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$ThreadStateTableModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,202:1\n1863#2:203\n1864#2:213\n1062#2:214\n1317#3:204\n1318#3:212\n381#4,7:205\n*S KotlinDebug\n*F\n+ 1 CpuThreadStateTable.kt\ncom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$ThreadStateTableModel\n*L\n124#1:203\n124#1:213\n151#1:214\n132#1:204\n132#1:212\n135#1:205,7\n*E\n"})
    private final class ThreadStateTableModel
    extends AbstractTableModel {
        @NotNull
        private final AspectObserver observer = new AspectObserver();
        @NotNull
        private List<ThreadStateRow> dataRows = CollectionsKt.emptyList();

        public ThreadStateTableModel() {
            CpuThreadStateTable.this.getRange().addDependency(this.observer).onChange((Enum)Range.Aspect.RANGE, () -> ThreadStateTableModel._init_$lambda$6(this));
            this.computeDistribution();
        }

        @Override
        public int getRowCount() {
            return this.dataRows.size();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length;
        }

        @Override
        @NotNull
        public Object getValueAt(int rowIndex, int columnIndex) {
            return Column.values()[columnIndex].getValueFrom(this.dataRows.get(rowIndex));
        }

        @Override
        @NotNull
        public Class<?> getColumnClass(int columnIndex) {
            return Column.values()[columnIndex].getType();
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            return Column.values()[column].getDisplayName();
        }

        /*
         * WARNING - void declaration
         */
        private final void computeDistribution() {
            void $this$forEach$iv;
            EnumMap threadStateToRow = new EnumMap(ThreadState.class);
            double totalDuration = CpuThreadStateTable.this.getRange().getLength() * (double)CpuThreadStateTable.this.getThreadStateSeriesList().size();
            Iterable iterable = CpuThreadStateTable.this.getThreadStateSeriesList();
            CpuThreadStateTable cpuThreadStateTable = CpuThreadStateTable.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                DataSeries threadStateSeries = (DataSeries)element$iv;
                boolean bl = false;
                long nextTimestamp = 0L;
                nextTimestamp = (long)cpuThreadStateTable.getRange().getMax();
                Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.asReversed((List)threadStateSeries.getDataForRange(cpuThreadStateTable.getRange()))), arg_0 -> ThreadStateTableModel.computeDistribution$lambda$4$lambda$0(cpuThreadStateTable, arg_0));
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Object object;
                    void $this$getOrPut$iv;
                    SeriesData threadStateDataPoint = (SeriesData)element$iv2;
                    boolean bl2 = false;
                    Map map = threadStateToRow;
                    Object key$iv = threadStateDataPoint.value;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        ThreadStateRow answer$iv = new ThreadStateRow((ThreadState)((Object)threadStateDataPoint.value), totalDuration, 0L, 0L, 12, null);
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    map = object;
                    ThreadStateRow $this$computeDistribution_u24lambda_u244_u24lambda_u243_u24lambda_u242 = (ThreadStateRow)((Object)map);
                    boolean bl4 = false;
                    long duration = nextTimestamp - Math.max((long)cpuThreadStateTable.getRange().getMin(), threadStateDataPoint.x);
                    if (duration >= 0L) {
                        $this$computeDistribution_u24lambda_u244_u24lambda_u243_u24lambda_u242.setDuration($this$computeDistribution_u24lambda_u244_u24lambda_u243_u24lambda_u242.getDuration() + duration);
                        $this$computeDistribution_u24lambda_u244_u24lambda_u243_u24lambda_u242.setOccurrences($this$computeDistribution_u24lambda_u244_u24lambda_u243_u24lambda_u242.getOccurrences() + 1L);
                        nextTimestamp = threadStateDataPoint.x;
                        continue;
                    }
                    CpuThreadStateTableKt.access$getLogger().warn("Negative duration in thread state table: " + duration + ".");
                }
            }
            Collection collection = threadStateToRow.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$sortedByDescending$iv = CollectionsKt.toList((Iterable)collection);
            boolean $i$f$sortedByDescending = false;
            this.dataRows = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ThreadStateRow it = (ThreadStateRow)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getDuration());
                    it = (ThreadStateRow)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getDuration()));
                }
            });
            this.fireTableDataChanged();
        }

        private static final boolean computeDistribution$lambda$4$lambda$0(CpuThreadStateTable this$0, SeriesData it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.x < (long)this$0.getRange().getMax();
        }

        private static final void _init_$lambda$6(ThreadStateTableModel this$0) {
            this$0.computeDistribution();
        }
    }
}

