/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.StringFormattingUtils;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.FullTraceAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.PowerRailTable;
import com.android.tools.profilers.cpu.analysis.PowerRailTableUtils;
import com.android.tools.profilers.cpu.analysis.SummaryDetailsViewBase;
import com.android.tools.profilers.cpu.analysis.UsageInstructionsView;
import com.android.tools.profilers.cpu.systemtrace.CpuSystemTraceData;
import com.android.tools.profilers.cpu.systemtrace.PowerCounterData;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u0013\u0010\b\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u000e\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00118GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/profilers/cpu/analysis/FullTraceSummaryDetailsView;", "Lcom/android/tools/profilers/cpu/analysis/SummaryDetailsViewBase;", "Lcom/android/tools/profilers/cpu/analysis/FullTraceAnalysisSummaryTabModel;", "profilersView", "Lcom/android/tools/profilers/StudioProfilersView;", "tabModel", "<init>", "(Lcom/android/tools/profilers/StudioProfilersView;Lcom/android/tools/profilers/cpu/analysis/FullTraceAnalysisSummaryTabModel;)V", "timeRangeLabel", "Ljavax/swing/JLabel;", "getTimeRangeLabel", "()Ljavax/swing/JLabel;", "durationLabel", "getDurationLabel", "energyUsedLabel", "getEnergyUsedLabel", "powerRailTable", "Lcom/android/tools/profilers/cpu/analysis/PowerRailTable;", "getPowerRailTable", "()Lcom/android/tools/profilers/cpu/analysis/PowerRailTable;", "setPowerRailTable", "(Lcom/android/tools/profilers/cpu/analysis/PowerRailTable;)V", "updateRangeLabels", "", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFullTraceSummaryDetailsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullTraceSummaryDetailsView.kt\ncom/android/tools/profilers/cpu/analysis/FullTraceSummaryDetailsView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,85:1\n1#2:86\n216#3,2:87\n*S KotlinDebug\n*F\n+ 1 FullTraceSummaryDetailsView.kt\ncom/android/tools/profilers/cpu/analysis/FullTraceSummaryDetailsView\n*L\n78#1:87,2\n*E\n"})
public final class FullTraceSummaryDetailsView
extends SummaryDetailsViewBase<FullTraceAnalysisSummaryTabModel> {
    @NotNull
    private final JLabel timeRangeLabel;
    @NotNull
    private final JLabel durationLabel;
    @NotNull
    private final JLabel energyUsedLabel;
    @Nullable
    private PowerRailTable powerRailTable;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public FullTraceSummaryDetailsView(@NotNull StudioProfilersView profilersView, @NotNull FullTraceAnalysisSummaryTabModel tabModel) {
        void $this$_init__u24lambda_u241;
        HideablePanel hideablePanel;
        Intrinsics.checkNotNullParameter((Object)profilersView, (String)"profilersView");
        Intrinsics.checkNotNullParameter((Object)tabModel, (String)"tabModel");
        super(profilersView, (CpuAnalysisSummaryTabModel)tabModel);
        this.timeRangeLabel = new JLabel();
        this.durationLabel = new JLabel();
        this.energyUsedLabel = new JLabel();
        this.addRowToCommonSection("Time Range", this.timeRangeLabel);
        this.addRowToCommonSection("Duration", this.durationLabel);
        CpuCapture cpuCapture = (CpuCapture)tabModel.getDataSeries().get(0);
        Object object = cpuCapture.getSystemTraceData();
        if (object != null && (object = object.getPowerRailCounters()) != null) {
            Object powerRailCounters = object;
            boolean bl = false;
            if (!powerRailCounters.isEmpty()) {
                this.addRowToCommonSectionWithInfoIcon("Total Energy Used in Range", this.energyUsedLabel, "Power data is sampled in 250ms intervals.<br><br>The total energy number represented<br>contains an <b><i>error margin of up to +/- 0.5<br>seconds (500ms)</i></b> of power data due to the<br>sampling interval.");
                StudioProfilers studioProfilers = profilersView.getStudioProfilers();
                Range range = tabModel.getSelectionRange();
                Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getSelectionRange(...)");
                Range range2 = tabModel.getCaptureRange();
                Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"getCaptureRange(...)");
                PowerRailTable powerRailTable = this.powerRailTable = new PowerRailTable(studioProfilers, (Map)powerRailCounters, range, range2, null, 16, null);
                Intrinsics.checkNotNull((Object)powerRailTable);
                this.addSection(powerRailTable.getComponent());
            }
        }
        HideablePanel hideablePanel2 = hideablePanel = new HideablePanel.Builder("<b>Usage Instructions</b>", (JComponent)new UsageInstructionsView()).setInitiallyExpanded(false).setPanelBorder((Border)JBUI.Borders.empty()).build();
        FullTraceSummaryDetailsView fullTraceSummaryDetailsView = this;
        boolean bl = false;
        $this$_init__u24lambda_u241.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        HideablePanel hideablePanel3 = hideablePanel;
        Intrinsics.checkNotNullExpressionValue((Object)hideablePanel3, (String)"apply(...)");
        fullTraceSummaryDetailsView.addSection((JComponent)hideablePanel3);
        tabModel.getSelectionRange().addDependency(this.getObserver()).onChange((Enum)Range.Aspect.RANGE, () -> FullTraceSummaryDetailsView._init_$lambda$2(this));
        this.updateRangeLabels();
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getTimeRangeLabel() {
        return this.timeRangeLabel;
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getDurationLabel() {
        return this.durationLabel;
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getEnergyUsedLabel() {
        return this.energyUsedLabel;
    }

    @VisibleForTesting
    @Nullable
    public final PowerRailTable getPowerRailTable() {
        return this.powerRailTable;
    }

    public final void setPowerRailTable(@Nullable PowerRailTable powerRailTable) {
        this.powerRailTable = powerRailTable;
    }

    private final void updateRangeLabels() {
        Map<String, PowerCounterData> powerRailCounters;
        Range range = ((FullTraceAnalysisSummaryTabModel)this.getTabModel()).getSelectionRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getSelectionRange(...)");
        Range selectionRange = range;
        Range range2 = ((FullTraceAnalysisSummaryTabModel)this.getTabModel()).getCaptureRange();
        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"getCaptureRange(...)");
        Range captureRange = range2;
        this.timeRangeLabel.setText(SummaryDetailsViewBase.Companion.formatTimeRangeAsString$default(SummaryDetailsViewBase.Companion, selectionRange, (long)captureRange.getMin(), '\u0000', 4, null));
        this.durationLabel.setText(TimeFormatter.getSingleUnitDurationString((long)((long)selectionRange.getLength())));
        long totalEnergyUws = 0L;
        CpuCapture cpuCapture = (CpuCapture)((FullTraceAnalysisSummaryTabModel)this.getTabModel()).getDataSeries().get(0);
        CpuSystemTraceData cpuSystemTraceData = cpuCapture.getSystemTraceData();
        Map<String, PowerCounterData> map = powerRailCounters = cpuSystemTraceData != null ? cpuSystemTraceData.getPowerRailCounters() : null;
        if (map != null) {
            Map<String, PowerCounterData> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, PowerCounterData>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, PowerCounterData> element$iv;
                Map.Entry<String, PowerCounterData> it = element$iv = iterator.next();
                boolean bl = false;
                PowerRailTableUtils.PowerUsageRange powerUsageRange = PowerRailTableUtils.INSTANCE.computePowerUsageRange(it.getValue().getCumulativeData(), selectionRange);
                totalEnergyUws += PowerRailTableUtils.INSTANCE.computeCumulativeEnergyInRange(powerUsageRange);
            }
        }
        this.energyUsedLabel.setText(StringFormattingUtils.formatLongValueWithCommas(totalEnergyUws) + " \u00b5Ws");
    }

    private static final void _init_$lambda$2(FullTraceSummaryDetailsView this$0) {
        this$0.updateRangeLabels();
    }
}

