/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001!B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\u000e\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00110\u00102\u0006\u0010\u0016\u001a\u00020\rH\u0007J*\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00110\u00102\u0006\u0010\u0018\u001a\u00020\rH\u0007J2\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00110\u00102\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J$\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00110\u00102\u0006\u0010\u001e\u001a\u00020\u0007H\u0002R\u000e\u0010\u001f\u001a\u00020 X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/profilers/cpu/analysis/PowerRailTableUtils;", "", "<init>", "()V", "isPowerRangeInvalid", "", "lowerBoundTs", "", "upperBoundTs", "computeCumulativeEnergyInRange", "powerUsageRange", "Lcom/android/tools/profilers/cpu/analysis/PowerRailTableUtils$PowerUsageRange;", "computeAveragePowerInRange", "", "computePowerUsageRange", "cumulativeData", "", "Lcom/android/tools/adtui/model/SeriesData;", "selectionRange", "Lcom/android/tools/adtui/model/Range;", "getLowerBoundDataInRange", "data", "minTs", "getUpperBoundDataInRange", "maxTs", "getBoundPowerSeriesData", "targetTs", "isLowerBound", "seriesDataBinarySearch", "", "target", "POWER_RAIL_TOTAL_VALUE_IN_RANGE_TOOLTIP_MSG", "", "PowerUsageRange", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=1)
public final class PowerRailTableUtils {
    @NotNull
    public static final PowerRailTableUtils INSTANCE = new PowerRailTableUtils();
    @NotNull
    public static final String POWER_RAIL_TOTAL_VALUE_IN_RANGE_TOOLTIP_MSG = "Power data is sampled in 250ms intervals.<br><br>The total energy number represented<br>contains an <b><i>error margin of up to +/- 0.5<br>seconds (500ms)</i></b> of power data due to the<br>sampling interval.";
    public static final int $stable;

    private PowerRailTableUtils() {
    }

    private final boolean isPowerRangeInvalid(long lowerBoundTs, long upperBoundTs) {
        return lowerBoundTs >= upperBoundTs;
    }

    public final long computeCumulativeEnergyInRange(@NotNull PowerUsageRange powerUsageRange) {
        Intrinsics.checkNotNullParameter((Object)powerUsageRange, (String)"powerUsageRange");
        SeriesData<Long> lowerBound = powerUsageRange.getLowerBound();
        SeriesData<Long> upperBound = powerUsageRange.getUpperBound();
        long lowerBoundTs = lowerBound.x;
        long upperBoundTs = upperBound.x;
        return this.isPowerRangeInvalid(lowerBoundTs, upperBoundTs) ? 0L : ((Number)upperBound.value).longValue() - ((Number)lowerBound.value).longValue();
    }

    public final double computeAveragePowerInRange(@NotNull PowerUsageRange powerUsageRange) {
        double d;
        Intrinsics.checkNotNullParameter((Object)powerUsageRange, (String)"powerUsageRange");
        SeriesData<Long> lowerBound = powerUsageRange.getLowerBound();
        SeriesData<Long> upperBound = powerUsageRange.getUpperBound();
        long lowerBoundTs = lowerBound.x;
        long upperBoundTs = upperBound.x;
        long durationMs = TimeUnit.MICROSECONDS.toMillis(upperBoundTs - lowerBoundTs);
        if (this.isPowerRangeInvalid(lowerBoundTs, upperBoundTs) || durationMs == 0L) {
            d = 0.0;
        } else {
            long cumulativeEnergy = this.computeCumulativeEnergyInRange(powerUsageRange);
            d = (double)cumulativeEnergy / (double)durationMs;
        }
        return d;
    }

    @NotNull
    public final PowerUsageRange computePowerUsageRange(@NotNull List<SeriesData<Long>> cumulativeData, @NotNull Range selectionRange) {
        Intrinsics.checkNotNullParameter(cumulativeData, (String)"cumulativeData");
        Intrinsics.checkNotNullParameter((Object)selectionRange, (String)"selectionRange");
        SeriesData<Long> lowerBound = this.getLowerBoundDataInRange(cumulativeData, selectionRange.getMin());
        SeriesData<Long> upperBound = this.getUpperBoundDataInRange(cumulativeData, selectionRange.getMax());
        return new PowerUsageRange(lowerBound, upperBound);
    }

    @VisibleForTesting
    @NotNull
    public final SeriesData<Long> getLowerBoundDataInRange(@NotNull List<SeriesData<Long>> data, double minTs) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return this.getBoundPowerSeriesData(data, minTs, true);
    }

    @VisibleForTesting
    @NotNull
    public final SeriesData<Long> getUpperBoundDataInRange(@NotNull List<SeriesData<Long>> data, double maxTs) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return this.getBoundPowerSeriesData(data, maxTs, false);
    }

    private final SeriesData<Long> getBoundPowerSeriesData(List<SeriesData<Long>> data, double targetTs, boolean isLowerBound) {
        boolean bl;
        boolean bl2 = bl = !((Collection)data).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int index = this.seriesDataBinarySearch(data, (long)targetTs);
        if (index >= 0) {
            return data.get(index);
        }
        int insertionPos = (index + 1) * -1;
        return isLowerBound ? (insertionPos < data.size() ? data.get(insertionPos) : data.get(data.size() - 1)) : (insertionPos == 0 ? data.get(insertionPos) : data.get(insertionPos - 1));
    }

    private final int seriesDataBinarySearch(List<SeriesData<Long>> data, long target) {
        return CollectionsKt.binarySearch$default(data, (Object)new SeriesData(target, (Object)0L), (arg_0, arg_1) -> PowerRailTableUtils.seriesDataBinarySearch$lambda$1(PowerRailTableUtils::seriesDataBinarySearch$lambda$0, arg_0, arg_1), (int)0, (int)0, (int)12, null);
    }

    private static final int seriesDataBinarySearch$lambda$0(SeriesData a, SeriesData b) {
        return Intrinsics.compare((long)a.x, (long)b.x);
    }

    private static final int seriesDataBinarySearch$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/profilers/cpu/analysis/PowerRailTableUtils$PowerUsageRange;", "", "lowerBound", "Lcom/android/tools/adtui/model/SeriesData;", "", "upperBound", "<init>", "(Lcom/android/tools/adtui/model/SeriesData;Lcom/android/tools/adtui/model/SeriesData;)V", "getLowerBound", "()Lcom/android/tools/adtui/model/SeriesData;", "getUpperBound", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.profilers.ui"})
    @StabilityInferred(parameters=0)
    public static final class PowerUsageRange {
        @NotNull
        private final SeriesData<Long> lowerBound;
        @NotNull
        private final SeriesData<Long> upperBound;
        public static final int $stable = 8;

        public PowerUsageRange(@NotNull SeriesData<Long> lowerBound, @NotNull SeriesData<Long> upperBound) {
            Intrinsics.checkNotNullParameter(lowerBound, (String)"lowerBound");
            Intrinsics.checkNotNullParameter(upperBound, (String)"upperBound");
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        @NotNull
        public final SeriesData<Long> getLowerBound() {
            return this.lowerBound;
        }

        @NotNull
        public final SeriesData<Long> getUpperBound() {
            return this.upperBound;
        }

        @NotNull
        public final SeriesData<Long> component1() {
            return this.lowerBound;
        }

        @NotNull
        public final SeriesData<Long> component2() {
            return this.upperBound;
        }

        @NotNull
        public final PowerUsageRange copy(@NotNull SeriesData<Long> lowerBound, @NotNull SeriesData<Long> upperBound) {
            Intrinsics.checkNotNullParameter(lowerBound, (String)"lowerBound");
            Intrinsics.checkNotNullParameter(upperBound, (String)"upperBound");
            return new PowerUsageRange(lowerBound, upperBound);
        }

        public static /* synthetic */ PowerUsageRange copy$default(PowerUsageRange powerUsageRange, SeriesData seriesData, SeriesData seriesData2, int n, Object object) {
            if ((n & 1) != 0) {
                seriesData = powerUsageRange.lowerBound;
            }
            if ((n & 2) != 0) {
                seriesData2 = powerUsageRange.upperBound;
            }
            return powerUsageRange.copy(seriesData, seriesData2);
        }

        @NotNull
        public String toString() {
            return "PowerUsageRange(lowerBound=" + this.lowerBound + ", upperBound=" + this.upperBound + ")";
        }

        public int hashCode() {
            int result = this.lowerBound.hashCode();
            result = result * 31 + this.upperBound.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PowerUsageRange)) {
                return false;
            }
            PowerUsageRange powerUsageRange = (PowerUsageRange)other;
            if (!Intrinsics.areEqual(this.lowerBound, powerUsageRange.lowerBound)) {
                return false;
            }
            return Intrinsics.areEqual(this.upperBound, powerUsageRange.upperBound);
        }
    }
}

