/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.config;

import com.android.tools.adtui.model.options.OptionsProperty;
import com.android.tools.adtui.model.options.OptionsProvider;
import com.android.tools.idea.protobuf.GeneratedMessageV3;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.ArtSampledConfiguration;
import com.android.tools.profilers.cpu.config.AtraceConfiguration;
import com.android.tools.profilers.cpu.config.PerfettoSystemTraceConfiguration;
import com.android.tools.profilers.cpu.config.SimpleperfConfiguration;
import com.android.tools.profilers.cpu.config.UnspecifiedConfiguration;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ProfilingConfiguration
implements OptionsProvider {
    public static final String DEFAULT_CONFIGURATION_NAME = "Unnamed";
    public static final int DEFAULT_BUFFER_SIZE_MB = 8;
    public static final int SYSTEM_TRACE_BUFFER_SIZE_MB = 4;
    public static final int DEFAULT_SAMPLING_INTERVAL_US = 1000;
    public static final String TRACE_CONFIG_GROUP = "Trace config";
    public static final int DEFAULT_MEMORY_SAMPLING_INTERVAL_BYTES = 2048;
    @NotNull
    private String myName;

    protected ProfilingConfiguration(@NotNull String name) {
        this.myName = name;
    }

    @NotNull
    public abstract TraceType getTraceType();

    @OptionsProperty(name="Configuration name: ", group="Trace config", order=99)
    @NotNull
    public String getName() {
        return this.myName;
    }

    @OptionsProperty
    public void setName(@NotNull String name) {
        this.myName = name;
    }

    public abstract int getRequiredDeviceLevel();

    public boolean isDeviceLevelSupported(int deviceLevel) {
        return deviceLevel >= this.getRequiredDeviceLevel();
    }

    @NotNull
    public static ProfilingConfiguration fromProto(@NotNull Trace.TraceConfiguration proto, boolean isTraceboxEnabled) {
        switch (proto.getUnionCase()) {
            case ART_OPTIONS: {
                if (proto.getArtOptions().getTraceMode() == Trace.TraceMode.SAMPLED) {
                    ArtSampledConfiguration artSampled = new ArtSampledConfiguration("");
                    artSampled.setProfilingSamplingIntervalUs(proto.getArtOptions().getSamplingIntervalUs());
                    artSampled.setProfilingBufferSizeInMb(proto.getArtOptions().getBufferSizeInMb());
                    return artSampled;
                }
                ArtInstrumentedConfiguration artInstrumented = new ArtInstrumentedConfiguration("");
                artInstrumented.setProfilingBufferSizeInMb(proto.getArtOptions().getBufferSizeInMb());
                return artInstrumented;
            }
            case PERFETTO_OPTIONS: {
                PerfettoSystemTraceConfiguration perfetto = new PerfettoSystemTraceConfiguration("", isTraceboxEnabled);
                return perfetto;
            }
            case ATRACE_OPTIONS: {
                AtraceConfiguration atrace = new AtraceConfiguration("");
                return atrace;
            }
            case SIMPLEPERF_OPTIONS: {
                SimpleperfConfiguration simpleperf = new SimpleperfConfiguration("");
                simpleperf.setProfilingSamplingIntervalUs(proto.getSimpleperfOptions().getSamplingIntervalUs());
                return simpleperf;
            }
        }
        return new UnspecifiedConfiguration(DEFAULT_CONFIGURATION_NAME);
    }

    protected abstract GeneratedMessageV3 getOptions();

    public abstract void addOptions(Trace.TraceConfiguration.Builder var1, Map<AdditionalOptions, ? extends Object> var2);

    public boolean equals(Object obj) {
        if (!(obj instanceof ProfilingConfiguration)) {
            return false;
        }
        ProfilingConfiguration incoming = (ProfilingConfiguration)obj;
        return incoming.getOptions().equals((Object)this.getOptions());
    }

    public int hashCode() {
        return this.getOptions().hashCode();
    }

    public boolean isEditable() {
        return true;
    }

    public static enum TraceType {
        ART("Art"),
        ATRACE("Atrace"),
        SIMPLEPERF("Simpleperf"),
        PERFETTO("Perfetto"),
        UNSPECIFIED("Unspecified");

        @NotNull
        private final String myDisplayName;

        @NotNull
        public static TraceType from(@NotNull Trace.TraceConfiguration config) {
            if (config.hasArtOptions()) {
                return ART;
            }
            if (config.hasAtraceOptions()) {
                return ATRACE;
            }
            if (config.hasSimpleperfOptions()) {
                return SIMPLEPERF;
            }
            if (config.hasPerfettoOptions()) {
                return PERFETTO;
            }
            return UNSPECIFIED;
        }

        private TraceType(String displayName) {
            this.myDisplayName = displayName;
        }

        @NotNull
        public String getDisplayName() {
            return this.myDisplayName;
        }
    }

    public static enum AdditionalOptions {
        SYMBOL_DIRS,
        APP_PKG_NAME;

    }
}

