/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.simpleperf;

import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import com.android.tools.profilers.cpu.nodemodel.SyscallModel;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0007J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0007J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\nH\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\nH\u0002J\u0018\u0010&\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\n2\u0006\u0010'\u001a\u00020\u001cH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0010\u0010*\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/profilers/cpu/simpleperf/NodeNameParser;", "", "<init>", "()V", "JAVA_SEPARATOR_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "COMMON_PATH_PREFIXES", "", "", "[Ljava/lang/String;", "COMMON_PATH_PREFIXES_DISPLAY", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "parseNodeName", "Lcom/android/tools/profilers/cpu/nodemodel/CaptureNodeModel;", "fullName", "isUserWritten", "", "fileName", "vAddress", "", "createCppFunctionModel", "Lcom/android/tools/profilers/cpu/nodemodel/CppFunctionModel;", "functionFullName", "separatorIndexOutsideOfTemplateInfo", "", "separator", "lastIndex", "isOperatorOverload", "functionName", "isCppIdentifierChar", "ch", "", "removeTemplateInfo", "fullSymbol", "findMatchingOpeningParenthesisIndex", "endIndex", "createJavaMethodModel", "Lcom/android/tools/profilers/cpu/nodemodel/JavaMethodModel;", "tagFromFileName", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nNodeNameParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeNameParser.kt\ncom/android/tools/profilers/cpu/simpleperf/NodeNameParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,282:1\n1#2:283\n1179#3,2:284\n*S KotlinDebug\n*F\n+ 1 NodeNameParser.kt\ncom/android/tools/profilers/cpu/simpleperf/NodeNameParser\n*L\n204#1:284,2\n*E\n"})
public final class NodeNameParser {
    @NotNull
    public static final NodeNameParser INSTANCE = new NodeNameParser();
    private static final Pattern JAVA_SEPARATOR_PATTERN = Pattern.compile("\\.");
    @NotNull
    private static final String[] COMMON_PATH_PREFIXES;
    @NotNull
    private static final String[] COMMON_PATH_PREFIXES_DISPLAY;
    @NotNull
    private static final Logger logger;

    private NodeNameParser() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CaptureNodeModel parseNodeName(@NotNull String fullName, boolean isUserWritten, @Nullable String fileName, long vAddress) {
        Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
        return StringsKt.contains$default((CharSequence)fullName, (CharSequence)"(", (boolean)false, (int)2, null) ? (CaptureNodeModel)NodeNameParser.createCppFunctionModel(fullName, isUserWritten, fileName, vAddress) : (StringsKt.contains$default((CharSequence)fullName, (CharSequence)".", (boolean)false, (int)2, null) ? (CaptureNodeModel)INSTANCE.createJavaMethodModel(fullName) : (fileName == null ? (CaptureNodeModel)new SyscallModel(null, fullName) : (CaptureNodeModel)new SyscallModel(INSTANCE.tagFromFileName(fileName), fullName)));
    }

    public static /* synthetic */ CaptureNodeModel parseNodeName$default(String string, boolean bl, String string2, long l, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            l = -1L;
        }
        return NodeNameParser.parseNodeName(string, bl, string2, l);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CppFunctionModel createCppFunctionModel(@NotNull String functionFullName, boolean isUserWritten, @Nullable String fileName, long vAddress) {
        String string;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)functionFullName, (String)"functionFullName");
        int paramsEndIndex = StringsKt.lastIndexOf$default((CharSequence)functionFullName, (char)')', (int)0, (boolean)false, (int)6, null);
        int paramsStartIndex = paramsEndIndex < 0 ? -1 : INSTANCE.findMatchingOpeningParenthesisIndex(functionFullName, paramsEndIndex);
        String functionName = null;
        String parameters = null;
        boolean bl = 0 <= paramsStartIndex ? paramsStartIndex < paramsEndIndex : false;
        if (bl) {
            String string2 = functionFullName.substring(paramsStartIndex + 1, paramsEndIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            parameters = string2;
            String string3 = functionFullName.substring(0, paramsStartIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            functionName = string3;
        } else {
            functionName = functionFullName;
            parameters = "";
        }
        int it = n2 = INSTANCE.separatorIndexOutsideOfTemplateInfo(functionName, " ", false);
        boolean bl2 = false;
        if (it >= 0) {
            String string4 = functionFullName.substring(0, it);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String returnType = string4;
            if (!Intrinsics.areEqual((Object)returnType, (Object)"operator") && !StringsKt.endsWith$default((String)returnType, (String)"::operator", (boolean)false, (int)2, null)) {
                String string5 = functionName.substring(it + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                functionName = string5;
            }
        }
        String name = null;
        String classOrNamespace = null;
        int it22 = n = INSTANCE.separatorIndexOutsideOfTemplateInfo(functionName, "::", true);
        boolean bl3 = false;
        if (it22 >= 0) {
            String string6 = functionName.substring(0, it22);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            classOrNamespace = string6;
            String string7 = functionName.substring(it22 + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            name = string7;
        } else {
            classOrNamespace = "";
            name = functionName;
        }
        CppFunctionModel.Builder builder = new CppFunctionModel.Builder(INSTANCE.isOperatorOverload(name) ? name : INSTANCE.removeTemplateInfo(name)).setClassOrNamespace(INSTANCE.removeTemplateInfo(classOrNamespace)).setIsUserCode(isUserWritten).setParameters(INSTANCE.removeTemplateInfo(parameters)).setFileName(fileName);
        String string8 = fileName;
        if (string8 != null) {
            String it22 = string8;
            CppFunctionModel.Builder builder2 = builder;
            boolean bl4 = false;
            string = INSTANCE.tagFromFileName(it22);
            builder = builder2;
        } else {
            string = null;
        }
        return builder.setTag(string).setVAddress(vAddress).build();
    }

    public static /* synthetic */ CppFunctionModel createCppFunctionModel$default(String string, boolean bl, String string2, long l, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            l = -1L;
        }
        return NodeNameParser.createCppFunctionModel(string, bl, string2, l);
    }

    private final int separatorIndexOutsideOfTemplateInfo(String functionFullName, String separator, boolean lastIndex) {
        int open = 0;
        List instances = new ArrayList();
        int index = 0;
        while (index < functionFullName.length()) {
            int it = StringsKt.indexOf$default((CharSequence)functionFullName, (char)'<', (int)index, (boolean)false, (int)4, null);
            boolean bl = false;
            int nextOpen = it == -1 ? functionFullName.length() : it;
            int it2 = StringsKt.indexOf$default((CharSequence)functionFullName, (char)'>', (int)index, (boolean)false, (int)4, null);
            boolean bl2 = false;
            int nextClose = it2 == -1 ? functionFullName.length() : it2;
            int it3 = StringsKt.indexOf$default((CharSequence)functionFullName, (String)separator, (int)index, (boolean)false, (int)4, null);
            boolean bl3 = false;
            int nextSeparator = it3 == -1 ? functionFullName.length() : it3;
            if (nextOpen < RangesKt.coerceAtMost((int)nextClose, (int)nextSeparator)) {
                index = nextOpen + 1;
                ++open;
                continue;
            }
            if (nextClose < RangesKt.coerceAtMost((int)nextOpen, (int)nextSeparator)) {
                index = nextClose + 1;
                --open;
                continue;
            }
            if (open == 0 && nextSeparator < functionFullName.length()) {
                instances.add(nextSeparator);
            }
            index = nextSeparator + 1;
        }
        if (instances.isEmpty()) {
            return -1;
        }
        return lastIndex ? ((Number)CollectionsKt.last((List)instances)).intValue() : ((Number)CollectionsKt.first((List)instances)).intValue();
    }

    private final boolean isOperatorOverload(String functionName) {
        String operator = "operator";
        return Intrinsics.areEqual((Object)functionName, (Object)operator) || StringsKt.startsWith$default((String)functionName, (String)operator, (boolean)false, (int)2, null) && !this.isCppIdentifierChar(functionName.charAt(operator.length()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCppIdentifierChar(char ch) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if ('a' <= ch) {
            if (ch < '{') {
                return true;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) return true;
        if ('A' <= ch) {
            if (ch < '[') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('0' <= ch) {
            if (ch < ':') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (ch != '_') return false;
        return true;
    }

    private final String removeTemplateInfo(String fullSymbol) {
        StringBuilder filteredName = new StringBuilder();
        int open = 0;
        CharSequence $this$forEach$iv = fullSymbol;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char ch = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            if (ch == '<') {
                ++open;
                continue;
            }
            if (ch == '>') {
                open += -1;
                continue;
            }
            if (open != 0) continue;
            filteredName.append(ch);
        }
        if (open != 0) {
            logger.warn("Native function signature " + fullSymbol + " without matching angle brackets.");
            return fullSymbol;
        }
        String string = filteredName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final int findMatchingOpeningParenthesisIndex(String functionName, int endIndex) {
        boolean bl;
        boolean bl2 = bl = functionName.charAt(endIndex) == ')';
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int count = 0;
        for (int i = endIndex; -1 < i; --i) {
            char ch = functionName.charAt(i);
            if (ch == ')') {
                ++count;
                continue;
            }
            if (ch == '(') {
                --count;
                continue;
            }
            if (count != 0) continue;
            return i + 1;
        }
        logger.warn("Native function signature " + functionName + " without matching parentheses.");
        return -1;
    }

    private final JavaMethodModel createJavaMethodModel(String fullName) {
        String[] stringArray = JAVA_SEPARATOR_PATTERN.split(fullName);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"split(...)");
        List fullPath = ArraysKt.toList((Object[])stringArray);
        String classPath = CollectionsKt.joinToString$default((Iterable)fullPath.subList(0, fullPath.size() - 1), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        String methodName = (String)CollectionsKt.last((List)fullPath);
        return new JavaMethodModel(methodName, classPath, "");
    }

    private final String tagFromFileName(String fileName) {
        Integer index;
        Integer n;
        block1: {
            int[] nArray = IntStream.range(0, COMMON_PATH_PREFIXES.length).toArray();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"toArray(...)");
            int[] nArray2 = nArray;
            int n2 = nArray2.length;
            for (int i = 0; i < n2; ++i) {
                int n3;
                int it = n3 = nArray2[i];
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)fileName, (String)COMMON_PATH_PREFIXES[it], (boolean)false, (int)2, null)) continue;
                n = n3;
                break block1;
            }
            n = null;
        }
        Integer n4 = index = n;
        return n4 == null ? fileName : COMMON_PATH_PREFIXES_DISPLAY[n4];
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CaptureNodeModel parseNodeName(@NotNull String fullName, boolean isUserWritten, @Nullable String fileName) {
        Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
        return NodeNameParser.parseNodeName$default(fullName, isUserWritten, fileName, 0L, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CaptureNodeModel parseNodeName(@NotNull String fullName, boolean isUserWritten) {
        Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
        return NodeNameParser.parseNodeName$default(fullName, isUserWritten, null, 0L, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CppFunctionModel createCppFunctionModel(@NotNull String functionFullName, boolean isUserWritten, @Nullable String fileName) {
        Intrinsics.checkNotNullParameter((Object)functionFullName, (String)"functionFullName");
        return NodeNameParser.createCppFunctionModel$default(functionFullName, isUserWritten, fileName, 0L, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CppFunctionModel createCppFunctionModel(@NotNull String functionFullName, boolean isUserWritten) {
        Intrinsics.checkNotNullParameter((Object)functionFullName, (String)"functionFullName");
        return NodeNameParser.createCppFunctionModel$default(functionFullName, isUserWritten, null, 0L, 12, null);
    }

    static {
        String[] stringArray = new String[]{"/apex/", "/system/", "/vendor/"};
        COMMON_PATH_PREFIXES = stringArray;
        stringArray = new String[]{"/apex/*", "/system/*", "/vendor/*"};
        COMMON_PATH_PREFIXES_DISPLAY = stringArray;
        Logger logger = Logger.getInstance(NodeNameParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        NodeNameParser.logger = logger;
    }
}

