/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.PercentAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.profilers.cpu.LazyDataSeries;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B+\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/BatteryDrainTrackModel;", "Lcom/android/tools/adtui/model/LineChartModel;", "dataSeries", "", "Lcom/android/tools/adtui/model/SeriesData;", "", "viewRange", "Lcom/android/tools/adtui/model/Range;", "unit", "", "<init>", "(Ljava/util/List;Lcom/android/tools/adtui/model/Range;Ljava/lang/String;)V", "batteryDrainCounterSeries", "Lcom/android/tools/adtui/model/RangedContinuousSeries;", "getBatteryDrainCounterSeries", "()Lcom/android/tools/adtui/model/RangedContinuousSeries;", "axisComponentModel", "Lcom/android/tools/adtui/model/axis/AxisComponentModel;", "getAxisComponentModel", "()Lcom/android/tools/adtui/model/axis/AxisComponentModel;", "Companion", "intellij.android.profilers"})
public final class BatteryDrainTrackModel
extends LineChartModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RangedContinuousSeries batteryDrainCounterSeries;
    @NotNull
    private final AxisComponentModel axisComponentModel;

    public BatteryDrainTrackModel(@NotNull List<SeriesData<Long>> dataSeries, @NotNull Range viewRange, @NotNull String unit) {
        Intrinsics.checkNotNullParameter(dataSeries, (String)"dataSeries");
        Intrinsics.checkNotNullParameter((Object)viewRange, (String)"viewRange");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Long l = (Long)SequencesKt.maxOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)dataSeries), BatteryDrainTrackModel::_init_$lambda$0));
        long maxValue = l != null ? l : 0L;
        Long l2 = (Long)SequencesKt.minOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)dataSeries), BatteryDrainTrackModel::_init_$lambda$1));
        long minValue = l2 != null ? l2 : 0L;
        boolean negValuePresent = minValue < 0L || maxValue < 0L;
        SingleUnitAxisFormatter axisFormatter = switch (unit) {
            case "%" -> (SingleUnitAxisFormatter)new PercentAxisFormatter(1, 2);
            case "\u00b5ah" -> new SingleUnitAxisFormatter(1, 5, 1, unit, true);
            case "\u00b5a" -> {
                if (negValuePresent) {
                    yield new SingleUnitAxisFormatter(1, 2, 1, unit);
                }
                yield new SingleUnitAxisFormatter(1, 5, 1, unit, true);
            }
            default -> new SingleUnitAxisFormatter(1, 2, 5, unit, true);
        };
        double absLargestValue = RangesKt.coerceAtLeast((double)Math.abs((double)minValue), (double)Math.abs((double)maxValue));
        String string = unit;
        Range yRange = Intrinsics.areEqual((Object)string, (Object)"%") ? new Range(0.0, 100.0) : (Intrinsics.areEqual((Object)string, (Object)"\u00b5a") ? (negValuePresent ? new Range(-absLargestValue, absLargestValue) : new Range(0.0, (double)maxValue)) : new Range(0.0, (double)maxValue));
        this.axisComponentModel = (AxisComponentModel)new ResizingAxisComponentModel.Builder(yRange, (BaseAxisFormatter)axisFormatter).build();
        this.batteryDrainCounterSeries = new RangedContinuousSeries("Battery Drain", viewRange, yRange, (DataSeries)new LazyDataSeries(() -> BatteryDrainTrackModel._init_$lambda$2(dataSeries)), null, 16, null);
        this.add(this.batteryDrainCounterSeries);
    }

    @NotNull
    public final RangedContinuousSeries getBatteryDrainCounterSeries() {
        return this.batteryDrainCounterSeries;
    }

    @NotNull
    public final AxisComponentModel getAxisComponentModel() {
        return this.axisComponentModel;
    }

    private static final long _init_$lambda$0(SeriesData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Number)it.value).longValue();
    }

    private static final long _init_$lambda$1(SeriesData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Number)it.value).longValue();
    }

    private static final List _init_$lambda$2(List $dataSeries) {
        return $dataSeries;
    }

    @JvmStatic
    @NotNull
    public static final String getFormattedBatteryDrainName(@NotNull String batteryDrainCounterName) {
        return Companion.getFormattedBatteryDrainName(batteryDrainCounterName);
    }

    @JvmStatic
    @NotNull
    public static final String getUnitFromTrackName(@NotNull String trackName) {
        return Companion.getUnitFromTrackName(trackName);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/BatteryDrainTrackModel$Companion;", "", "<init>", "()V", "getFormattedBatteryDrainName", "", "batteryDrainCounterName", "getUnitFromTrackName", "trackName", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getFormattedBatteryDrainName(@NotNull String batteryDrainCounterName) {
            Intrinsics.checkNotNullParameter((Object)batteryDrainCounterName, (String)"batteryDrainCounterName");
            return switch (StringsKt.replace$default((String)batteryDrainCounterName, (String)"batt.", (String)"", (boolean)false, (int)4, null)) {
                case "capacity_pct" -> "Capacity";
                case "charge_uah" -> "Charge";
                case "current_ua" -> "Current";
                default -> {
                    void var2_2;
                    yield var2_2;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final String getUnitFromTrackName(@NotNull String trackName) {
            Intrinsics.checkNotNullParameter((Object)trackName, (String)"trackName");
            return StringsKt.contains$default((CharSequence)trackName, (CharSequence)"pct", (boolean)false, (int)2, null) ? "%" : (StringsKt.contains$default((CharSequence)trackName, (CharSequence)"uah", (boolean)false, (int)2, null) ? "\u00b5ah" : (StringsKt.contains$default((CharSequence)trackName, (CharSequence)"ua", (boolean)false, (int)2, null) ? "\u00b5a" : ""));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

