/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.cpu.systemtrace.CounterModel;
import com.android.tools.profilers.cpu.systemtrace.ProcessModel;
import com.android.tools.profilers.cpu.systemtrace.SurfaceflingerEvent;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapterKt;
import com.android.tools.profilers.cpu.systemtrace.ThreadModel;
import com.android.tools.profilers.cpu.systemtrace.TraceEventModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\n0\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\n0\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u001d\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceSurfaceflingerManager;", "", "systemTraceModel", "Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceModelAdapter;", "mainProcessName", "", "<init>", "(Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceModelAdapter;Ljava/lang/String;)V", "surfaceflingerEvents", "", "Lcom/android/tools/adtui/model/SeriesData;", "Lcom/android/tools/profilers/cpu/systemtrace/SurfaceflingerEvent;", "getSurfaceflingerEvents", "()Ljava/util/List;", "vsyncCounterValues", "", "getVsyncCounterValues", "bufferQueueValues", "getBufferQueueValues", "bufferQueueRegex", "Lkotlin/text/Regex;", "buildSfEvents", "surfaceflingerProcess", "Lcom/android/tools/profilers/cpu/systemtrace/ProcessModel;", "buildSfEventsFromThread", "mainThread", "Lcom/android/tools/profilers/cpu/systemtrace/ThreadModel;", "buildVsyncCounter", "buildBufferQueueCounter", "Companion", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nSystemTraceSurfaceflingerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemTraceSurfaceflingerManager.kt\ncom/android/tools/profilers/cpu/systemtrace/SystemTraceSurfaceflingerManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,81:1\n1#2:82\n126#3:83\n153#3,3:84\n126#3:94\n153#3,3:95\n487#4,7:87\n*S KotlinDebug\n*F\n+ 1 SystemTraceSurfaceflingerManager.kt\ncom/android/tools/profilers/cpu/systemtrace/SystemTraceSurfaceflingerManager\n*L\n55#1:83\n55#1:84,3\n66#1:94\n66#1:95,3\n63#1:87,7\n*E\n"})
public final class SystemTraceSurfaceflingerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<SeriesData<SurfaceflingerEvent>> surfaceflingerEvents;
    @NotNull
    private final List<SeriesData<Long>> vsyncCounterValues;
    @NotNull
    private final List<SeriesData<Long>> bufferQueueValues;
    @NotNull
    private final Regex bufferQueueRegex;
    @NotNull
    public static final String SURFACEFLINGER_PROCESS_NAME = "surfaceflinger";
    @NotNull
    private static final String VSYNC_COUNTER_NAME = "VSYNC-app";

    public SystemTraceSurfaceflingerManager(@NotNull SystemTraceModelAdapter systemTraceModel, @NotNull String mainProcessName) {
        Object object;
        block13: {
            block12: {
                Object object2;
                ProcessModel it;
                SystemTraceSurfaceflingerManager systemTraceSurfaceflingerManager;
                ProcessModel sfProcess;
                block11: {
                    block10: {
                        Object object3;
                        block9: {
                            block8: {
                                Object v0;
                                block7: {
                                    Intrinsics.checkNotNullParameter((Object)systemTraceModel, (String)"systemTraceModel");
                                    Intrinsics.checkNotNullParameter((Object)mainProcessName, (String)"mainProcessName");
                                    this.bufferQueueRegex = new Regex("(SurfaceView - )?" + mainProcessName + "/.+#\\d");
                                    Iterable iterable = systemTraceModel.getProcesses();
                                    for (Object t : iterable) {
                                        ProcessModel it2 = (ProcessModel)t;
                                        boolean bl = false;
                                        if (!StringsKt.endsWith$default((String)it2.getSafeProcessName(), (String)SURFACEFLINGER_PROCESS_NAME, (boolean)false, (int)2, null)) continue;
                                        v0 = t;
                                        break block7;
                                    }
                                    v0 = null;
                                }
                                sfProcess = v0;
                                SystemTraceSurfaceflingerManager systemTraceSurfaceflingerManager2 = this;
                                object3 = sfProcess;
                                if (object3 == null) break block8;
                                Object object4 = object3;
                                systemTraceSurfaceflingerManager = systemTraceSurfaceflingerManager2;
                                boolean bl = false;
                                List<SeriesData<SurfaceflingerEvent>> list = this.buildSfEvents(it);
                                systemTraceSurfaceflingerManager2 = systemTraceSurfaceflingerManager;
                                object3 = list;
                                if (list != null) break block9;
                            }
                            object3 = CollectionsKt.emptyList();
                        }
                        systemTraceSurfaceflingerManager2.surfaceflingerEvents = object3;
                        SystemTraceSurfaceflingerManager systemTraceSurfaceflingerManager3 = this;
                        object2 = sfProcess;
                        if (object2 == null) break block10;
                        it = object2;
                        systemTraceSurfaceflingerManager = systemTraceSurfaceflingerManager3;
                        boolean bl = false;
                        List<SeriesData<Long>> list = this.buildVsyncCounter(it);
                        systemTraceSurfaceflingerManager3 = systemTraceSurfaceflingerManager;
                        object2 = list;
                        if (list != null) break block11;
                    }
                    object2 = CollectionsKt.emptyList();
                }
                systemTraceSurfaceflingerManager3.vsyncCounterValues = object2;
                SystemTraceSurfaceflingerManager systemTraceSurfaceflingerManager4 = this;
                object = sfProcess;
                if (object == null) break block12;
                it = object;
                systemTraceSurfaceflingerManager = systemTraceSurfaceflingerManager4;
                boolean bl = false;
                List<SeriesData<Long>> list = this.buildBufferQueueCounter(it);
                systemTraceSurfaceflingerManager4 = systemTraceSurfaceflingerManager;
                object = list;
                if (list != null) break block13;
            }
            object = CollectionsKt.emptyList();
        }
        systemTraceSurfaceflingerManager4.bufferQueueValues = object;
    }

    @NotNull
    public final List<SeriesData<SurfaceflingerEvent>> getSurfaceflingerEvents() {
        return this.surfaceflingerEvents;
    }

    @NotNull
    public final List<SeriesData<Long>> getVsyncCounterValues() {
        return this.vsyncCounterValues;
    }

    @NotNull
    public final List<SeriesData<Long>> getBufferQueueValues() {
        return this.bufferQueueValues;
    }

    private final List<SeriesData<SurfaceflingerEvent>> buildSfEvents(ProcessModel surfaceflingerProcess) {
        ThreadModel threadModel = surfaceflingerProcess.getMainThread();
        if (threadModel == null) {
            return CollectionsKt.emptyList();
        }
        ThreadModel mainThread = threadModel;
        return this.buildSfEventsFromThread(mainThread);
    }

    private final List<SeriesData<SurfaceflingerEvent>> buildSfEventsFromThread(ThreadModel mainThread) {
        return SystemTraceModelAdapterKt.padded((Iterable)mainThread.getTraceEvents(), SystemTraceSurfaceflingerManager::buildSfEventsFromThread$lambda$0, SystemTraceSurfaceflingerManager::buildSfEventsFromThread$lambda$1, SystemTraceSurfaceflingerManager::buildSfEventsFromThread$lambda$2, SystemTraceSurfaceflingerManager::buildSfEventsFromThread$lambda$3);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SeriesData<Long>> buildVsyncCounter(ProcessModel surfaceflingerProcess) {
        void $this$mapTo$iv$iv;
        CounterModel counterModel = surfaceflingerProcess.getCounterByName().get(VSYNC_COUNTER_NAME);
        if (counterModel == null) {
            return CollectionsKt.emptyList();
        }
        CounterModel counter = counterModel;
        Map $this$map$iv = counter.getValuesByTimestampUs();
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            collection.add(new SeriesData(((Number)k).longValue(), (Object)((long)((Number)it.getValue()).doubleValue())));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<SeriesData<Long>> buildBufferQueueCounter(ProcessModel surfaceflingerProcess) {
        void $this$mapTo$iv$iv;
        Map<String, CounterModel> $this$filterKeys$iv = surfaceflingerProcess.getCounterByName();
        boolean $i$f$filterKeys22 = false;
        LinkedHashMap<String, CounterModel> result$iv = new LinkedHashMap<String, CounterModel>();
        for (Map.Entry<String, CounterModel> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl = false;
            if (!this.bufferQueueRegex.matches((CharSequence)it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        CounterModel counterModel = (CounterModel)CollectionsKt.firstOrNull((Iterable)((Map)result$iv).values());
        if (counterModel == null) {
            return CollectionsKt.emptyList();
        }
        CounterModel counter = counterModel;
        Map $this$map$iv = counter.getValuesByTimestampUs();
        boolean $i$f$map = false;
        Map $i$f$filterKeys22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry bl = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            collection.add(new SeriesData(((Number)k).longValue(), (Object)((long)((Number)it.getValue()).doubleValue())));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private static final long buildSfEventsFromThread$lambda$0(TraceEventModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getStartTimestampUs();
    }

    private static final long buildSfEventsFromThread$lambda$1(TraceEventModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getEndTimestampUs();
    }

    private static final SurfaceflingerEvent buildSfEventsFromThread$lambda$2(TraceEventModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SurfaceflingerEvent(it.getStartTimestampUs(), it.getEndTimestampUs(), SurfaceflingerEvent.Type.PROCESSING, it.getName());
    }

    private static final SurfaceflingerEvent buildSfEventsFromThread$lambda$3(long start, long end) {
        return new SurfaceflingerEvent(start, end, SurfaceflingerEvent.Type.IDLE, null, 8, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceSurfaceflingerManager$Companion;", "", "<init>", "()V", "SURFACEFLINGER_PROCESS_NAME", "", "VSYNC_COUNTER_NAME", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

