/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.customevent;

import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class UserCounterModel
extends LineChartModel {
    @NotNull
    private final String myEventName;
    @NotNull
    private final RangedContinuousSeries myUserCounterSeries;
    private static final Range DEFAULT_CUSTOM_EVENT_RANGE = new Range(0.0, 10.0);

    public UserCounterModel(@NotNull StudioProfilers profilers, @NotNull String eventName) {
        this.myEventName = eventName;
        this.myUserCounterSeries = this.createRangedSeries(profilers, this.getSeriesLabel(), DEFAULT_CUSTOM_EVENT_RANGE, this.myEventName.hashCode(), UnifiedEventDataSeries.fromFieldToDataExtractor(e -> e.getUserCounters().getRecordedValue()));
        this.add(this.myUserCounterSeries);
    }

    private RangedContinuousSeries createRangedSeries(@NotNull StudioProfilers profilers, @NotNull String name, @NotNull Range range, int groupId, Function<List<Common.Event>, List<SeriesData<Long>>> dataExtractor) {
        TransportServiceGrpc.TransportServiceBlockingStub client = profilers.getClient().getTransportClient();
        UnifiedEventDataSeries series = new UnifiedEventDataSeries(client, profilers.getSession().getStreamId(), profilers.getSession().getPid(), Common.Event.Kind.USER_COUNTERS, groupId, dataExtractor);
        return new RangedContinuousSeries(name, profilers.getTimeline().getViewRange(), range, series, profilers.getTimeline().getDataRange());
    }

    private String getSeriesLabel() {
        return "";
    }

    @NotNull
    @VisibleForTesting
    RangedContinuousSeries getEventSeries() {
        return this.myUserCounterSeries;
    }

    @NotNull
    public Range getUsageRange() {
        return DEFAULT_CUSTOM_EVENT_RANGE;
    }

    @NotNull
    public String getEventName() {
        return this.myEventName;
    }
}

