/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.leakcanary;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.CodeNavigator;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.idea.transport.poller.TransportEventPoller;
import com.android.tools.inspectors.common.api.actions.NavigateToCodeAction;
import com.android.tools.leakcanarylib.LeakCanaryParser;
import com.android.tools.leakcanarylib.data.Analysis;
import com.android.tools.leakcanarylib.data.AnalysisFailure;
import com.android.tools.leakcanarylib.data.AnalysisSuccess;
import com.android.tools.leakcanarylib.data.Leak;
import com.android.tools.leakcanarylib.data.LeakTrace;
import com.android.tools.leakcanarylib.data.LeakingStatus;
import com.android.tools.leakcanarylib.data.Node;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ModelStage;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0001@B\u0011\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\u000e\u0010\"\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0019J\b\u0010#\u001a\u00020 H\u0007J\u0010\u0010$\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010\u0010J\b\u0010&\u001a\u00020 H\u0002J\b\u0010'\u001a\u00020 H\u0002J\u0016\u0010(\u001a\u00020 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J\u0010\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020,H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u000200H\u0002J \u00101\u001a\u00020 2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u00020\u0019H\u0002J\b\u00106\u001a\u000207H\u0016J\u001e\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020\u001c2\u0006\u00102\u001a\u000203J&\u0010;\u001a\b\u0012\u0004\u0012\u00020.0\u000f2\u0006\u00102\u001a\u0002032\u0006\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020\u001cH\u0002J\u000e\u0010<\u001a\u00020 2\u0006\u0010=\u001a\u00020>J\u0010\u0010?\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014\u00a8\u0006A"}, d2={"Lcom/android/tools/profilers/leakcanary/LeakCanaryModel;", "Lcom/android/tools/profilers/ModelStage;", "Lcom/android/tools/adtui/model/updater/Updatable;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;)V", "statusListener", "Lcom/android/tools/idea/transport/poller/TransportEventListener;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "myLeakCanaryParser", "Lcom/android/tools/leakcanarylib/LeakCanaryParser;", "_leaks", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/android/tools/leakcanarylib/data/Leak;", "leaks", "Lkotlinx/coroutines/flow/StateFlow;", "getLeaks", "()Lkotlinx/coroutines/flow/StateFlow;", "_selectedLeak", "selectedLeak", "getSelectedLeak", "_isRecording", "", "isRecording", "_elapsedNs", "", "elapsedNs", "getElapsedNs", "startListening", "", "stopListening", "setIsRecording", "clearLeaks", "onLeakSelection", "newLeak", "registerLeakCanaryListeners", "deregisterLeakCanaryListeners", "addLeaks", "newLeaks", "leakDetected", "event", "Lcom/android/tools/profiler/proto/Common$Event;", "getEventFromLogcatMessage", "Lcom/android/tools/leakcanarylib/data/Analysis;", "logcatMessage", "", "toggleLeakCanaryLogcatTracking", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "enable", "endSession", "getStageType", "Lcom/google/wireless/android/sdk/stats/AndroidProfilerEvent$Stage;", "loadFromPastSession", "startTimestamp", "endTimeStamp", "getAllLeakCanaryEvents", "goToDeclaration", "node", "Lcom/android/tools/leakcanarylib/data/Node;", "update", "Companion", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nLeakCanaryModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeakCanaryModel.kt\ncom/android/tools/profilers/leakcanary/LeakCanaryModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n1863#2,2:281\n1611#2,9:283\n1863#2:292\n1864#2:294\n1620#2:295\n1#3:293\n*S KotlinDebug\n*F\n+ 1 LeakCanaryModel.kt\ncom/android/tools/profilers/leakcanary/LeakCanaryModel\n*L\n189#1:281,2\n205#1:283,9\n205#1:292\n205#1:294\n205#1:295\n205#1:293\n*E\n"})
public final class LeakCanaryModel
extends ModelStage
implements Updatable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StudioProfilers profilers;
    private TransportEventListener statusListener;
    @NotNull
    private final Logger logger;
    @NotNull
    private final LeakCanaryParser myLeakCanaryParser;
    @NotNull
    private final MutableStateFlow<List<Leak>> _leaks;
    @NotNull
    private final StateFlow<List<Leak>> leaks;
    @NotNull
    private final MutableStateFlow<Leak> _selectedLeak;
    @NotNull
    private final StateFlow<Leak> selectedLeak;
    @NotNull
    private final MutableStateFlow<Boolean> _isRecording;
    @NotNull
    private final StateFlow<Boolean> isRecording;
    @NotNull
    private final MutableStateFlow<Long> _elapsedNs;
    @NotNull
    private final StateFlow<Long> elapsedNs;

    public LeakCanaryModel(@NotNull StudioProfilers profilers) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        super(profilers);
        this.profilers = profilers;
        Logger logger = Logger.getInstance(LeakCanaryModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.myLeakCanaryParser = new LeakCanaryParser();
        this._leaks = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.leaks = FlowKt.asStateFlow(this._leaks);
        this._selectedLeak = StateFlowKt.MutableStateFlow(null);
        this.selectedLeak = FlowKt.asStateFlow(this._selectedLeak);
        this._isRecording = StateFlowKt.MutableStateFlow((Object)false);
        this.isRecording = FlowKt.asStateFlow(this._isRecording);
        this._elapsedNs = StateFlowKt.MutableStateFlow((Object)0L);
        this.elapsedNs = FlowKt.asStateFlow(this._elapsedNs);
    }

    @NotNull
    public final StateFlow<List<Leak>> getLeaks() {
        return this.leaks;
    }

    @NotNull
    public final StateFlow<Leak> getSelectedLeak() {
        return this.selectedLeak;
    }

    @NotNull
    public final StateFlow<Boolean> isRecording() {
        return this.isRecording;
    }

    @NotNull
    public final StateFlow<Long> getElapsedNs() {
        return this.elapsedNs;
    }

    public final void startListening() {
        this.profilers.getUpdater().register((Updatable)this);
        this.setIsRecording(true);
        this.registerLeakCanaryListeners();
        Common.Session session = this.profilers.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getSession(...)");
        this.toggleLeakCanaryLogcatTracking(session, true, false);
    }

    public final void stopListening() {
        this.setIsRecording(false);
        Common.Session session = this.profilers.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getSession(...)");
        this.toggleLeakCanaryLogcatTracking(session, false, true);
        this.deregisterLeakCanaryListeners();
        this.profilers.getUpdater().unregister((Updatable)this);
    }

    public final void setIsRecording(boolean isRecording) {
        this._isRecording.setValue((Object)isRecording);
    }

    @VisibleForTesting
    public final void clearLeaks() {
        this._leaks.setValue((Object)CollectionsKt.emptyList());
        this.onLeakSelection(null);
    }

    public final void onLeakSelection(@Nullable Leak newLeak) {
        this._selectedLeak.setValue((Object)newLeak);
    }

    private final void registerLeakCanaryListeners() {
        long startTime = this.profilers.getSession().getStartTimestamp();
        this.statusListener = new TransportEventListener(Common.Event.Kind.LEAKCANARY_LOGCAT, this.profilers.getIdeServices().getMainExecutor(), null, () -> LeakCanaryModel.registerLeakCanaryListeners$lambda$0(this), () -> LeakCanaryModel.registerLeakCanaryListeners$lambda$1(this), null, () -> LeakCanaryModel.registerLeakCanaryListeners$lambda$2(startTime), null, arg_0 -> LeakCanaryModel.registerLeakCanaryListeners$lambda$4(this, arg_0), 164, null);
        TransportEventPoller transportEventPoller = this.profilers.getTransportPoller();
        TransportEventListener transportEventListener = this.statusListener;
        if (transportEventListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statusListener");
            transportEventListener = null;
        }
        transportEventPoller.registerListener(transportEventListener);
    }

    private final void deregisterLeakCanaryListeners() {
        TransportEventPoller transportEventPoller = this.profilers.getTransportPoller();
        TransportEventListener transportEventListener = this.statusListener;
        if (transportEventListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statusListener");
            transportEventListener = null;
        }
        transportEventPoller.unregisterListener(transportEventListener);
    }

    @VisibleForTesting
    public final void addLeaks(@NotNull List<Leak> newLeaks) {
        Intrinsics.checkNotNullParameter(newLeaks, (String)"newLeaks");
        List newLeakList = CollectionsKt.plus((Collection)((Collection)this._leaks.getValue()), (Iterable)newLeaks);
        this._leaks.setValue((Object)newLeakList);
    }

    private final void leakDetected(Common.Event event) {
        String string = event.getLeakcanaryLogcat().getLogcatMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLogcatMessage(...)");
        if (((CharSequence)string).length() == 0) {
            return;
        }
        String string2 = event.getLeakcanaryLogcat().getLogcatMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLogcatMessage(...)");
        Analysis leakAnalysisEvent = this.getEventFromLogcatMessage(string2);
        if (leakAnalysisEvent != null) {
            if (leakAnalysisEvent instanceof AnalysisSuccess) {
                this.addLeaks(((AnalysisSuccess)leakAnalysisEvent).getLeaks());
            } else {
                this.logger.warn("Leak analysis failure {}", ((AnalysisFailure)leakAnalysisEvent).getException());
            }
            if (this._selectedLeak.getValue() == null && !((Collection)this._leaks.getValue()).isEmpty()) {
                this.onLeakSelection((Leak)CollectionsKt.first((List)((List)this._leaks.getValue())));
            }
        }
    }

    private final Analysis getEventFromLogcatMessage(String logcatMessage) {
        try {
            return this.myLeakCanaryParser.parseLogcatMessage(logcatMessage);
        }
        catch (Exception e) {
            this.logger.warn("Leak canary serializer detected issue while parsing .. skipping leak event ");
            return null;
        }
    }

    private final void toggleLeakCanaryLogcatTracking(Common.Session session, boolean enable, boolean endSession) {
        Commands.Command.Builder builder;
        Commands.Command.Builder $this$toggleLeakCanaryLogcatTracking_u24lambda_u245 = builder = Commands.Command.newBuilder();
        boolean bl = false;
        $this$toggleLeakCanaryLogcatTracking_u24lambda_u245.setStreamId(session.getStreamId());
        $this$toggleLeakCanaryLogcatTracking_u24lambda_u245.setPid(session.getPid());
        if (enable) {
            $this$toggleLeakCanaryLogcatTracking_u24lambda_u245.setType(Commands.Command.CommandType.START_LOGCAT_TRACKING);
        } else {
            $this$toggleLeakCanaryLogcatTracking_u24lambda_u245.setType(Commands.Command.CommandType.STOP_LOGCAT_TRACKING);
            if (endSession) {
                $this$toggleLeakCanaryLogcatTracking_u24lambda_u245.setSessionId(session.getSessionId());
            }
        }
        Commands.Command.Builder cmd = builder;
        this.profilers.getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(cmd).build());
    }

    @Override
    @NotNull
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.UNKNOWN_STAGE;
    }

    public final void loadFromPastSession(long startTimestamp, long endTimeStamp, @NotNull Common.Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        List<Analysis> analysisEvents = this.getAllLeakCanaryEvents(session, startTimestamp, endTimeStamp);
        Iterable $this$forEach$iv = analysisEvents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Analysis analysis = (Analysis)element$iv;
            boolean bl = false;
            if (!(analysis instanceof AnalysisSuccess)) continue;
            this.addLeaks(((AnalysisSuccess)analysis).getLeaks());
        }
        if (!((Collection)this._leaks.getValue()).isEmpty()) {
            this.onLeakSelection((Leak)CollectionsKt.first((List)((List)this._leaks.getValue())));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Analysis> getAllLeakCanaryEvents(Common.Session session, long startTimestamp, long endTimeStamp) {
        void $this$mapNotNullTo$iv$iv;
        ProfilerClient profilerClient = this.profilers.getClient();
        Intrinsics.checkNotNullExpressionValue((Object)profilerClient, (String)"getClient(...)");
        List<Common.Event> eventList = Companion.getLeaksFromRange(profilerClient, session, new Range((double)startTimestamp, (double)endTimeStamp));
        Iterable $this$mapNotNull$iv = eventList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Analysis it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Common.Event event = (Common.Event)element$iv$iv;
            boolean bl2 = false;
            String string = event.getLeakcanaryLogcat().getLogcatMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLogcatMessage(...)");
            if (this.getEventFromLogcatMessage(string) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void goToDeclaration(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Function0 codeLocationSupplier = () -> LeakCanaryModel.goToDeclaration$lambda$8(node);
        CodeNavigator navigator = this.getStudioProfilers().getIdeServices().getCodeNavigator();
        NavigateToCodeAction action = new NavigateToCodeAction(() -> LeakCanaryModel.goToDeclaration$lambda$9(codeLocationSupplier), navigator);
        AnActionEvent anActionEvent = AnActionEvent.createEvent((AnAction)((AnAction)action), (DataContext)DataContext.EMPTY_CONTEXT, null, (String)"CodeInspection", (ActionUiKind)ActionUiKind.NONE, null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent event = anActionEvent;
        action.actionPerformed(event);
    }

    public void update(long elapsedNs) {
        MutableStateFlow<Long> mutableStateFlow = this._elapsedNs;
        mutableStateFlow.setValue((Object)(((Number)mutableStateFlow.getValue()).longValue() + elapsedNs));
    }

    private static final long registerLeakCanaryListeners$lambda$0(LeakCanaryModel this$0) {
        return this$0.profilers.getSession().getStreamId();
    }

    private static final int registerLeakCanaryListeners$lambda$1(LeakCanaryModel this$0) {
        return this$0.profilers.getSession().getPid();
    }

    private static final long registerLeakCanaryListeners$lambda$2(long $startTime) {
        return $startTime;
    }

    private static final boolean registerLeakCanaryListeners$lambda$4(LeakCanaryModel this$0, Common.Event event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean it = bl = false;
        boolean bl2 = false;
        this$0.leakDetected(event);
        return bl;
    }

    private static final CodeLocation goToDeclaration$lambda$8(Node $node) {
        return new CodeLocation.Builder(StringsKt.removeSuffix((String)$node.getClassName(), (CharSequence)"[]")).build();
    }

    private static final CodeLocation goToDeclaration$lambda$9(Function0 $tmp0) {
        return (CodeLocation)$tmp0.invoke();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/profilers/leakcanary/LeakCanaryModel$Companion;", "", "<init>", "()V", "getLeaksFromRange", "", "Lcom/android/tools/profiler/proto/Common$Event;", "profilerClient", "Lcom/android/tools/profilers/ProfilerClient;", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "range", "Lcom/android/tools/adtui/model/Range;", "getLeakCanaryLogcatInfo", "getLeakClassName", "", "leak", "Lcom/android/tools/leakcanarylib/data/Leak;", "intellij.android.profilers"})
    @SourceDebugExtension(value={"SMAP\nLeakCanaryModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeakCanaryModel.kt\ncom/android/tools/profilers/leakcanary/LeakCanaryModel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n1368#2:281\n1454#2,5:282\n1368#2:287\n1454#2,5:288\n774#2:293\n865#2,2:294\n295#2,2:296\n*S KotlinDebug\n*F\n+ 1 LeakCanaryModel.kt\ncom/android/tools/profilers/leakcanary/LeakCanaryModel$Companion\n*L\n235#1:281\n235#1:282,5\n253#1:287\n253#1:288,5\n254#1:293\n254#1:294,2\n266#1:296,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Common.Event> getLeaksFromRange(@NotNull ProfilerClient profilerClient, @NotNull Common.Session session, @NotNull Range range) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)profilerClient, (String)"profilerClient");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            List list = profilerClient.getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(Common.Event.Kind.LEAKCANARY_LOGCAT).setFromTimestamp((long)range.getMin()).setToTimestamp((long)range.getMax()).build()).getGroupsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getGroupsList(...)");
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Transport.EventGroup group = (Transport.EventGroup)element$iv$iv;
                boolean bl = false;
                List list2 = group.getEventsList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEventsList(...)");
                Iterable list$iv$iv = CollectionsKt.toList((Iterable)list2);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Common.Event> getLeakCanaryLogcatInfo(@NotNull ProfilerClient profilerClient, @NotNull Common.Session session, @NotNull Range range) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)profilerClient, (String)"profilerClient");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            List list = profilerClient.getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(Common.Event.Kind.LEAKCANARY_LOGCAT_INFO).setFromTimestamp((long)range.getMin()).setToTimestamp((long)range.getMax()).build()).getGroupsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getGroupsList(...)");
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Transport.EventGroup group = (Transport.EventGroup)element$iv$iv;
                boolean bl = false;
                List list2 = group.getEventsList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEventsList(...)");
                Iterable list$iv$iv = CollectionsKt.toList((Iterable)list2);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Common.Event event = (Common.Event)element$iv$iv;
                boolean bl = false;
                if (!event.getIsEnded()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final String getLeakClassName(@Nullable Leak leak) {
            Object object;
            block7: {
                block6: {
                    String string;
                    block5: {
                        object = leak;
                        if (object == null || (object = object.getDisplayedLeakTrace()) == null) break block6;
                        for (LeakTrace leakTrace : (Iterable)object) {
                            Object v1;
                            block4: {
                                boolean bl = false;
                                Iterable $this$firstOrNull$iv = leakTrace.getNodes();
                                boolean $i$f$firstOrNull = false;
                                for (Object element$iv : $this$firstOrNull$iv) {
                                    Node node = (Node)element$iv;
                                    boolean bl2 = false;
                                    if (!(node.getLeakingStatus() == LeakingStatus.YES)) continue;
                                    v1 = element$iv;
                                    break block4;
                                }
                                v1 = null;
                            }
                            Node node = v1;
                            String string2 = node != null ? node.getClassName() : null;
                            if (string2 == null) continue;
                            string = string2;
                            break block5;
                        }
                        string = object = null;
                    }
                    if (string != null) break block7;
                }
                return "";
            }
            Object className = object;
            String[] stringArray = new String[]{"."};
            List classPathSplit = StringsKt.split$default((CharSequence)((CharSequence)className), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            return classPathSplit.size() >= 2 ? classPathSplit.get(classPathSplit.size() - 2) + "." + CollectionsKt.last((List)classPathSplit) : className;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

