/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryCaptureView
extends AspectObserver {
    @NotNull
    private final MemoryCaptureSelection mySelection;
    @NotNull
    private final JLabel myLabel;
    @NotNull
    private final JPanel myPanel;
    @Nullable
    private CaptureObject myCaptureObject = null;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryCaptureView.class);
    }

    MemoryCaptureView(@NotNull MemoryCaptureSelection selection, @NotNull IdeProfilerComponents ideProfilerComponents) {
        this.mySelection = selection;
        this.mySelection.getAspect().addDependency((AspectObserver)this).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADING_CAPTURE, this::reset).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADED_CAPTURE, this::refresh);
        this.myPanel = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myLabel = new JLabel();
        this.myLabel.setBorder((Border)new JBEmptyBorder(0, 11, 0, 3));
        this.reset();
    }

    @VisibleForTesting
    @NotNull
    JLabel getLabel() {
        return this.myLabel;
    }

    @NotNull
    JComponent getComponent() {
        return this.myPanel;
    }

    private void reset() {
        this.myPanel.removeAll();
        this.myLabel.setText("");
        this.myCaptureObject = this.mySelection.getSelectedCapture();
    }

    private void refresh() {
        boolean validCapture;
        CaptureObject captureObject = this.mySelection.getSelectedCapture();
        boolean bl = validCapture = captureObject == this.myCaptureObject && this.myCaptureObject != null;
        if (validCapture) {
            this.myLabel.setText(this.myCaptureObject.getName());
            this.myPanel.add(this.myLabel);
            this.myPanel.add((Component)new FlatSeparator());
        }
    }
}

