/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ReferenceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IconManager;
import com.intellij.ui.NewUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import icons.StudioIcons;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/profilers/memory/ValueColumnRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "<init>", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "setIconColorized", "icon", "Ljavax/swing/Icon;", "Companion", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=1)
public class ValueColumnRenderer
extends ColoredTreeCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final SimpleTextAttributes STRING_ATTRIBUTES;

    public void customizeCellRenderer(@NotNull JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value instanceof MemoryObjectTreeNode)) {
            SimpleColoredComponent simpleColoredComponent = this.append(value.toString());
            v1 = simpleColoredComponent;
            Intrinsics.checkNotNullExpressionValue((Object)simpleColoredComponent, (String)"append(...)");
        } else if (!(((MemoryObjectTreeNode)value).getAdapter() instanceof ValueObject)) {
            SimpleColoredComponent simpleColoredComponent = this.append(((MemoryObjectTreeNode)value).getAdapter().getName());
            v1 = simpleColoredComponent;
            Intrinsics.checkNotNullExpressionValue((Object)simpleColoredComponent, (String)"append(...)");
        } else {
            Object t = ((MemoryObjectTreeNode)value).getAdapter();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.android.tools.profilers.memory.adapters.ValueObject");
            ValueObject valueObject = (ValueObject)t;
            Icon icon = Companion.getValueObjectIcon(valueObject);
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getValueObjectIcon(...)");
            this.setIconColorized(icon);
            this.setTextAlign(2);
            String string = valueObject.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String name = string;
            this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES, name);
            this.append(((CharSequence)name).length() == 0 ? "" : " = ");
            String string2 = valueObject.getValueText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValueText(...)");
            String valueText = string2;
            this.append(valueText, SimpleTextAttributes.REGULAR_ATTRIBUTES, valueText);
            this.append(((CharSequence)valueText).length() == 0 ? "" : " ");
            String string3 = valueObject.getToStringText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getToStringText(...)");
            String toStringText = string3;
            this.append(toStringText, valueObject.getValueType() == ValueObject.ValueType.STRING ? STRING_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES, toStringText);
            v1 = Unit.INSTANCE;
        }
    }

    private final void setIconColorized(Icon icon) {
        this.setIcon(this.mySelected && this.isFocused() && !NewUI.isEnabled() ? ColoredIconGenerator.generateWhiteIcon((Icon)icon) : icon);
    }

    @JvmStatic
    public static final Icon getValueObjectIcon(@NotNull ValueObject $this$getValueObjectIcon) {
        return Companion.getValueObjectIcon($this$getValueObjectIcon);
    }

    static {
        STRING_ATTRIBUTES = new SimpleTextAttributes(1, new Color(0, 128, 0));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t*\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\r\u001a\u00020\t*\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/profilers/memory/ValueColumnRenderer$Companion;", "", "<init>", "()V", "STRING_ATTRIBUTES", "Lcom/intellij/ui/SimpleTextAttributes;", "getSTRING_ATTRIBUTES", "()Lcom/intellij/ui/SimpleTextAttributes;", "getValueObjectIcon", "Ljavax/swing/Icon;", "kotlin.jvm.PlatformType", "Lcom/android/tools/profilers/memory/adapters/ValueObject;", "(Lcom/android/tools/profilers/memory/adapters/ValueObject;)Ljavax/swing/Icon;", "getStackedIcon", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "stackedIcon", "nonStackedIcon", "intellij.android.profilers.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleTextAttributes getSTRING_ATTRIBUTES() {
            return STRING_ATTRIBUTES;
        }

        @JvmStatic
        public final Icon getValueObjectIcon(@NotNull ValueObject $this$getValueObjectIcon) {
            Icon icon;
            Intrinsics.checkNotNullParameter((Object)$this$getValueObjectIcon, (String)"<this>");
            ValueObject valueObject = $this$getValueObjectIcon;
            if (valueObject instanceof FieldObject) {
                if (((FieldObject)$this$getValueObjectIcon).getValueType() == ValueObject.ValueType.ARRAY) {
                    InstanceObject instanceObject = ((FieldObject)$this$getValueObjectIcon).getAsInstance();
                    Icon icon2 = StudioIcons.Profiler.Overlays.ARRAY_STACK;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ARRAY_STACK");
                    Icon icon3 = AllIcons.Debugger.Db_array;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Db_array");
                    icon = this.getStackedIcon(instanceObject, icon2, icon3);
                } else if (((FieldObject)$this$getValueObjectIcon).getValueType().getIsPrimitive()) {
                    Icon icon4 = AllIcons.Debugger.Db_primitive;
                    icon = icon4;
                    Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Db_primitive");
                } else {
                    InstanceObject instanceObject = ((FieldObject)$this$getValueObjectIcon).getAsInstance();
                    Icon icon5 = StudioIcons.Profiler.Overlays.FIELD_STACK;
                    Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"FIELD_STACK");
                    icon = this.getStackedIcon(instanceObject, icon5, IconManager.Companion.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Field));
                }
            } else if (valueObject instanceof ReferenceObject) {
                if (((ReferenceObject)$this$getValueObjectIcon).getReferenceInstance().getIsRoot()) {
                    icon = AllIcons.Hierarchy.Subtypes;
                } else if (((ReferenceObject)$this$getValueObjectIcon).getReferenceInstance().getValueType() == ValueObject.ValueType.ARRAY) {
                    InstanceObject instanceObject = ((ReferenceObject)$this$getValueObjectIcon).getReferenceInstance();
                    Icon icon6 = StudioIcons.Profiler.Overlays.ARRAY_STACK;
                    Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"ARRAY_STACK");
                    Icon icon7 = AllIcons.Debugger.Db_array;
                    Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"Db_array");
                    icon = this.getStackedIcon(instanceObject, icon6, icon7);
                } else {
                    InstanceObject instanceObject = ((ReferenceObject)$this$getValueObjectIcon).getReferenceInstance();
                    Icon icon8 = StudioIcons.Profiler.Overlays.FIELD_STACK;
                    Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"FIELD_STACK");
                    icon = this.getStackedIcon(instanceObject, icon8, IconManager.Companion.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Field));
                }
            } else if (valueObject instanceof InstanceObject) {
                InstanceObject instanceObject = (InstanceObject)$this$getValueObjectIcon;
                Icon icon9 = StudioIcons.Profiler.Overlays.INTERFACE_STACK;
                Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"INTERFACE_STACK");
                Icon icon10 = PlatformIcons.INTERFACE_ICON;
                Intrinsics.checkNotNullExpressionValue((Object)icon10, (String)"INTERFACE_ICON");
                icon = this.getStackedIcon(instanceObject, icon9, icon10);
            } else {
                icon = PlatformIcons.INTERFACE_ICON;
            }
            return icon;
        }

        private final Icon getStackedIcon(InstanceObject $this$getStackedIcon, Icon stackedIcon, Icon nonStackedIcon) {
            return $this$getStackedIcon == null || $this$getStackedIcon.getCallStackDepth() == 0 ? nonStackedIcon : stackedIcon;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

