/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profilers.memory.adapters.ArrayObject;
import com.android.tools.profilers.memory.adapters.BitmapDecoder;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidBitmapDataProvider
implements BitmapDecoder.BitmapDataProvider {
    public static final String BITMAP_FQCN = "android.graphics.Bitmap";
    public static final String BITMAP_DRAWABLE_FQCN = "android.graphics.drawable.BitmapDrawable";
    private byte[] myBuffer = null;
    private boolean myIsMutable = false;
    private int myWidth = -1;
    private int myHeight = -1;

    @Nullable
    public static AndroidBitmapDataProvider createDecoder(@NotNull InstanceObject instance) {
        if ((instance = AndroidBitmapDataProvider.getBitmapClassInstance(instance)) == null) {
            return null;
        }
        Integer width = null;
        Integer height = null;
        Boolean isMutable = null;
        byte[] dataBuffer = null;
        for (FieldObject field : instance.getFields()) {
            Object fieldValue = field.getValue();
            if ("mBuffer".equals(field.getFieldName())) {
                ArrayObject arrayObject;
                InstanceObject bufferInstance = field.getAsInstance();
                if (bufferInstance == null || (arrayObject = bufferInstance.getArrayObject()) == null || arrayObject.getArrayElementType() != ValueObject.ValueType.BYTE) continue;
                dataBuffer = arrayObject.getAsByteArray();
                continue;
            }
            if ("mIsMutable".equals(field.getFieldName()) && fieldValue instanceof Boolean) {
                isMutable = (Boolean)fieldValue;
                continue;
            }
            if ("mWidth".equals(field.getFieldName()) && fieldValue instanceof Integer) {
                width = (Integer)fieldValue;
                continue;
            }
            if (!"mHeight".equals(field.getFieldName()) || !(fieldValue instanceof Integer)) continue;
            height = (Integer)fieldValue;
        }
        if (dataBuffer == null || isMutable == null || width == null || height == null) {
            return null;
        }
        return new AndroidBitmapDataProvider(dataBuffer, isMutable, width, height);
    }

    private AndroidBitmapDataProvider(@NotNull byte[] buffer, boolean isMutable, int width, int height) {
        this.myBuffer = buffer;
        this.myIsMutable = isMutable;
        this.myWidth = width;
        this.myHeight = height;
    }

    @Override
    @Nullable
    public BitmapDecoder.PixelFormat getBitmapConfigName() {
        int area = this.myWidth * this.myHeight;
        int pixelSize = this.myBuffer.length / area;
        if (!this.myIsMutable && this.myBuffer.length % area != 0 || this.myIsMutable && area > this.myBuffer.length) {
            return null;
        }
        switch (pixelSize) {
            case 4: {
                return BitmapDecoder.PixelFormat.ARGB_8888;
            }
            case 2: {
                return BitmapDecoder.PixelFormat.RGB_565;
            }
        }
        return BitmapDecoder.PixelFormat.ALPHA_8;
    }

    @Override
    @Nullable
    public Dimension getDimension() {
        return this.myWidth < 0 || this.myHeight < 0 ? null : new Dimension(this.myWidth, this.myHeight);
    }

    @Override
    @Nullable
    public byte[] getPixelBytes(@NotNull Dimension size) {
        return this.myBuffer;
    }

    @Nullable
    private static InstanceObject getBitmapClassInstance(@NotNull InstanceObject instance) {
        String className = instance.getClassEntry().getClassName();
        if (BITMAP_FQCN.equals(className)) {
            return instance;
        }
        if (BITMAP_DRAWABLE_FQCN.equals(className)) {
            return AndroidBitmapDataProvider.getBitmapFromDrawable(instance);
        }
        return null;
    }

    @Nullable
    private static InstanceObject getBitmapFromDrawable(@NotNull InstanceObject instance) {
        InstanceObject bitmapState = AndroidBitmapDataProvider.getBitmapStateFromBitmapDrawable(instance);
        if (bitmapState == null) {
            return null;
        }
        for (FieldObject field : bitmapState.getFields()) {
            String className;
            InstanceObject value;
            if (!"mBitmap".equals(field.getFieldName()) || (value = field.getAsInstance()) == null || !BITMAP_FQCN.equals(className = value.getClassEntry().getClassName())) continue;
            return value;
        }
        return null;
    }

    @Nullable
    private static InstanceObject getBitmapStateFromBitmapDrawable(@NotNull InstanceObject bitmapDrawable) {
        for (FieldObject field : bitmapDrawable.getFields()) {
            String className;
            InstanceObject value;
            if (!"mBitmapState".equals(field.getFieldName()) || (value = field.getAsInstance()) == null || !"android.graphics.drawable.BitmapDrawable$BitmapState".equals(className = value.getClassEntry().getClassName())) continue;
            return value;
        }
        return null;
    }
}

