/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.memory.BaseMemoryProfilerStage;
import com.android.tools.profilers.memory.ClassGrouping;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeMemoryHeapSet;
import com.android.tools.profilers.perfetto.traceprocessor.TraceProcessorService;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NativeAllocationSampleCaptureObject
implements CaptureObject {
    private final ClassDb myClassDb = new ClassDb();
    private final ProfilerClient myClient;
    private final Common.Session mySession;
    private final long myStartTimeNs;
    private final long myEndTimeNs;
    private final List<HeapSet> myHeapSets;
    private final NativeMemoryHeapSet myDefaultHeapSet;
    private final BaseMemoryProfilerStage myStage;
    boolean myIsLoadingError = false;
    boolean myIsDoneLoading = false;
    private final Trace.TraceInfo myInfo;

    public NativeAllocationSampleCaptureObject(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Trace.TraceInfo info, @NotNull BaseMemoryProfilerStage stage) {
        this.myClient = client;
        this.mySession = session;
        this.myInfo = info;
        this.myStartTimeNs = info.getFromTimestamp();
        this.myEndTimeNs = info.getToTimestamp();
        this.myStage = stage;
        this.myDefaultHeapSet = new NativeMemoryHeapSet(this);
        this.myHeapSets = new ArrayList<HeapSet>();
        this.myHeapSets.add(this.myDefaultHeapSet);
    }

    @Override
    @NotNull
    public String getName() {
        return "Recorded Native Allocations";
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    @NotNull
    public String getExportableExtension() {
        return "heapprofd";
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) {
        MemoryProfiler.saveHeapProfdSampleToFile(this.myClient, this.mySession, this.myInfo, outputStream);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        assert (this.isDoneLoading() && !this.isError());
        return this.getHeapSets().stream().map(ClassifierSet::getInstancesStream).flatMap(Function.identity());
    }

    @Override
    public long getStartTimeNs() {
        return this.myStartTimeNs;
    }

    @Override
    public long getEndTimeNs() {
        return this.myEndTimeNs;
    }

    @Override
    @NotNull
    public ClassDb getClassDatabase() {
        return this.myClassDb;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        File trace;
        Transport.BytesResponse response = Transport.BytesResponse.getDefaultInstance();
        int retryCount = 100;
        while (response.getContents().isEmpty() && (response = this.myClient.getTransportClient().getBytes(Transport.BytesRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setId(Long.toString(this.myStartTimeNs)).build())).getContents().isEmpty()) {
            if (retryCount-- == 0) {
                this.myIsLoadingError = true;
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.myIsLoadingError = true;
                return false;
            }
        }
        try {
            trace = FileUtil.createTempFile((String)String.format(Locale.US, "heap_trace_%d", this.myStartTimeNs), (String)("." + this.getExportableExtension()), (boolean)true);
            try (FileOutputStream out = new FileOutputStream(trace);){
                out.write(response.getContents().toByteArray());
                out.flush();
            }
        }
        catch (IOException ex) {
            return false;
        }
        String abi = this.myStage.getStudioProfilers().getSessionsManager().getSelectedSessionMetaData().getProcessAbi();
        TraceProcessorService service = this.myStage.getStudioProfilers().getIdeServices().getTraceProcessorService();
        IdeProfilerServices profilerServices = this.myStage.getStudioProfilers().getIdeServices();
        long traceId = this.myStartTimeNs;
        service.loadTrace(traceId, trace.getAbsoluteFile(), profilerServices);
        service.loadMemoryData(traceId, abi, this.myDefaultHeapSet, profilerServices);
        this.myIsDoneLoading = true;
        return true;
    }

    @Override
    public boolean isDoneLoading() {
        return this.myIsDoneLoading || this.myIsLoadingError;
    }

    @Override
    public boolean isError() {
        return this.myIsLoadingError;
    }

    @Override
    public void unload() {
        this.myIsLoadingError = false;
        this.myIsDoneLoading = false;
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        return Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.MODULE, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.DEALLOCATIONS, CaptureObject.ClassifierAttribute.ALLOCATIONS_SIZE, CaptureObject.ClassifierAttribute.DEALLOCATIONS_SIZE, CaptureObject.ClassifierAttribute.TOTAL_COUNT, CaptureObject.ClassifierAttribute.REMAINING_SIZE);
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        return Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.NATIVE_SIZE);
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        return this.myHeapSets;
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        assert (heapId == 0);
        return this.myHeapSets.get(heapId);
    }

    @Override
    public boolean isGroupingSupported(ClassGrouping grouping) {
        switch (grouping) {
            case NATIVE_ARRANGE_BY_ALLOCATION_METHOD: 
            case NATIVE_ARRANGE_BY_CALLSTACK: {
                return true;
            }
        }
        return false;
    }
}

