/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassSet;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class PackageSet
extends ClassifierSet {
    @NotNull
    private final CaptureObject myCaptureObject;
    private final int myPackageNameIndex;

    @NotNull
    public static Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
        return PackageSet.packageClassifier(captureObject, 0);
    }

    public PackageSet(@NotNull CaptureObject captureObject, @NotNull String packageElementName, int packageNameIndex) {
        super(packageElementName);
        this.myCaptureObject = captureObject;
        this.myPackageNameIndex = packageNameIndex;
    }

    @Override
    @NotNull
    public Classifier createSubClassifier() {
        return PackageSet.packageClassifier(this.myCaptureObject, this.myPackageNameIndex + 1);
    }

    private static Classifier packageClassifier(CaptureObject captureObject, int packageNameIndex) {
        return new Classifier.Join<String>(PackageSet.packageElementAt(packageNameIndex), elem -> new PackageSet(captureObject, (String)elem, packageNameIndex), Classifier.of(InstanceObject::getClassEntry, ClassSet::new));
    }

    private static Function1<InstanceObject, String> packageElementAt(int packageNameIndex) {
        return inst -> packageNameIndex < inst.getClassEntry().getSplitPackageName().length ? inst.getClassEntry().getSplitPackageName()[packageNameIndex] : null;
    }
}

