/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.perfetto.traceprocessor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JA\u0010\u0004\u001a\u0004\u0018\u00010\u00052\"\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0005`\t2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ-\u0010\r\u001a\u0004\u0018\u00010\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModelUtils;", "", "<init>", "()V", "findValueNearKey", "", "sortedMap", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "targetKey", "tolerance", "(Ljava/util/LinkedHashMap;JJ)Ljava/lang/Integer;", "binarySearchWithTolerance", "keys", "", "target", "(Ljava/util/List;JJ)Ljava/lang/Long;", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nTraceProcessorModelUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TraceProcessorModelUtils.kt\ncom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModelUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class TraceProcessorModelUtils {
    @NotNull
    public static final TraceProcessorModelUtils INSTANCE = new TraceProcessorModelUtils();

    private TraceProcessorModelUtils() {
    }

    @Nullable
    public final Integer findValueNearKey(@NotNull LinkedHashMap<Long, Integer> sortedMap, long targetKey, long tolerance) {
        Integer n;
        Long valueNearKey;
        Intrinsics.checkNotNullParameter(sortedMap, (String)"sortedMap");
        Set<Long> set = sortedMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Long l = valueNearKey = this.binarySearchWithTolerance(CollectionsKt.toList((Iterable)set), targetKey, tolerance);
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            n = sortedMap.get(it);
        } else {
            n = null;
        }
        return n;
    }

    private final Long binarySearchWithTolerance(List<Long> keys, long target, long tolerance) {
        int low = 0;
        int high = keys.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            long midValue = ((Number)keys.get(mid)).longValue();
            if (Math.abs(midValue - target) <= tolerance) {
                return keys.get(mid);
            }
            if (midValue < target) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return null;
    }
}

