/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.taskbased;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.taskbased.home.TaskHomeTabModel;
import com.android.tools.profilers.taskbased.pastrecordings.PastRecordingsTabModel;
import com.android.tools.profilers.taskbased.task.TaskGridModel;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.android.tools.profilers.tasks.taskhandlers.ProfilerTaskHandler;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u001fH$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011RQ\u0010\u0012\u001aB\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00150\u0015 \u0014* \u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00160\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lcom/android/tools/profilers/taskbased/TaskEntranceTabModel;", "", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;)V", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "ongoingSessionEndedObserver", "Lcom/android/tools/adtui/model/AspectObserver;", "taskGridModel", "Lcom/android/tools/profilers/taskbased/task/TaskGridModel;", "getTaskGridModel", "()Lcom/android/tools/profilers/taskbased/task/TaskGridModel;", "selectedTaskType", "Lcom/android/tools/profilers/tasks/ProfilerTaskType;", "getSelectedTaskType", "()Lcom/android/tools/profilers/tasks/ProfilerTaskType;", "taskHandlers", "", "kotlin.jvm.PlatformType", "Lcom/android/tools/profilers/tasks/taskhandlers/ProfilerTaskHandler;", "", "getTaskHandlers", "()Ljava/util/Map;", "sessionsManager", "Lcom/android/tools/profilers/sessions/SessionsManager;", "Lorg/jetbrains/annotations/NotNull;", "getSessionsManager", "()Lcom/android/tools/profilers/sessions/SessionsManager;", "updateProfilingProcessStartingPointDropdown", "", "onEnterTaskButtonClick", "doEnterTaskButton", "Companion", "intellij.android.profilers"})
public abstract class TaskEntranceTabModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final AspectObserver ongoingSessionEndedObserver;
    @NotNull
    private final TaskGridModel taskGridModel;
    @NotNull
    public static final String HIDE_NEW_TASK_PROMPT = "profilers.hide.new.task.prompt";

    public TaskEntranceTabModel(@NotNull StudioProfilers profilers) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        this.profilers = profilers;
        this.ongoingSessionEndedObserver = new AspectObserver();
        this.taskGridModel = new TaskGridModel();
    }

    @NotNull
    public final StudioProfilers getProfilers() {
        return this.profilers;
    }

    @NotNull
    public final TaskGridModel getTaskGridModel() {
        return this.taskGridModel;
    }

    @NotNull
    public final ProfilerTaskType getSelectedTaskType() {
        return (ProfilerTaskType)((Object)this.taskGridModel.getSelectedTaskType().getValue());
    }

    public final Map<ProfilerTaskType, ProfilerTaskHandler> getTaskHandlers() {
        return this.profilers.getTaskHandlers();
    }

    @NotNull
    public final SessionsManager getSessionsManager() {
        SessionsManager sessionsManager = this.profilers.getSessionsManager();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sessionsManager), (String)"getSessionsManager(...)");
        return sessionsManager;
    }

    public void updateProfilingProcessStartingPointDropdown() {
    }

    public void onEnterTaskButtonClick() {
        boolean isTaskOngoing = this.profilers.getSessionsManager().isSessionAlive();
        TaskEntranceTabModel taskEntranceTabModel = this;
        if (taskEntranceTabModel instanceof TaskHomeTabModel) {
            ((TaskHomeTabModel)this).disableStartButtonUntilPrevTaskStarts();
        } else if (taskEntranceTabModel instanceof PastRecordingsTabModel) {
            SessionItem sessionItem = ((PastRecordingsTabModel)this).getSelectedRecording();
            Intrinsics.checkNotNull((Object)sessionItem);
            Common.Session selectedSession = sessionItem.getSession();
            if (Intrinsics.areEqual((Object)selectedSession, (Object)this.profilers.getSession())) {
                this.profilers.openTaskTab();
                return;
            }
        }
        ProfilerTaskHandler currentTaskHandler = this.profilers.getCurrentTaskHandler();
        if (currentTaskHandler != null) {
            boolean confirm;
            String dialogTitle = isTaskOngoing ? "Confirm Termination of Ongoing Recording" : "Confirm Close of Currently Open Task";
            String dialogMsg = "Profiler displays only one task at this time. Starting a new task or opening a task recording will " + (isTaskOngoing ? "terminate your ongoing recording." : "close your currently open task.");
            boolean hidePrompt = this.profilers.getIdeServices().getPersistentProfilerPreferences().getBoolean(HIDE_NEW_TASK_PROMPT, false);
            boolean bl = confirm = hidePrompt || this.profilers.getIdeServices().openOkCancelDialog(dialogMsg, dialogTitle, arg_0 -> TaskEntranceTabModel.onEnterTaskButtonClick$lambda$0(this, arg_0));
            if (!confirm) {
                return;
            }
            if (isTaskOngoing) {
                this.getSessionsManager().addDependency(this.ongoingSessionEndedObserver).onChange((Enum)SessionAspect.ONGOING_SESSION_NEWLY_ENDED, () -> TaskEntranceTabModel.onEnterTaskButtonClick$lambda$1(this));
                currentTaskHandler.stopTask();
            } else {
                this.doEnterTaskButton();
            }
        } else {
            this.doEnterTaskButton();
        }
    }

    protected abstract void doEnterTaskButton();

    private static final void onEnterTaskButtonClick$lambda$0(TaskEntranceTabModel this$0, boolean doNotShow) {
        this$0.profilers.getIdeServices().getPersistentProfilerPreferences().setBoolean(HIDE_NEW_TASK_PROMPT, doNotShow);
    }

    private static final void onEnterTaskButtonClick$lambda$1(TaskEntranceTabModel this$0) {
        this$0.getSessionsManager().removeDependencies(this$0.ongoingSessionEndedObserver);
        this$0.doEnterTaskButton();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/profilers/taskbased/TaskEntranceTabModel$Companion;", "", "<init>", "()V", "HIDE_NEW_TASK_PROMPT", "", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

