/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.tasks.taskhandlers.singleartifact.memory;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.SupportLevel;
import com.android.tools.profilers.memory.HprofSessionArtifact;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.taskbased.home.StartTaskSelectionError;
import com.android.tools.profilers.tasks.args.TaskArgs;
import com.android.tools.profilers.tasks.args.singleartifact.memory.HeapDumpTaskArgs;
import com.android.tools.profilers.tasks.taskhandlers.singleartifact.memory.MemoryTaskHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0014J\u0014\u0010\u0012\u001a\u00020\u00102\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/profilers/tasks/taskhandlers/singleartifact/memory/HeapDumpTaskHandler;", "Lcom/android/tools/profilers/tasks/taskhandlers/singleartifact/memory/MemoryTaskHandler;", "sessionsManager", "Lcom/android/tools/profilers/sessions/SessionsManager;", "<init>", "(Lcom/android/tools/profilers/sessions/SessionsManager;)V", "startCapture", "", "stage", "Lcom/android/tools/profilers/memory/MainMemoryProfilerStage;", "stopCapture", "loadTask", "", "args", "Lcom/android/tools/profilers/tasks/args/TaskArgs;", "createStartTaskArgs", "Lcom/android/tools/profilers/tasks/args/singleartifact/memory/HeapDumpTaskArgs;", "isStartupTask", "createLoadingTaskArgs", "artifact", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "checkSupportForDeviceAndProcess", "Lcom/android/tools/profilers/taskbased/home/StartTaskSelectionError;", "device", "Lcom/android/tools/profiler/proto/Common$Device;", "process", "Lcom/android/tools/profiler/proto/Common$Process;", "supportsArtifact", "getTaskName", "", "intellij.android.profilers"})
public final class HeapDumpTaskHandler
extends MemoryTaskHandler {
    public HeapDumpTaskHandler(@NotNull SessionsManager sessionsManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionsManager), (String)"sessionsManager");
        super(sessionsManager);
    }

    @Override
    protected void startCapture(@NotNull MainMemoryProfilerStage stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        stage.startHeapDumpCapture();
    }

    @Override
    protected void stopCapture(@NotNull MainMemoryProfilerStage stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
    }

    @Override
    public boolean loadTask(@NotNull TaskArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!(args instanceof HeapDumpTaskArgs)) {
            this.handleError("The task arguments (TaskArgs) supplied are not of the expected type (HeapDumpTaskArgs)");
            return false;
        }
        HprofSessionArtifact heapDumpTaskArtifact = ((HeapDumpTaskArgs)args).getMemoryCaptureArtifact();
        if (heapDumpTaskArtifact == null) {
            this.handleError("The task arguments (HeapDumpTaskArgs) supplied do not contains a valid artifact to load");
            return false;
        }
        this.loadCapture(heapDumpTaskArtifact);
        return true;
    }

    @Override
    @NotNull
    protected HeapDumpTaskArgs createStartTaskArgs(boolean isStartupTask) {
        return new HeapDumpTaskArgs(false, null);
    }

    @Override
    @NotNull
    protected HeapDumpTaskArgs createLoadingTaskArgs(@NotNull SessionArtifact<?> artifact2) {
        Intrinsics.checkNotNullParameter(artifact2, (String)"artifact");
        return new HeapDumpTaskArgs(false, (HprofSessionArtifact)artifact2);
    }

    @Override
    @Nullable
    public StartTaskSelectionError checkSupportForDeviceAndProcess(@NotNull Common.Device device, @NotNull Common.Process process) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Common.Process.ExposureLevel exposureLevel = process.getExposureLevel();
        Intrinsics.checkNotNullExpressionValue((Object)exposureLevel, (String)"getExposureLevel(...)");
        boolean isFeatureSupported = SupportLevel.Companion.of(exposureLevel).isFeatureSupported(SupportLevel.Feature.MEMORY_HEAP_DUMP);
        if (isFeatureSupported) {
            return null;
        }
        return new StartTaskSelectionError(StartTaskSelectionError.StarTaskSelectionErrorCode.TASK_REQUIRES_DEBUGGABLE_PROCESS, null, 2, null);
    }

    @Override
    public boolean supportsArtifact(@Nullable SessionArtifact<?> artifact2) {
        return artifact2 instanceof HprofSessionArtifact;
    }

    @Override
    @NotNull
    public String getTaskName() {
        return "Heap Dump";
    }
}

