/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.tasks.taskhandlers.singleartifact.memory;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.SupportLevel;
import com.android.tools.profilers.memory.AllocationSessionArtifact;
import com.android.tools.profilers.memory.AllocationStage;
import com.android.tools.profilers.memory.LegacyAllocationsSessionArtifact;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.MemoryDataProvider;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.taskbased.home.StartTaskSelectionError;
import com.android.tools.profilers.taskbased.home.selections.deviceprocesses.ProcessListModel;
import com.android.tools.profilers.tasks.args.TaskArgs;
import com.android.tools.profilers.tasks.args.singleartifact.memory.AllocationsTaskArgs;
import com.android.tools.profilers.tasks.args.singleartifact.memory.JavaKotlinAllocationsTaskArgs;
import com.android.tools.profilers.tasks.args.singleartifact.memory.LegacyJavaKotlinAllocationsTaskArgs;
import com.android.tools.profilers.tasks.taskhandlers.singleartifact.memory.MemoryTaskHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0011H\u0014J*\u0010\u0016\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u00190\u00180\u00172\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0014J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\u00020\u00112\f\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0018H\u0016J\b\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006%"}, d2={"Lcom/android/tools/profilers/tasks/taskhandlers/singleartifact/memory/JavaKotlinAllocationsTaskHandler;", "Lcom/android/tools/profilers/tasks/taskhandlers/singleartifact/memory/MemoryTaskHandler;", "sessionsManager", "Lcom/android/tools/profilers/sessions/SessionsManager;", "<init>", "(Lcom/android/tools/profilers/sessions/SessionsManager;)V", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "Lorg/jetbrains/annotations/NotNull;", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "startCapture", "", "stage", "Lcom/android/tools/profilers/memory/MainMemoryProfilerStage;", "stopTask", "loadTask", "", "args", "Lcom/android/tools/profilers/tasks/args/TaskArgs;", "createStartTaskArgs", "isStartupTask", "createLoadingTaskArgs", "Lcom/android/tools/profilers/tasks/args/singleartifact/memory/AllocationsTaskArgs;", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "Lcom/android/tools/profiler/proto/Memory$AllocationsInfo;", "kotlin.jvm.PlatformType", "artifact", "checkSupportForDeviceAndProcess", "Lcom/android/tools/profilers/taskbased/home/StartTaskSelectionError;", "device", "Lcom/android/tools/profiler/proto/Common$Device;", "process", "Lcom/android/tools/profiler/proto/Common$Process;", "supportsArtifact", "getTaskName", "", "intellij.android.profilers"})
public final class JavaKotlinAllocationsTaskHandler
extends MemoryTaskHandler {
    @NotNull
    private final SessionsManager sessionsManager;

    public JavaKotlinAllocationsTaskHandler(@NotNull SessionsManager sessionsManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionsManager), (String)"sessionsManager");
        super(sessionsManager);
        this.sessionsManager = sessionsManager;
    }

    @NotNull
    public final StudioProfilers getProfilers() {
        StudioProfilers studioProfilers = this.sessionsManager.getStudioProfilers();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
        return studioProfilers;
    }

    @Override
    protected void startCapture(@NotNull MainMemoryProfilerStage stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        stage.startJavaKotlinAllocationCapture();
    }

    @Override
    public void stopTask() {
        block0: {
            block1: {
                ProcessListModel.ProfilerDeviceSelection profilerDeviceSelection = this.getProfilers().getTaskHomeTabModel().getSelectedDevice();
                if (profilerDeviceSelection == null || (profilerDeviceSelection = profilerDeviceSelection.getDevice()) == null) break block0;
                ProcessListModel.ProfilerDeviceSelection device = profilerDeviceSelection;
                boolean bl = false;
                if (device.getFeatureLevel() >= 26) break block1;
                if (!(this.getProfilers().getStage() instanceof MainMemoryProfilerStage)) break block0;
                Stage stage = this.getProfilers().getStage();
                Intrinsics.checkNotNull((Object)((Object)stage), (String)"null cannot be cast to non-null type com.android.tools.profilers.memory.MainMemoryProfilerStage");
                ((MainMemoryProfilerStage)stage).stopMemoryRecording();
                break block0;
            }
            if (!(this.getProfilers().getStage() instanceof AllocationStage)) break block0;
            Stage stage = this.getProfilers().getStage();
            Intrinsics.checkNotNull((Object)((Object)stage), (String)"null cannot be cast to non-null type com.android.tools.profilers.memory.AllocationStage");
            ((AllocationStage)stage).stopTracking();
        }
    }

    @Override
    public boolean loadTask(@NotNull TaskArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!(args instanceof LegacyJavaKotlinAllocationsTaskArgs) && !(args instanceof JavaKotlinAllocationsTaskArgs)) {
            this.handleError("The task arguments (TaskArgs) supplied are not of the expected type (JavaKotlinAllocationTaskArgs)");
            return false;
        }
        TaskArgs taskArgs = args;
        LegacyJavaKotlinAllocationsTaskArgs legacyJavaKotlinAllocationsTaskArgs = taskArgs instanceof LegacyJavaKotlinAllocationsTaskArgs ? (LegacyJavaKotlinAllocationsTaskArgs)taskArgs : null;
        AllocationsTaskArgs javaKotlinAllocationTaskArgs = legacyJavaKotlinAllocationsTaskArgs != null ? (AllocationsTaskArgs)legacyJavaKotlinAllocationsTaskArgs : (AllocationsTaskArgs)((JavaKotlinAllocationsTaskArgs)args);
        Object javaKotlinAllocationsTaskArtifact = javaKotlinAllocationTaskArgs.getAllocationSessionArtifact();
        if (javaKotlinAllocationsTaskArtifact == null) {
            this.handleError("The task arguments (AllocationsTaskArgs) supplied do not contains a valid artifact to load");
            return false;
        }
        this.loadCapture((SessionArtifact<?>)javaKotlinAllocationsTaskArtifact);
        return true;
    }

    @Override
    @NotNull
    protected TaskArgs createStartTaskArgs(boolean isStartupTask) {
        return MemoryDataProvider.Companion.getIsLiveAllocationTrackingSupported(this.getProfilers()) ? (TaskArgs)new JavaKotlinAllocationsTaskArgs(false, null) : (TaskArgs)new LegacyJavaKotlinAllocationsTaskArgs(false, null);
    }

    @Override
    @NotNull
    protected AllocationsTaskArgs<? extends SessionArtifact<Memory.AllocationsInfo>> createLoadingTaskArgs(@NotNull SessionArtifact<?> artifact2) {
        AllocationsTaskArgs allocationsTaskArgs;
        Intrinsics.checkNotNullParameter(artifact2, (String)"artifact");
        SessionArtifact<?> sessionArtifact = artifact2;
        if (sessionArtifact instanceof LegacyAllocationsSessionArtifact) {
            allocationsTaskArgs = new LegacyJavaKotlinAllocationsTaskArgs(false, (LegacyAllocationsSessionArtifact)artifact2);
        } else if (sessionArtifact instanceof AllocationSessionArtifact) {
            allocationsTaskArgs = new JavaKotlinAllocationsTaskArgs(false, (AllocationSessionArtifact)artifact2);
        } else {
            throw new IllegalStateException("Unexpected artifact type: " + artifact2);
        }
        return allocationsTaskArgs;
    }

    @Override
    @Nullable
    public StartTaskSelectionError checkSupportForDeviceAndProcess(@NotNull Common.Device device, @NotNull Common.Process process) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Common.Process.ExposureLevel exposureLevel = process.getExposureLevel();
        Intrinsics.checkNotNullExpressionValue((Object)exposureLevel, (String)"getExposureLevel(...)");
        boolean isFeatureSupported = SupportLevel.Companion.of(exposureLevel).isFeatureSupported(SupportLevel.Feature.MEMORY_JVM_RECORDING);
        if (isFeatureSupported) {
            return null;
        }
        return new StartTaskSelectionError(StartTaskSelectionError.StarTaskSelectionErrorCode.TASK_REQUIRES_DEBUGGABLE_PROCESS, null, 2, null);
    }

    @Override
    public boolean supportsArtifact(@Nullable SessionArtifact<?> artifact2) {
        return artifact2 instanceof AllocationSessionArtifact || artifact2 instanceof LegacyAllocationsSessionArtifact;
    }

    @Override
    @NotNull
    public String getTaskName() {
        return "Java/Kotlin Allocations";
    }
}

