/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.tasks.taskhandlers.singleartifact.memory;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.memory.HeapProfdSessionArtifact;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.taskbased.home.StartTaskSelectionError;
import com.android.tools.profilers.taskbased.home.TaskSelectionVerificationUtils;
import com.android.tools.profilers.tasks.args.TaskArgs;
import com.android.tools.profilers.tasks.args.singleartifact.memory.NativeAllocationsTaskArgs;
import com.android.tools.profilers.tasks.taskhandlers.singleartifact.memory.MemoryTaskHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0014J\u0014\u0010\u0012\u001a\u00020\u00102\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/profilers/tasks/taskhandlers/singleartifact/memory/NativeAllocationsTaskHandler;", "Lcom/android/tools/profilers/tasks/taskhandlers/singleartifact/memory/MemoryTaskHandler;", "sessionsManager", "Lcom/android/tools/profilers/sessions/SessionsManager;", "<init>", "(Lcom/android/tools/profilers/sessions/SessionsManager;)V", "startCapture", "", "stage", "Lcom/android/tools/profilers/memory/MainMemoryProfilerStage;", "stopCapture", "loadTask", "", "args", "Lcom/android/tools/profilers/tasks/args/TaskArgs;", "createStartTaskArgs", "Lcom/android/tools/profilers/tasks/args/singleartifact/memory/NativeAllocationsTaskArgs;", "isStartupTask", "createLoadingTaskArgs", "artifact", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "checkSupportForDeviceAndProcess", "Lcom/android/tools/profilers/taskbased/home/StartTaskSelectionError;", "device", "Lcom/android/tools/profiler/proto/Common$Device;", "process", "Lcom/android/tools/profiler/proto/Common$Process;", "supportsArtifact", "getTaskName", "", "intellij.android.profilers"})
public final class NativeAllocationsTaskHandler
extends MemoryTaskHandler {
    public NativeAllocationsTaskHandler(@NotNull SessionsManager sessionsManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionsManager), (String)"sessionsManager");
        super(sessionsManager);
    }

    @Override
    protected void startCapture(@NotNull MainMemoryProfilerStage stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        stage.startNativeAllocationCapture();
    }

    @Override
    protected void stopCapture(@NotNull MainMemoryProfilerStage stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        stage.stopMemoryRecording();
    }

    @Override
    public boolean loadTask(@NotNull TaskArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!(args instanceof NativeAllocationsTaskArgs)) {
            this.handleError("The task arguments (TaskArgs) supplied are not of the expected type (NativeAllocationsTaskArgs)");
            return false;
        }
        HeapProfdSessionArtifact nativeAllocationsTaskArtifact = ((NativeAllocationsTaskArgs)args).getMemoryCaptureArtifact();
        if (nativeAllocationsTaskArtifact == null) {
            this.handleError("The task arguments (NativeAllocationsTaskArgs) supplied do not contains a valid artifact to load");
            return false;
        }
        this.loadCapture(nativeAllocationsTaskArtifact);
        return true;
    }

    @Override
    @NotNull
    protected NativeAllocationsTaskArgs createStartTaskArgs(boolean isStartupTask) {
        return new NativeAllocationsTaskArgs(isStartupTask, null);
    }

    @Override
    @NotNull
    protected NativeAllocationsTaskArgs createLoadingTaskArgs(@NotNull SessionArtifact<?> artifact2) {
        Intrinsics.checkNotNullParameter(artifact2, (String)"artifact");
        return new NativeAllocationsTaskArgs(false, (HeapProfdSessionArtifact)artifact2);
    }

    @Override
    @Nullable
    public StartTaskSelectionError checkSupportForDeviceAndProcess(@NotNull Common.Device device, @NotNull Common.Process process) {
        boolean isDeviceSupported;
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        int requiredDeviceLevel = 29;
        boolean bl = isDeviceSupported = device.getFeatureLevel() >= requiredDeviceLevel;
        if (isDeviceSupported) {
            return null;
        }
        return new StartTaskSelectionError(StartTaskSelectionError.StarTaskSelectionErrorCode.TASK_FROM_NOW_USING_API_BELOW_MIN, TaskSelectionVerificationUtils.INSTANCE.getMinApiStartTaskErrorMessage(requiredDeviceLevel));
    }

    @Override
    public boolean supportsArtifact(@Nullable SessionArtifact<?> artifact2) {
        return artifact2 instanceof HeapProfdSessionArtifact;
    }

    @Override
    @NotNull
    public String getTaskName() {
        return "Native Allocations";
    }
}

