/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.io;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import trebuchet.io.DataSlice;
import trebuchet.io.DataSliceKt;
import trebuchet.io.StreamingReader;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00170\u0019J\u0016\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001e"}, d2={"Ltrebuchet/io/StreamingLineReader;", "", "maxLineLength", "", "stream", "Ltrebuchet/io/StreamingReader;", "<init>", "(ILtrebuchet/io/StreamingReader;)V", "getMaxLineLength", "()I", "getStream", "()Ltrebuchet/io/StreamingReader;", "tmpBuffer", "", "getTmpBuffer", "()[B", "tmpBufferSlice", "Ltrebuchet/io/DataSlice;", "getTmpBufferSlice", "()Ltrebuchet/io/DataSlice;", "tmpSlice", "getTmpSlice", "forEachLine", "", "lineCallback", "Lkotlin/Function1;", "findNewlineInWindow", "window", "Ltrebuchet/io/StreamingReader$Window;", "startIndex", "intellij.android.profilers.atrace"})
@SourceDebugExtension(value={"SMAP\nStreamingLineReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingLineReader.kt\ntrebuchet/io/StreamingLineReader\n+ 2 DataSlice.kt\ntrebuchet/io/DataSlice\n+ 3 StreamingReader.kt\ntrebuchet/io/StreamingReader$Window\n*L\n1#1,79:1\n36#2,2:80\n31#2:83\n71#3:82\n*S KotlinDebug\n*F\n+ 1 StreamingLineReader.kt\ntrebuchet/io/StreamingLineReader\n*L\n61#1:80,2\n75#1:83\n75#1:82\n*E\n"})
public final class StreamingLineReader {
    private final int maxLineLength;
    @NotNull
    private final StreamingReader stream;
    @NotNull
    private final byte[] tmpBuffer;
    @NotNull
    private final DataSlice tmpBufferSlice;
    @NotNull
    private final DataSlice tmpSlice;

    public StreamingLineReader(int maxLineLength, @NotNull StreamingReader stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.maxLineLength = maxLineLength;
        this.stream = stream;
        if (this.maxLineLength > this.stream.getKeepLoadedSize()) {
            throw new IllegalArgumentException("Cannot have a maxLineLength (" + this.maxLineLength + ") that's bigger than the StreamingReader's window size (" + this.stream.getKeepLoadedSize());
        }
        this.tmpBuffer = new byte[this.maxLineLength];
        this.tmpBufferSlice = DataSliceKt.asSlice$default(this.tmpBuffer, 0, 1, null);
        this.tmpSlice = new DataSlice();
    }

    public final int getMaxLineLength() {
        return this.maxLineLength;
    }

    @NotNull
    public final StreamingReader getStream() {
        return this.stream;
    }

    @NotNull
    public final byte[] getTmpBuffer() {
        return this.tmpBuffer;
    }

    @NotNull
    public final DataSlice getTmpBufferSlice() {
        return this.tmpBufferSlice;
    }

    @NotNull
    public final DataSlice getTmpSlice() {
        return this.tmpSlice;
    }

    /*
     * WARNING - void declaration
     */
    public final void forEachLine(@NotNull Function1<? super DataSlice, Unit> lineCallback) {
        Intrinsics.checkNotNullParameter(lineCallback, (String)"lineCallback");
        int lineStartIndex = this.stream.getStartIndex();
        while (true) {
            int lineEndIndexInclusive;
            StreamingReader.Window window;
            int index = lineStartIndex;
            int foundAt = -1;
            while ((index <= this.stream.getEndIndex() || this.stream.loadIndex(index)) && (foundAt = this.findNewlineInWindow(window = this.stream.windowFor(index), index)) == -1) {
                index = window.getGlobalEndIndex() + 1;
            }
            if (lineStartIndex > this.stream.getEndIndex()) {
                return;
            }
            if (foundAt == -1) {
                foundAt = this.stream.getEndIndex() + 1;
            }
            int nextStart = foundAt + 1;
            if (this.stream.get(foundAt - 1) == 13) {
                --foundAt;
            }
            if ((lineEndIndexInclusive = foundAt - 1) - lineStartIndex < this.maxLineLength) {
                StreamingReader.Window window2 = this.stream.windowFor(lineStartIndex);
                if (window2 == this.stream.windowFor(lineEndIndexInclusive)) {
                    void endIndex$iv;
                    void startIndex$iv;
                    void this_$iv;
                    void dest$iv;
                    DataSlice dataSlice = window2.getSlice();
                    int n = lineStartIndex - window2.getGlobalStartIndex();
                    int n2 = lineEndIndexInclusive - window2.getGlobalStartIndex() + 1;
                    DataSlice dataSlice2 = this.tmpSlice;
                    boolean $i$f$slice = false;
                    dest$iv.set(this_$iv.getBuffer(), this_$iv.getStartIndex() + startIndex$iv, this_$iv.getStartIndex() + endIndex$iv);
                    lineCallback.invoke((Object)dest$iv);
                } else {
                    this.stream.copyTo(this.tmpBuffer, lineStartIndex, lineEndIndexInclusive);
                    this.tmpBufferSlice.set(this.tmpBuffer, 0, lineEndIndexInclusive - lineStartIndex + 1);
                    lineCallback.invoke((Object)this.tmpBufferSlice);
                }
            }
            lineStartIndex = nextStart;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int findNewlineInWindow(@NotNull StreamingReader.Window window, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        int i = startIndex;
        int n = window.getGlobalEndIndex();
        if (i <= n) {
            while (true) {
                void this_$iv$iv;
                StreamingReader.Window this_$iv = window;
                boolean $i$f$get = false;
                DataSlice dataSlice = this_$iv.getSlice();
                int i$iv$iv = i - this_$iv.getGlobalStartIndex();
                boolean $i$f$get2 = false;
                if (this_$iv$iv.getBuffer()[this_$iv$iv.getStartIndex() + i$iv$iv] == 10) {
                    return i;
                }
                if (i == n) break;
                ++i;
            }
        }
        return -1;
    }
}

