/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.CpuModel;
import trebuchet.model.ProcessModel;
import trebuchet.model.fragments.CpuModelFragment;
import trebuchet.model.fragments.ModelFragment;
import trebuchet.model.fragments.ProcessModelFragment;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0006\u0010$\u001a\u00020%R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0011\u0010\u001c\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0017\u00a8\u0006&"}, d2={"Ltrebuchet/model/Model;", "", "fragments", "", "Ltrebuchet/model/fragments/ModelFragment;", "<init>", "(Ljava/lang/Iterable;)V", "fragment", "(Ltrebuchet/model/fragments/ModelFragment;)V", "processes", "", "", "Ltrebuchet/model/ProcessModel;", "getProcesses", "()Ljava/util/Map;", "cpus", "", "Ltrebuchet/model/CpuModel;", "getCpus", "()Ljava/util/List;", "beginTimestamp", "", "getBeginTimestamp", "()D", "endTimestamp", "getEndTimestamp", "parentTimestamp", "getParentTimestamp", "parentTimestampBootTime", "getParentTimestampBootTime", "realtimeTimestamp", "", "getRealtimeTimestamp", "()J", "duration", "getDuration", "isEmpty", "", "intellij.android.profilers.atrace"})
@SourceDebugExtension(value={"SMAP\nModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Model.kt\ntrebuchet/model/Model\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1863#2:94\n1863#2,2:95\n1863#2,2:97\n1864#2:99\n1010#2,2:100\n*S KotlinDebug\n*F\n+ 1 Model.kt\ntrebuchet/model/Model\n*L\n63#1:94\n70#1:95,2\n76#1:97,2\n63#1:99\n80#1:100,2\n*E\n"})
public final class Model {
    @NotNull
    private final Map<Integer, ProcessModel> processes;
    @NotNull
    private final List<CpuModel> cpus;
    private final double beginTimestamp;
    private final double endTimestamp;
    private final double parentTimestamp;
    private final double parentTimestampBootTime;
    private final long realtimeTimestamp;

    public Model(@NotNull Iterable<ModelFragment> fragments) {
        Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
        Map processBuilder = new LinkedHashMap();
        List cpuBuilder = new ArrayList();
        double beginTimestamp = 0.0;
        beginTimestamp = Double.MAX_VALUE;
        double endTimestamp = 0.0;
        double parentTimestamp = 0.0;
        double parentTimestampBootTime = 0.0;
        long realtimeTimestamp = 0L;
        Iterable<ModelFragment> $this$forEach$iv = fragments;
        boolean $i$f$forEach = false;
        Iterator<ModelFragment> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object it;
            ModelFragment element$iv;
            ModelFragment it2 = element$iv = iterator.next();
            boolean bl = false;
            it2.autoCloseOpenSlices();
            beginTimestamp = Math.min(beginTimestamp, it2.getGlobalStartTime());
            endTimestamp = Math.max(endTimestamp, it2.getGlobalEndTime());
            parentTimestamp = Math.max(parentTimestamp, it2.getParentTimestamp());
            parentTimestampBootTime = Math.max(parentTimestampBootTime, it2.getParentTimestampBootTime());
            realtimeTimestamp = Math.max(realtimeTimestamp, it2.getRealtimeTimestamp());
            Iterable $this$forEach$iv2 = it2.getProcesses();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (ProcessModelFragment)element$iv2;
                boolean bl2 = false;
                if (((ProcessModelFragment)it).getId() == -1) continue;
                processBuilder.put(((ProcessModelFragment)it).getId(), new ProcessModel(this, (ProcessModelFragment)it));
            }
            $this$forEach$iv2 = it2.getCpus();
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (CpuModelFragment)element$iv2;
                boolean bl3 = false;
                cpuBuilder.add(new CpuModel(this, (CpuModelFragment)it));
            }
        }
        List $this$sortBy$iv = cpuBuilder;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CpuModel it = (CpuModel)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getId());
                    it = (CpuModel)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getId()));
                }
            });
        }
        this.processes = processBuilder;
        this.cpus = cpuBuilder;
        this.beginTimestamp = Math.min(beginTimestamp, endTimestamp);
        this.endTimestamp = endTimestamp;
        this.parentTimestamp = parentTimestamp;
        this.parentTimestampBootTime = parentTimestampBootTime;
        this.realtimeTimestamp = realtimeTimestamp;
    }

    @NotNull
    public final Map<Integer, ProcessModel> getProcesses() {
        return this.processes;
    }

    @NotNull
    public final List<CpuModel> getCpus() {
        return this.cpus;
    }

    public final double getBeginTimestamp() {
        return this.beginTimestamp;
    }

    public final double getEndTimestamp() {
        return this.endTimestamp;
    }

    public final double getParentTimestamp() {
        return this.parentTimestamp;
    }

    public final double getParentTimestampBootTime() {
        return this.parentTimestampBootTime;
    }

    public final long getRealtimeTimestamp() {
        return this.realtimeTimestamp;
    }

    public final double getDuration() {
        return this.endTimestamp - this.beginTimestamp;
    }

    public Model(@NotNull ModelFragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this(CollectionsKt.listOf((Object)fragment));
    }

    public final boolean isEmpty() {
        return this.processes.isEmpty();
    }
}

