/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.CompilerArguments;
import android.databinding.tool.LibTypes;
import android.databinding.tool.ext.ExtKt;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.SdkUtil;
import android.databinding.tool.reflection.TypeUtil;
import android.databinding.tool.reflection.annotation.AnnotationAnalyzer;
import android.databinding.tool.reflection.annotation.AnnotationLogger;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.util.GenerationalClassUtil;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Resources;
import android.databinding.tool.util.SymbolTableUtil;
import javax.annotation.processing.ProcessingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u00104\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u0004\u0018\u00010\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00108\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0003\u001a\u0004\b\u0016\u0010\u0017R*\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00188\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0003\u001a\u0004\b\u001b\u0010\u001cR*\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0013\u001a\u0004\u0018\u00010\u001d8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u0003\u001a\u0004\b \u0010!R*\u0010#\u001a\u0004\u0018\u00010\"2\b\u0010\u0013\u001a\u0004\u0018\u00010\"8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b$\u0010\u0003\u001a\u0004\b%\u0010&R*\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00128\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b'\u0010\u0003\u001a\u0004\b(\u0010)R*\u0010+\u001a\u0004\u0018\u00010*2\b\u0010\u0013\u001a\u0004\u0018\u00010*8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b,\u0010\u0003\u001a\u0004\b-\u0010.R&\u00100\u001a\u00020/2\u0006\u0010\u0013\u001a\u00020/8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b1\u0010\u0003\u001a\u0004\b2\u00103\u00a8\u00065"}, d2={"Landroid/databinding/tool/Context;", "", "<init>", "()V", "logger", "Landroid/databinding/tool/reflection/annotation/AnnotationLogger;", "init", "", "processingEnvironment", "Ljavax/annotation/processing/ProcessingEnvironment;", "args", "Landroid/databinding/tool/CompilerArguments;", "discoverAndroidX", "", "initForTests", "modelAnayzer", "Landroid/databinding/tool/reflection/ModelAnalyzer;", "sdkUtil", "Landroid/databinding/tool/reflection/SdkUtil;", "value", "modelAnalyzer", "getModelAnalyzer$annotations", "getModelAnalyzer", "()Landroid/databinding/tool/reflection/ModelAnalyzer;", "Landroid/databinding/tool/store/SetterStore;", "setterStore", "getSetterStore$annotations", "getSetterStore", "()Landroid/databinding/tool/store/SetterStore;", "Landroid/databinding/tool/util/GenerationalClassUtil;", "generationalClassUtil", "getGenerationalClassUtil$annotations", "getGenerationalClassUtil", "()Landroid/databinding/tool/util/GenerationalClassUtil;", "Landroid/databinding/tool/reflection/TypeUtil;", "typeUtil", "getTypeUtil$annotations", "getTypeUtil", "()Landroid/databinding/tool/reflection/TypeUtil;", "getSdkUtil$annotations", "getSdkUtil", "()Landroid/databinding/tool/reflection/SdkUtil;", "Landroid/databinding/tool/LibTypes;", "libTypes", "getLibTypes$annotations", "getLibTypes", "()Landroid/databinding/tool/LibTypes;", "Landroid/databinding/tool/util/Resources;", "resources", "getResources$annotations", "getResources", "()Landroid/databinding/tool/util/Resources;", "fullClear", "db-compiler"})
public final class Context {
    @NotNull
    public static final Context INSTANCE = new Context();
    @NotNull
    private static final AnnotationLogger logger = new AnnotationLogger();
    @Nullable
    private static ModelAnalyzer modelAnalyzer;
    @Nullable
    private static SetterStore setterStore;
    @Nullable
    private static GenerationalClassUtil generationalClassUtil;
    @Nullable
    private static TypeUtil typeUtil;
    @Nullable
    private static SdkUtil sdkUtil;
    @Nullable
    private static LibTypes libTypes;
    @NotNull
    private static Resources resources;

    private Context() {
    }

    @JvmStatic
    public static final void init(@NotNull ProcessingEnvironment processingEnvironment, @NotNull CompilerArguments args) {
        Intrinsics.checkNotNullParameter((Object)processingEnvironment, (String)"processingEnvironment");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        L.setClient(logger);
        boolean hasAndroidXBinding = INSTANCE.discoverAndroidX(processingEnvironment);
        libTypes = new LibTypes(hasAndroidXBinding);
        generationalClassUtil = GenerationalClassUtil.Companion.create(args);
        modelAnalyzer = new AnnotationAnalyzer(processingEnvironment, libTypes);
        ModelAnalyzer modelAnalyzer = Context.modelAnalyzer;
        Intrinsics.checkNotNull((Object)modelAnalyzer);
        typeUtil = modelAnalyzer.createTypeUtil();
        setterStore = SetterStore.create(Context.modelAnalyzer, generationalClassUtil);
        sdkUtil = SdkUtil.create(args.getApiFile(), args.getMinApi());
        resources = SymbolTableUtil.parseRTxtFiles(args.getLocalR(), args.getDependenciesRFiles(), args.getMergedDependenciesRFile());
    }

    private final boolean discoverAndroidX(ProcessingEnvironment processingEnvironment) {
        boolean hasAndroidXBinding;
        boolean hasSupportBinding = processingEnvironment.getElementUtils().getTypeElement("android.databinding.Observable") != null;
        boolean bl = hasAndroidXBinding = processingEnvironment.getElementUtils().getTypeElement("androidx.databinding.Observable") != null;
        if (hasAndroidXBinding && hasSupportBinding) {
            L.e("AndroidX Error: Both old and new data binding packages are available in dependencies. Make sure you've setup jettifier  for any data binding dependencies and also set android.useAndroidx in your gradle.properties file.", new Object[0]);
        }
        return hasAndroidXBinding;
    }

    @JvmStatic
    public static final void initForTests(@NotNull ModelAnalyzer modelAnayzer, @NotNull SdkUtil sdkUtil) {
        Intrinsics.checkNotNullParameter((Object)modelAnayzer, (String)"modelAnayzer");
        Intrinsics.checkNotNullParameter((Object)sdkUtil, (String)"sdkUtil");
        modelAnalyzer = modelAnayzer;
        Context.sdkUtil = sdkUtil;
        ModelAnalyzer modelAnalyzer = Context.modelAnalyzer;
        Intrinsics.checkNotNull((Object)modelAnalyzer);
        typeUtil = modelAnalyzer.createTypeUtil();
    }

    @Nullable
    public static final ModelAnalyzer getModelAnalyzer() {
        return modelAnalyzer;
    }

    @JvmStatic
    public static /* synthetic */ void getModelAnalyzer$annotations() {
    }

    @Nullable
    public static final SetterStore getSetterStore() {
        return setterStore;
    }

    @JvmStatic
    public static /* synthetic */ void getSetterStore$annotations() {
    }

    @Nullable
    public static final GenerationalClassUtil getGenerationalClassUtil() {
        return generationalClassUtil;
    }

    @JvmStatic
    public static /* synthetic */ void getGenerationalClassUtil$annotations() {
    }

    @Nullable
    public static final TypeUtil getTypeUtil() {
        return typeUtil;
    }

    @JvmStatic
    public static /* synthetic */ void getTypeUtil$annotations() {
    }

    @Nullable
    public static final SdkUtil getSdkUtil() {
        return sdkUtil;
    }

    @JvmStatic
    public static /* synthetic */ void getSdkUtil$annotations() {
    }

    @Nullable
    public static final LibTypes getLibTypes() {
        return libTypes;
    }

    @JvmStatic
    public static /* synthetic */ void getLibTypes$annotations() {
    }

    @NotNull
    public static final Resources getResources() {
        return resources;
    }

    @JvmStatic
    public static /* synthetic */ void getResources$annotations() {
    }

    @JvmStatic
    public static final void fullClear(@NotNull ProcessingEnvironment processingEnvironment) {
        Intrinsics.checkNotNullParameter((Object)processingEnvironment, (String)"processingEnvironment");
        logger.flushMessages(processingEnvironment);
        modelAnalyzer = null;
        setterStore = null;
        generationalClassUtil = null;
        typeUtil = null;
        sdkUtil = null;
        libTypes = null;
        resources = SymbolTableUtil.getEMPTY_RESOURCES();
        L.setClient(null);
        ExtKt.cleanLazyProps();
    }

    static {
        resources = SymbolTableUtil.getEMPTY_RESOURCES();
    }
}

