/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator;

import com.google.archivepatcher.generator.MinimalZipEntry;
import com.google.archivepatcher.generator.Recommendation;
import com.google.archivepatcher.generator.RecommendationReason;

public class QualifiedRecommendation {
    private final MinimalZipEntry oldEntry;
    private final MinimalZipEntry newEntry;
    private final Recommendation recommendation;
    private final RecommendationReason reason;

    public QualifiedRecommendation(MinimalZipEntry oldEntry, MinimalZipEntry newEntry, Recommendation recommendation, RecommendationReason reason) {
        this.oldEntry = oldEntry;
        this.newEntry = newEntry;
        this.recommendation = recommendation;
        this.reason = reason;
    }

    public MinimalZipEntry getOldEntry() {
        return this.oldEntry;
    }

    public MinimalZipEntry getNewEntry() {
        return this.newEntry;
    }

    public Recommendation getRecommendation() {
        return this.recommendation;
    }

    public RecommendationReason getReason() {
        return this.reason;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.newEntry == null ? 0 : this.newEntry.hashCode());
        result = 31 * result + (this.oldEntry == null ? 0 : this.oldEntry.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.recommendation == null ? 0 : this.recommendation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedRecommendation other = (QualifiedRecommendation)obj;
        if (this.newEntry == null ? other.newEntry != null : !this.newEntry.equals(other.newEntry)) {
            return false;
        }
        if (this.oldEntry == null ? other.oldEntry != null : !this.oldEntry.equals(other.oldEntry)) {
            return false;
        }
        if (this.reason != other.reason) {
            return false;
        }
        return this.recommendation == other.recommendation;
    }

    public String toString() {
        return "QualifiedRecommendation [oldEntry=" + this.oldEntry.getFileName() + ", newEntry=" + this.newEntry.getFileName() + ", recommendation=" + (Object)((Object)this.recommendation) + ", reason=" + (Object)((Object)this.reason) + "]";
    }
}

