/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator;

import com.google.archivepatcher.generator.QualifiedRecommendation;
import com.google.archivepatcher.generator.Recommendation;
import com.google.archivepatcher.generator.RecommendationModifier;
import com.google.archivepatcher.generator.RecommendationReason;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TotalRecompressionLimiter
implements RecommendationModifier {
    private final long maxBytesToRecompress;
    private static final Comparator<QualifiedRecommendation> COMPARATOR = new UncompressedNewEntrySizeComparator();

    public TotalRecompressionLimiter(long maxBytesToRecompress) {
        if (maxBytesToRecompress < 0L) {
            throw new IllegalArgumentException("maxBytesToRecompress must be non-negative: " + maxBytesToRecompress);
        }
        this.maxBytesToRecompress = maxBytesToRecompress;
    }

    @Override
    public List<QualifiedRecommendation> getModifiedRecommendations(File oldFile, File newFile, List<QualifiedRecommendation> originalRecommendations) {
        ArrayList<QualifiedRecommendation> sorted = new ArrayList<QualifiedRecommendation>(originalRecommendations);
        Collections.sort(sorted, COMPARATOR);
        Collections.reverse(sorted);
        ArrayList<QualifiedRecommendation> result = new ArrayList<QualifiedRecommendation>(sorted.size());
        long recompressibleBytesRemaining = this.maxBytesToRecompress;
        for (QualifiedRecommendation originalRecommendation : sorted) {
            if (!originalRecommendation.getRecommendation().uncompressNewEntry) {
                result.add(originalRecommendation);
                continue;
            }
            long bytesToRecompress = originalRecommendation.getNewEntry().getUncompressedSize();
            if (recompressibleBytesRemaining - bytesToRecompress >= 0L) {
                result.add(originalRecommendation);
                recompressibleBytesRemaining -= bytesToRecompress;
                continue;
            }
            result.add(new QualifiedRecommendation(originalRecommendation.getOldEntry(), originalRecommendation.getNewEntry(), Recommendation.UNCOMPRESS_NEITHER, RecommendationReason.RESOURCE_CONSTRAINED));
        }
        return result;
    }

    private static class UncompressedNewEntrySizeComparator
    implements Comparator<QualifiedRecommendation> {
        private UncompressedNewEntrySizeComparator() {
        }

        @Override
        public int compare(QualifiedRecommendation qr1, QualifiedRecommendation qr2) {
            return Long.compare(qr1.getNewEntry().getUncompressedSize(), qr2.getNewEntry().getUncompressedSize());
        }
    }
}

