/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator.bsdiff;

import com.google.archivepatcher.generator.bsdiff.BsUtil;
import com.google.archivepatcher.generator.bsdiff.RandomAccessObject;
import java.io.IOException;

class BsDiff {
    BsDiff() {
    }

    static int lengthOfMatch(RandomAccessObject oldData, int oldStart, RandomAccessObject newData, int newStart) throws IOException {
        int max = Math.min((int)oldData.length() - oldStart, (int)newData.length() - newStart);
        if (max > 0) {
            oldData.seek(oldStart);
            newData.seek(newStart);
            for (int offset = 0; offset < max; ++offset) {
                if (oldData.readByte() == newData.readByte()) continue;
                return offset;
            }
        }
        return max;
    }

    static Match searchForMatchBaseCase(RandomAccessObject groupArray, RandomAccessObject oldData, RandomAccessObject newData, int newStart, int oldDataRangeStartA, int oldDataRangeStartB) throws IOException {
        groupArray.seekToIntAligned(oldDataRangeStartA);
        int groupArrayOldDataRangeStartA = groupArray.readInt();
        int lengthOfMatchA = BsDiff.lengthOfMatch(oldData, groupArrayOldDataRangeStartA, newData, newStart);
        groupArray.seekToIntAligned(oldDataRangeStartB);
        int groupArrayOldDataRangeStartB = groupArray.readInt();
        int lengthOfMatchB = BsDiff.lengthOfMatch(oldData, groupArrayOldDataRangeStartB, newData, newStart);
        if (lengthOfMatchA > lengthOfMatchB) {
            return Match.of(groupArrayOldDataRangeStartA, lengthOfMatchA);
        }
        return Match.of(groupArrayOldDataRangeStartB, lengthOfMatchB);
    }

    static Match searchForMatch(RandomAccessObject groupArray, RandomAccessObject oldData, RandomAccessObject newData, int newStart, int oldDataRangeStartA, int oldDataRangeStartB) throws IOException {
        if (oldDataRangeStartB - oldDataRangeStartA < 2) {
            return BsDiff.searchForMatchBaseCase(groupArray, oldData, newData, newStart, oldDataRangeStartA, oldDataRangeStartB);
        }
        int rangeLength = oldDataRangeStartB - oldDataRangeStartA;
        int pivot = oldDataRangeStartA + rangeLength / 2;
        groupArray.seekToIntAligned(pivot);
        int groupArrayPivot = groupArray.readInt();
        if (BsUtil.lexicographicalCompare(oldData, groupArrayPivot, (int)oldData.length() - groupArrayPivot, newData, newStart, (int)newData.length() - newStart) < 0) {
            return BsDiff.searchForMatch(groupArray, oldData, newData, newStart, pivot, oldDataRangeStartB);
        }
        return BsDiff.searchForMatch(groupArray, oldData, newData, newStart, oldDataRangeStartA, pivot);
    }

    static class Match {
        final int start;
        final int length;

        static Match of(int start, int length) {
            return new Match(start, length);
        }

        private Match(int start, int length) {
            this.start = start;
            this.length = length;
        }
    }
}

