/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator.bsdiff;

import com.google.archivepatcher.generator.bsdiff.RandomAccessObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class BsUtil {
    private static final long NEGATIVE_MASK = Long.MIN_VALUE;

    BsUtil() {
    }

    static void writeFormattedLong(long value, OutputStream outputStream) throws IOException {
        long y = value;
        if (y < 0L) {
            y = -y | Long.MIN_VALUE;
        }
        for (int i = 0; i < 8; ++i) {
            outputStream.write((byte)(y & 0xFFL));
            y >>>= 8;
        }
    }

    static long readFormattedLong(InputStream inputStream) throws IOException {
        long result = 0L;
        for (int bitshift = 0; bitshift < 64; bitshift += 8) {
            result |= (long)inputStream.read() << bitshift;
        }
        if (result - Long.MIN_VALUE > 0L) {
            result = (result & Long.MAX_VALUE) * -1L;
        }
        return result;
    }

    static int lexicographicalCompare(RandomAccessObject data1, int start1, int length1, RandomAccessObject data2, int start2, int length2) throws IOException {
        int bytesLeft = Math.min(length1, length2);
        data1.seek(start1);
        data2.seek(start2);
        while (bytesLeft-- > 0) {
            int i2;
            int i1 = data1.readUnsignedByte();
            if (i1 == (i2 = data2.readUnsignedByte())) continue;
            return i1 - i2;
        }
        return length1 - length2;
    }
}

