/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.gct.login.CancellableServerReceiver;
import com.google.gct.login.GoogleLoginUtils;
import com.google.gct.login.RequestCancelledException;
import com.google.gct.login.common.UiFacade;
import com.google.gct.login.common.VerificationCodeHolder;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import icons.GoogleLoginIcons;
import java.io.IOException;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u001c\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00032\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/google/gct/login/AndroidUiFacade;", "Lcom/google/gct/login/common/UiFacade;", "clientId", "", "<init>", "(Ljava/lang/String;)V", "receiver", "Lcom/google/gct/login/CancellableServerReceiver;", "stop", "", "obtainVerificationCodeFromExternalUserInteraction", "Lcom/google/gct/login/common/VerificationCodeHolder;", "title", "scopes", "", "showErrorDialog", "message", "logErrorAndDisplayDialog", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "askYesOrNo", "", "notifyStatusIndicator", "google-login-as"})
@SourceDebugExtension(value={"SMAP\nAndroidUiFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidUiFacade.kt\ncom/google/gct/login/AndroidUiFacade\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n1#2:93\n24#3:94\n*S KotlinDebug\n*F\n+ 1 AndroidUiFacade.kt\ncom/google/gct/login/AndroidUiFacade\n*L\n77#1:94\n*E\n"})
public final class AndroidUiFacade
implements UiFacade {
    @NotNull
    private final String clientId;
    @Nullable
    private volatile CancellableServerReceiver receiver;

    public AndroidUiFacade(@NotNull String clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        this.clientId = clientId;
    }

    @Override
    public void stop() {
        try {
            CancellableServerReceiver cancellableServerReceiver = this.receiver;
            if (cancellableServerReceiver != null) {
                cancellableServerReceiver.stop();
            }
        }
        catch (IOException e) {
            this.logErrorAndDisplayDialog("Google Login", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public VerificationCodeHolder obtainVerificationCodeFromExternalUserInteraction(@Nullable String title, @NotNull Collection<String> scopes) {
        String string;
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        CancellableServerReceiver cancellableServerReceiver = new CancellableServerReceiver();
        Object it = cancellableServerReceiver;
        boolean bl = false;
        this.receiver = it;
        CancellableServerReceiver serverReceiver = cancellableServerReceiver;
        try {
            it = serverReceiver.getRedirectUri();
        }
        catch (IOException e) {
            String string2 = title;
            if (string2 == null) {
                string2 = "Google Login";
            }
            this.logErrorAndDisplayDialog(string2, e);
            return null;
        }
        Object redirectUrl = it;
        AuthorizationCodeRequestUrl authCodeRequestUrl = new AuthorizationCodeRequestUrl("https://accounts.google.com/o/oauth2/auth", this.clientId).setRedirectUri((String)redirectUrl).setScopes(scopes);
        BrowserUtil.browse((String)authCodeRequestUrl.build());
        try {
            string = serverReceiver.waitForCode();
        }
        catch (RequestCancelledException e) {
            VerificationCodeHolder verificationCodeHolder = null;
            return verificationCodeHolder;
        }
        catch (IOException e) {
            String string3 = title;
            if (string3 == null) {
                string3 = "Google Login";
            }
            this.logErrorAndDisplayDialog(string3, e);
            VerificationCodeHolder verificationCodeHolder = null;
            return verificationCodeHolder;
        }
        finally {
            this.receiver = null;
        }
        String verificationCode = string;
        return new VerificationCodeHolder(verificationCode, (String)redirectUrl);
    }

    @Override
    public void showErrorDialog(@NotNull String title, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        GoogleLoginUtils.showErrorDialog(message, title);
    }

    private final void logErrorAndDisplayDialog(String title, Exception exception) {
        AndroidUiFacade $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AndroidUiFacade.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn(exception.getMessage(), (Throwable)exception);
        String string = exception.getMessage();
        if (string == null) {
            string = "Unknown error";
        }
        GoogleLoginUtils.showErrorDialog(string, title);
    }

    @Override
    public boolean askYesOrNo(@NotNull String title, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object updatedMessage = message;
        if (Intrinsics.areEqual((Object)message, (Object)"Are you sure you want to sign out?")) {
            updatedMessage = (String)updatedMessage + " This will sign out all logged in users.";
        }
        return Messages.showYesNoDialog((String)updatedMessage, (String)title, (Icon)GoogleLoginIcons.GOOGLE_FAVICON) == 0;
    }

    @Override
    public void notifyStatusIndicator() {
    }
}

