/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.util.Throwables;
import com.google.gct.login.RequestCancelledException;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;

class CancellableServerReceiver
implements VerificationCodeReceiver {
    private static final String CALLBACK_PATH = "/Callback";
    public static final String REQUEST_CANCELLED_STRING = "Request cancelled.";
    private Server server;
    String code;
    String error;
    final Lock lock = new ReentrantLock();
    final Condition gotAuthorizationResponse = this.lock.newCondition();
    private int port;
    private final String host;

    public CancellableServerReceiver() {
        this("localhost", -1);
    }

    CancellableServerReceiver(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getRedirectUri() throws IOException {
        if (this.port == -1) {
            this.port = CancellableServerReceiver.getUnusedPort();
        }
        this.server = new Server(this.port);
        for (Connector c : this.server.getConnectors()) {
            c.setHost(this.host);
        }
        this.server.addHandler((Handler)new CallbackHandler());
        try {
            this.server.start();
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new IOException(e);
        }
        return "http://" + this.host + ":" + this.port + CALLBACK_PATH;
    }

    public String waitForCode() throws IOException {
        this.lock.lock();
        try {
            while (this.code == null && this.error == null) {
                this.gotAuthorizationResponse.awaitUninterruptibly();
            }
            if (this.error != null) {
                if (this.error.equals(REQUEST_CANCELLED_STRING) || this.error.equals("access_denied")) {
                    throw new RequestCancelledException();
                }
                throw new IOException("User authorization failed (" + this.error + ")");
            }
            String string = this.code;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() throws IOException {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e);
                throw new IOException(e);
            }
            this.lock.lock();
            try {
                this.error = REQUEST_CANCELLED_STRING;
                this.code = null;
                this.gotAuthorizationResponse.signal();
            }
            finally {
                this.lock.unlock();
            }
            this.server = null;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    private static int getUnusedPort() throws IOException {
        try (Socket s = new Socket();){
            s.bind(null);
            int n = s.getLocalPort();
            return n;
        }
    }

    class CallbackHandler
    extends AbstractHandler {
        private static final String AUTH_SUCCESS_LANDING_PAGE = "https://developer.android.com/studio/login.html?success=true";
        private static final String AUTH_FAILURE_LANDING_PAGE = "https://developer.android.com/studio/login.html?success=false";

        CallbackHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException {
            if (!CancellableServerReceiver.CALLBACK_PATH.equals(target)) {
                return;
            }
            ((Request)request).setHandled(true);
            CancellableServerReceiver.this.lock.lock();
            try {
                CancellableServerReceiver.this.error = request.getParameter("error");
                CancellableServerReceiver.this.code = request.getParameter("code");
                CancellableServerReceiver.this.gotAuthorizationResponse.signal();
            }
            finally {
                CancellableServerReceiver.this.lock.unlock();
            }
            response.sendRedirect(CancellableServerReceiver.this.error == null ? AUTH_SUCCESS_LANDING_PAGE : AUTH_FAILURE_LANDING_PAGE);
            response.flushBuffer();
        }
    }

    public static final class Builder {
        private String host = "localhost";
        private int port = -1;

        public CancellableServerReceiver build() {
            return new CancellableServerReceiver(this.host, this.port);
        }

        public String getHost() {
            return this.host;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }
    }
}

