/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLoginPrefsKt;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CredentialedUserRoster {
    private final LinkedHashMap<String, CredentialedUser> myAllUsers = new LinkedHashMap();
    private CredentialedUser myActiveUser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public LinkedHashMap<String, CredentialedUser> getAllUsers() {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            return new LinkedHashMap<String, CredentialedUser>(this.myAllUsers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CredentialedUser getActiveUser() {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            return this.myActiveUser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveUser(@NotNull String userEmail) throws IllegalArgumentException {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            if (!this.myAllUsers.containsKey(userEmail)) {
                throw new IllegalArgumentException(userEmail + " is not a logged in user.");
            }
            if (this.myActiveUser != null) {
                this.myActiveUser.isActive = false;
            }
            this.myActiveUser = this.myAllUsers.get(userEmail);
            this.myActiveUser.isActive = true;
            GoogleLoginPrefsKt.getInstance().saveActiveUser(userEmail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveUser() {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            if (this.myActiveUser != null) {
                this.myActiveUser.isActive = false;
                this.myActiveUser = null;
                GoogleLoginPrefsKt.getInstance().removeActiveUser();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(CredentialedUser user) {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            this.myAllUsers.put(user.email, user);
            this.setActiveUser(user.email);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUser(String userEmail) {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            if (!this.myAllUsers.containsKey(userEmail)) {
                return false;
            }
            if (this.myActiveUser.email.equals(userEmail)) {
                this.myActiveUser = null;
                GoogleLoginPrefsKt.getInstance().removeActiveUser();
            }
            this.myAllUsers.remove(userEmail);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllUsers() {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            this.myAllUsers.clear();
            this.myActiveUser = null;
            GoogleLoginPrefsKt.getInstance().removeAllUsers();
        }
    }
}

