/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Userinfo;
import com.google.gct.login.GoogleAccountClient;
import com.google.gct.login.GoogleLoginUtils;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Image;
import java.io.IOException;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/google/gct/login/GoogleAccountClientImpl;", "Lcom/google/gct/login/GoogleAccountClient;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getUserPicture", "Ljava/awt/Image;", "userInfo", "Lcom/google/api/services/oauth2/model/Userinfo;", "getUserInfo", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "google-login-as"})
public final class GoogleAccountClientImpl
implements GoogleAccountClient {
    @NotNull
    private final Logger LOG;

    public GoogleAccountClientImpl() {
        Logger logger = Logger.getInstance(GoogleLoginUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
    }

    @Override
    @Nullable
    public Image getUserPicture(@NotNull Userinfo userInfo) {
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        return ImageIO.read(GoogleLoginUtils.appendSizeParameter(userInfo.getPicture()));
    }

    @Override
    @Nullable
    public Userinfo getUserInfo(@NotNull Credential credential) {
        Userinfo userinfo;
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        Oauth2 userInfoService = new Oauth2.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new GsonFactory(), (HttpRequestInitializer)credential).setApplicationName("Android Studio").build();
        try {
            userinfo = (Userinfo)userInfoService.userinfo().get().execute();
        }
        catch (IOException e) {
            this.LOG.warn("Error retrieving user information.", (Throwable)e);
            userinfo = null;
        }
        return userinfo;
    }
}

