/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.services.oauth2.model.Userinfo;
import com.google.gct.login.AndroidUiFacade;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.CredentialedUserRoster;
import com.google.gct.login.GoogleAccountClient;
import com.google.gct.login.GoogleAccountClientImpl;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.GoogleLoginImpl;
import com.google.gct.login.GoogleLoginPrefs;
import com.google.gct.login.GoogleLoginState;
import com.google.gct.login.GoogleOAuthServer;
import com.google.gct.login.IGoogleLoginCompletedCallback;
import com.google.gct.login.LoginState;
import com.google.gct.login.LoginStatus;
import com.google.gct.login.OAuthScopeRegistry;
import com.google.gct.login.OAuthServer;
import com.google.gct.login.StudioClientInfoKt;
import com.google.gct.login.common.OAuthData;
import com.google.gct.login.common.OAuthDataKt;
import com.google.gct.login.common.OAuthDataStore;
import com.google.gct.login.common.UiFacade;
import com.google.wireless.android.sdk.stats.GoogleLoginPluginEvent;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.serviceContainer.NonInjectable;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001:B7\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fB\t\b\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0010J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\rH\u0016J\u0018\u0010'\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010\rH\u0096@\u00a2\u0006\u0002\u0010)J\u001c\u0010'\u001a\u00020%2\b\u0010(\u001a\u0004\u0018\u00010\r2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0018\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001aH\u0016J\u0010\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020\u001aH\u0002J\b\u00105\u001a\u00020%H\u0002J\b\u00106\u001a\u00020%H\u0016J\f\u00107\u001a\u00020\u001e*\u000208H\u0002J\b\u00109\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u00020\u00148\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001e0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u0004\u0018\u00010\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0016\u00101\u001a\u0004\u0018\u0001028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006;"}, d2={"Lcom/google/gct/login/GoogleLoginImpl;", "Lcom/google/gct/login/GoogleLogin;", "Lcom/intellij/openapi/Disposable;", "accountClient", "Lcom/google/gct/login/GoogleAccountClient;", "uiFacade", "Lcom/google/gct/login/common/UiFacade;", "oAuthServer", "Lcom/google/gct/login/OAuthServer;", "loginPrefs", "Lcom/google/gct/login/GoogleLoginPrefs;", "oAuthScopes", "Ljava/util/SortedSet;", "", "<init>", "(Lcom/google/gct/login/GoogleAccountClient;Lcom/google/gct/login/common/UiFacade;Lcom/google/gct/login/OAuthServer;Lcom/google/gct/login/GoogleLoginPrefs;Ljava/util/SortedSet;)V", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "users", "Lcom/google/gct/login/CredentialedUserRoster;", "getUsers$google_login_as", "()Lcom/google/gct/login/CredentialedUserRoster;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "isLoggedIn", "", "()Z", "allUsers", "", "Lcom/google/gct/login/CredentialedUser;", "getAllUsers", "()Ljava/util/Map;", "activeUser", "getActiveUser", "()Lcom/google/gct/login/CredentialedUser;", "setActiveUser", "", "userEmail", "logIn", "message", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loginCompletedCallback", "Lcom/google/gct/login/IGoogleLoginCompletedCallback;", "logOut", "showPrompt", "isForced", "logOutAllUsers", "forceLogout", "currentProject", "Lcom/intellij/openapi/project/Project;", "getCurrentProject", "()Lcom/intellij/openapi/project/Project;", "initializeUsers", "dispose", "createCredentialedUser", "Lcom/google/gct/login/GoogleLoginState;", "notifyNoActiveUser", "AndroidPreferencesOAuthDataStore", "google-login-as"})
@SourceDebugExtension(value={"SMAP\nGoogleLogin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleLogin.kt\ncom/google/gct/login/GoogleLoginImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,375:1\n24#2:376\n40#3,3:377\n40#3,3:391\n40#3,3:398\n40#3,3:402\n310#4,11:380\n1863#5,2:394\n1863#5,2:396\n1#6:401\n*S KotlinDebug\n*F\n+ 1 GoogleLogin.kt\ncom/google/gct/login/GoogleLoginImpl\n*L\n135#1:376\n179#1:377,3\n265#1:391,3\n343#1:398,3\n370#1:402,3\n183#1:380,11\n272#1:394,2\n306#1:396,2\n*E\n"})
public final class GoogleLoginImpl
implements GoogleLogin,
Disposable {
    @NotNull
    private final GoogleAccountClient accountClient;
    @NotNull
    private final UiFacade uiFacade;
    @NotNull
    private final OAuthServer oAuthServer;
    @NotNull
    private final GoogleLoginPrefs loginPrefs;
    @NotNull
    private final SortedSet<String> oAuthScopes;
    @NotNull
    private final Logger logger;
    @VisibleForTesting
    @NotNull
    private final CredentialedUserRoster users;
    @NotNull
    private final CoroutineScope scope;

    @NonInjectable
    public GoogleLoginImpl(@NotNull GoogleAccountClient accountClient, @NotNull UiFacade uiFacade, @NotNull OAuthServer oAuthServer, @NotNull GoogleLoginPrefs loginPrefs, @NotNull SortedSet<String> oAuthScopes) {
        Intrinsics.checkNotNullParameter((Object)accountClient, (String)"accountClient");
        Intrinsics.checkNotNullParameter((Object)uiFacade, (String)"uiFacade");
        Intrinsics.checkNotNullParameter((Object)oAuthServer, (String)"oAuthServer");
        Intrinsics.checkNotNullParameter((Object)loginPrefs, (String)"loginPrefs");
        Intrinsics.checkNotNullParameter(oAuthScopes, (String)"oAuthScopes");
        this.accountClient = accountClient;
        this.uiFacade = uiFacade;
        this.oAuthServer = oAuthServer;
        this.loginPrefs = loginPrefs;
        this.oAuthScopes = oAuthScopes;
        GoogleLoginImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GoogleLoginImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.users = new CredentialedUserRoster();
        this.scope = CoroutineUtilsKt.AndroidCoroutineScope$default((Disposable)this, null, (int)2, null);
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GoogleLoginImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        String testModeUser = System.getenv("GOOGLE_LOGIN_USER");
                        if (testModeUser != null) {
                            this.this$0.logger.info("Added fake Google user: " + testModeUser);
                            this.this$0.getUsers$google_login_as().addUser(new CredentialedUser(testModeUser));
                            boolean $i$f$service = false;
                            Class<LoginState> serviceClass$iv = LoginState.class;
                            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                            if (object2 == null) {
                                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                            }
                            Boxing.boxBoolean((boolean)((LoginState)object2).updateStatus$google_login_as(new LoginStatus.LoggedIn(testModeUser)));
                        } else {
                            this.this$0.initializeUsers();
                            if (this.this$0.isLoggedIn()) {
                                GoogleLoginState.trackEvent(GoogleLoginPluginEvent.EventKind.LOGGED_IN_ON_STUDIO_START);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public GoogleLoginImpl() {
        GoogleAccountClient googleAccountClient = new GoogleAccountClientImpl();
        String string = StudioClientInfoKt.getStudioClientInfo().getDetails().getClientId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClientId(...)");
        UiFacade uiFacade = new AndroidUiFacade(string);
        OAuthServer oAuthServer = GoogleOAuthServer.INSTANCE;
        GoogleLoginPrefs googleLoginPrefs = GoogleLoginPrefs.Companion.getINSTANCE();
        SortedSet<String> sortedSet = OAuthScopeRegistry.getScopes();
        Intrinsics.checkNotNullExpressionValue(sortedSet, (String)"getScopes(...)");
        this(googleAccountClient, uiFacade, oAuthServer, googleLoginPrefs, sortedSet);
    }

    @NotNull
    public final CredentialedUserRoster getUsers$google_login_as() {
        return this.users;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLoggedIn() {
        boolean bl;
        Object object = this.users.getActiveUser();
        if (object != null && (object = ((CredentialedUser)object).googleLoginState) != null) {
            if (((GoogleLoginState)object).isLoggedIn()) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        String string = System.getenv("GOOGLE_LOGIN_USER");
        if (string == null) return false;
        CredentialedUser credentialedUser = this.users.getActiveUser();
        if (!string.equals(credentialedUser != null ? credentialedUser.email : null)) return false;
        return true;
    }

    @Override
    @NotNull
    public Map<String, CredentialedUser> getAllUsers() {
        LinkedHashMap<String, CredentialedUser> linkedHashMap = this.users.getAllUsers();
        Intrinsics.checkNotNullExpressionValue(linkedHashMap, (String)"getAllUsers(...)");
        return linkedHashMap;
    }

    @Override
    @Nullable
    public CredentialedUser getActiveUser() {
        return this.users.getActiveUser();
    }

    @Override
    public void setActiveUser(@NotNull String userEmail) {
        Intrinsics.checkNotNullParameter((Object)userEmail, (String)"userEmail");
        this.users.setActiveUser(userEmail);
        boolean $i$f$service = false;
        Class<LoginState> serviceClass$iv = LoginState.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((LoginState)object).updateStatus$google_login_as(new LoginStatus.LoggedIn(userEmail));
    }

    @Override
    @Nullable
    public Object logIn(@Nullable String message, @NotNull Continuation<? super Boolean> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Boolean> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        CredentialedUser lastActiveUser = this.getUsers$google_login_as().getActiveUser();
        this.getUsers$google_login_as().removeActiveUser();
        GoogleLoginState googleLoginState = GoogleLoginState.create(StudioClientInfoKt.getStudioClientInfo(), this.oAuthScopes, new AndroidPreferencesOAuthDataStore(), this.uiFacade, this.oAuthServer);
        Intrinsics.checkNotNullExpressionValue((Object)googleLoginState, (String)"create(...)");
        GoogleLoginState state = googleLoginState;
        Project project2 = (Project)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Project>(this){
            final /* synthetic */ GoogleLoginImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final Project invoke() {
                return GoogleLoginImpl.access$getCurrentProject(this.this$0);
            }
        }));
        Task.Modal task2 = new Task.Modal(project2, state, message, this, (CancellableContinuation<? super Boolean>)cont, lastActiveUser){
            private boolean loggedIn;
            final /* synthetic */ GoogleLoginState $state;
            final /* synthetic */ String $message;
            final /* synthetic */ GoogleLoginImpl this$0;
            final /* synthetic */ CancellableContinuation<Boolean> $cont;
            final /* synthetic */ CredentialedUser $lastActiveUser;
            {
                this.$state = $state;
                this.$message = $message;
                this.this$0 = $receiver;
                this.$cont = $cont;
                this.$lastActiveUser = $lastActiveUser;
                super($project, "Please sign in via the opened browser...", true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                if (!(indicator instanceof ProgressIndicatorEx)) {
                    return;
                }
                ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(this.this$0){
                    final /* synthetic */ GoogleLoginImpl this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void cancel() {
                        GoogleLoginImpl.access$getUiFacade$p(this.this$0).stop();
                        super.cancel();
                    }
                });
                this.loggedIn = this.$state.logIn(this.$message);
            }

            public void onCancel() {
                this.notifyOnComplete();
            }

            public void onSuccess() {
                this.notifyOnComplete();
            }

            private final void notifyOnComplete() {
                if (this.loggedIn) {
                    BuildersKt.launch$default((CoroutineScope)GoogleLoginImpl.access$getScope$p(this.this$0), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$state, this.$cont, null){
                        int label;
                        final /* synthetic */ GoogleLoginImpl this$0;
                        final /* synthetic */ GoogleLoginState $state;
                        final /* synthetic */ CancellableContinuation<Boolean> $cont;
                        {
                            this.this$0 = $receiver;
                            this.$state = $state;
                            this.$cont = $cont;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.this$0.getUsers$google_login_as().addUser(GoogleLoginImpl.access$createCredentialedUser(this.this$0, this.$state));
                                    boolean $i$f$service = false;
                                    Class<LoginState> serviceClass$iv = LoginState.class;
                                    Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                                    if (object2 == null) {
                                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                                    }
                                    ((LoginState)object2).updateStatus$google_login_as(new LoginStatus.LoggedIn(this.$state.getEmail()));
                                    ((Continuation)this.$cont).resumeWith(Result.constructor-impl((Object)Boxing.boxBoolean((boolean)true)));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                } else {
                    this.restoreLastActiveUser();
                    ((Continuation)this.$cont).resumeWith(Result.constructor-impl((Object)false));
                }
            }

            private final void restoreLastActiveUser() {
                if (this.$lastActiveUser != null) {
                    this.this$0.getUsers$google_login_as().setActiveUser(this.$lastActiveUser.email);
                }
            }
        };
        ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(task2){
            final /* synthetic */ logIn.2.task.1 $task;
            {
                this.$task = $task;
            }

            public final void invoke() {
                this.$task.queue();
            }
        }));
        cont.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ GoogleLoginImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void invoke(Throwable it) {
                GoogleLoginImpl.access$getUiFacade$p(this.this$0).stop();
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Override
    public void logIn(@Nullable String message, @Nullable IGoogleLoginCompletedCallback loginCompletedCallback) {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, message, null){
            int label;
            final /* synthetic */ GoogleLoginImpl this$0;
            final /* synthetic */ String $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.logIn(this.$message, (Continuation<? super Boolean>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null).invokeOnCompletion(arg_0 -> GoogleLoginImpl.logIn$lambda$1(loginCompletedCallback, arg_0));
    }

    @Override
    public boolean logOut(boolean showPrompt, boolean isForced) {
        boolean loggedOut;
        CredentialedUser credentialedUser = this.users.getActiveUser();
        if (credentialedUser == null) {
            return false;
        }
        CredentialedUser activeUser = credentialedUser;
        GoogleLoginState googleLoginState = activeUser.googleLoginState;
        boolean bl = loggedOut = googleLoginState != null ? googleLoginState.logOut(showPrompt, isForced) : true;
        if (loggedOut) {
            this.logOutAllUsers(isForced);
            boolean $i$f$service = false;
            Class<LoginState> serviceClass$iv = LoginState.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((LoginState)object).updateStatus$google_login_as(LoginStatus.LoggedOut.INSTANCE);
        }
        return loggedOut;
    }

    private final void logOutAllUsers(boolean forceLogout) {
        Collection<CredentialedUser> collection = this.users.getAllUsers().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CredentialedUser user = (CredentialedUser)element$iv;
            boolean bl = false;
            GoogleLoginState googleLoginState = user.googleLoginState;
            if (googleLoginState == null) continue;
            googleLoginState.logOut(false, forceLogout);
        }
        this.users.removeAllUsers();
    }

    private final Project getCurrentProject() {
        Window window = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (window == null) {
            return null;
        }
        Window activeWindow = window;
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)activeWindow);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return (Project)CommonDataKeys.PROJECT.getData(dataContext);
    }

    private final void initializeUsers() {
        String activeUserString = null;
        activeUserString = this.loginPrefs.getActiveUser();
        List<String> allUsers = this.loginPrefs.getStoredUsers();
        Object removedUsers = null;
        removedUsers = "";
        Iterable $this$forEach$iv = allUsers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GoogleLoginState state;
            GoogleLoginState delegate;
            String user = (String)element$iv;
            boolean bl = false;
            this.users.addUser(new CredentialedUser(user));
            Intrinsics.checkNotNullExpressionValue((Object)GoogleLoginState.create(StudioClientInfoKt.getStudioClientInfo(), this.oAuthScopes, new AndroidPreferencesOAuthDataStore(), this.uiFacade, this.oAuthServer), (String)"create(...)");
            GoogleLoginState googleLoginState = delegate = !state.isLoggedIn() ? null : state;
            if (delegate == null) {
                removedUsers = removedUsers + user + ", ";
                if (Intrinsics.areEqual((Object)user, (Object)activeUserString)) {
                    activeUserString = null;
                }
                this.users.removeUser(user);
                continue;
            }
            this.users.addUser(this.createCredentialedUser(delegate));
        }
        if (activeUserString == null) {
            this.users.removeActiveUser();
            this.notifyNoActiveUser();
        } else {
            try {
                this.users.setActiveUser(activeUserString);
                boolean $i$f$service = false;
                Class<LoginState> serviceClass$iv = LoginState.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                boolean bl = ((LoginState)object).updateStatus$google_login_as(new LoginStatus.LoggedIn(activeUserString));
            }
            catch (IllegalArgumentException ex) {
                this.logger.warn("Error while initiating users", (Throwable)ex);
                this.users.removeActiveUser();
                boolean bl = this.notifyNoActiveUser();
            }
        }
        if (((CharSequence)removedUsers).length() > 0) {
            this.logger.info("The following user(s) had expired authentication scopes: " + removedUsers + " and have been logged out.");
        }
    }

    public void dispose() {
    }

    private final CredentialedUser createCredentialedUser(GoogleLoginState $this$createCredentialedUser) {
        Image image;
        Userinfo userInfo;
        Credential credential = $this$createCredentialedUser.makeCredential();
        Intrinsics.checkNotNull((Object)credential);
        Userinfo userinfo = userInfo = this.accountClient.getUserInfo(credential);
        if (userinfo != null) {
            Userinfo it = userinfo;
            boolean bl = false;
            image = this.accountClient.getUserPicture(it);
        } else {
            image = null;
        }
        Image image2 = image;
        Userinfo userinfo2 = userInfo;
        return new CredentialedUser($this$createCredentialedUser, credential, userinfo2 != null ? userinfo2.getName() : null, image2);
    }

    private final boolean notifyNoActiveUser() {
        boolean $i$f$service = false;
        Class<LoginState> serviceClass$iv = LoginState.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((LoginState)object).updateStatus$google_login_as(this.users.getAllUsers().isEmpty() ? (LoginStatus)LoginStatus.LoggedOut.INSTANCE : (LoginStatus)new LoginStatus.LoggedIn(null));
    }

    private static final Unit logIn$lambda$1(IGoogleLoginCompletedCallback $loginCompletedCallback, Throwable it) {
        block0: {
            IGoogleLoginCompletedCallback iGoogleLoginCompletedCallback = $loginCompletedCallback;
            if (iGoogleLoginCompletedCallback == null) break block0;
            iGoogleLoginCompletedCallback.onLoginCompleted();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getCurrentProject(GoogleLoginImpl $this) {
        return $this.getCurrentProject();
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(GoogleLoginImpl $this) {
        return $this.scope;
    }

    public static final /* synthetic */ CredentialedUser access$createCredentialedUser(GoogleLoginImpl $this, GoogleLoginState $receiver) {
        return $this.createCredentialedUser($receiver);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lcom/google/gct/login/GoogleLoginImpl$AndroidPreferencesOAuthDataStore;", "Lcom/google/gct/login/common/OAuthDataStore;", "<init>", "(Lcom/google/gct/login/GoogleLoginImpl;)V", "saveOAuthData", "", "credentials", "Lcom/google/gct/login/common/OAuthData;", "loadOAuthData", "clearStoredOAuthData", "google-login-as"})
    @SourceDebugExtension(value={"SMAP\nGoogleLogin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleLogin.kt\ncom/google/gct/login/GoogleLoginImpl$AndroidPreferencesOAuthDataStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,375:1\n1#2:376\n*E\n"})
    private final class AndroidPreferencesOAuthDataStore
    implements OAuthDataStore {
        @Override
        public void saveOAuthData(@NotNull OAuthData credentials) {
            Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
            GoogleLoginImpl.this.loginPrefs.saveOAuthData(credentials);
        }

        @Override
        @NotNull
        public OAuthData loadOAuthData() {
            CredentialedUser user = GoogleLoginImpl.this.getActiveUser();
            return user == null ? OAuthDataKt.getNullOAuthData() : GoogleLoginImpl.this.loginPrefs.loadOAuthData(user.email);
        }

        @Override
        public void clearStoredOAuthData() {
            block0: {
                CredentialedUser credentialedUser = GoogleLoginImpl.this.getActiveUser();
                if (credentialedUser == null) break block0;
                CredentialedUser credentialedUser2 = credentialedUser;
                GoogleLoginImpl googleLoginImpl = GoogleLoginImpl.this;
                CredentialedUser it = credentialedUser2;
                boolean bl = false;
                googleLoginImpl.loginPrefs.clearStoredOAuthData(it.email);
            }
        }
    }
}

